/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.jvm;

import com.google.common.annotations.Beta;
import com.sun.management.OperatingSystemMXBean;
import com.sun.management.ThreadMXBean;
import java.util.OptionalDouble;
import sun.misc.VM;

@Beta
public class ApexForOracleJVM {
    public static final String GARBAGE_COLLECTION_NOTIFICATION = "com.sun.management.gc.notification";

    protected ApexForOracleJVM() {
    }

    public static long maxDirectMemory() {
        return VM.maxDirectMemory();
    }

    public static OptionalDouble getCpu(java.lang.management.OperatingSystemMXBean osMbean) {
        if (osMbean instanceof OperatingSystemMXBean) {
            double cpu = ((OperatingSystemMXBean)osMbean).getProcessCpuLoad();
            return OptionalDouble.of(cpu);
        }
        return OptionalDouble.empty();
    }

    public static long getThreadAllocatedBytes(java.lang.management.ThreadMXBean threadMbean, long l) {
        if (threadMbean instanceof ThreadMXBean) {
            return ((ThreadMXBean)threadMbean).getThreadAllocatedBytes(l);
        }
        return -1L;
    }

    public static boolean isThreadAllocatedMemorySupported(java.lang.management.ThreadMXBean threadMbean) {
        if (threadMbean instanceof ThreadMXBean) {
            return ((ThreadMXBean)threadMbean).isThreadAllocatedMemorySupported();
        }
        return false;
    }

    public static boolean isThreadAllocatedMemoryEnabled(java.lang.management.ThreadMXBean threadMbean) {
        if (threadMbean instanceof ThreadMXBean) {
            return ((ThreadMXBean)threadMbean).isThreadAllocatedMemoryEnabled();
        }
        return false;
    }

    public static void setThreadAllocatedMemoryEnabled(java.lang.management.ThreadMXBean threadMbean, boolean enable) {
        if (threadMbean instanceof ThreadMXBean) {
            ((ThreadMXBean)threadMbean).setThreadAllocatedMemoryEnabled(enable);
        }
    }
}

