/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.thread;

import blasd.apex.core.thread.NamingForkJoinWorkerThreadFactory;
import blasd.apex.core.thread.OfferWithTimeoutPolicy;
import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class ApexExecutorsHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexExecutorsHelper.class);
    public static final int DEFAULT_LOG_ON_SLOW_QUEUE_MS = 1000;
    public static final int DEFAULT_PARTITION_TASK_SIZE = 1023;
    public static final int DEFAULT_MINIMUM_QUEUE_SIZE = 16;
    @Deprecated
    public static final int DEFAULT_SPLIT_TASK_SIZE = 1023;
    public static final RejectedExecutionHandler TIMEOUT_POLICY_1_HOUR = ApexExecutorsHelper.makeRejectedExecutionHandler(1, TimeUnit.HOURS);
    public static final RejectedExecutionHandler DEFAULT_ABORT_POLICY;
    public static final RejectedExecutionHandler DEFAULT_REJECTION_POLICY;
    public static final int DEFAULT_QUEUE_CAPACITY = Integer.MAX_VALUE;
    public static final int DEFAULT_NB_CORES;
    public static final int DEFAULT_ACTIVE_TASKS;
    public static final int CORE_KEEP_ALIVE_IN_SECONDS = 60;
    private static final Callable<Object> NOOP_CALLABLE;
    protected static boolean allowTryMax;
    private static final Function<Runnable, Callable<Object>> RUNNABLE_TO_CALLABLE;
    private static final int MAX_CAP = Short.MAX_VALUE;

    protected ApexExecutorsHelper() {
    }

    public static ListeningExecutorService newSingleThreadExecutor(String threadNamePrefix) {
        return ApexExecutorsHelper.newSingleThreadExecutor(threadNamePrefix, Integer.MAX_VALUE, DEFAULT_REJECTION_POLICY);
    }

    public static ListeningExecutorService newSingleThreadExecutor(String threadNamePrefix, int queueCapacity, RejectedExecutionHandler rejectedExecutionHandler) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        return MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, queue, ApexExecutorsHelper.makeDaemonThreadFactory(threadNamePrefix), rejectedExecutionHandler));
    }

    public static ListeningScheduledExecutorService newSingleThreadScheduledExecutor(String threadNamePrefix) {
        return ApexExecutorsHelper.newSingleThreadScheduledExecutor(threadNamePrefix, DEFAULT_REJECTION_POLICY);
    }

    public static ListeningScheduledExecutorService newSingleThreadScheduledExecutor(String threadNamePrefix, RejectedExecutionHandler rejectedExecutionHandler) {
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, ApexExecutorsHelper.makeDaemonThreadFactory(threadNamePrefix), rejectedExecutionHandler));
    }

    public static ThreadFactory makeDaemonThreadFactory(String threadNamePrefix) {
        CustomizableThreadFactory ctf = new CustomizableThreadFactory(threadNamePrefix);
        ctf.setDaemon(true);
        return ctf;
    }

    public static int getDefaultNbThreads() {
        return DEFAULT_NB_CORES;
    }

    public static ListeningExecutorService newShrinkableFixedThreadPool(String threadNamePrefix) {
        return ApexExecutorsHelper.newShrinkableFixedThreadPool(ApexExecutorsHelper.getDefaultNbThreads(), threadNamePrefix);
    }

    public static ListeningExecutorService newShrinkableFixedThreadPool(int maxThreads, String threadNamePrefix) {
        long queueCapacity = 16L + (long)maxThreads * (long)maxThreads;
        int queueCapacityAsInt = Ints.saturatedCast((long)queueCapacity);
        queueCapacityAsInt = Integer.MAX_VALUE;
        return ApexExecutorsHelper.newShrinkableFixedThreadPool(maxThreads, threadNamePrefix, queueCapacityAsInt, DEFAULT_REJECTION_POLICY);
    }

    public static ListeningExecutorService newShrinkableFixedThreadPool(String threadNamePrefix, int queueCapacity, RejectedExecutionHandler rejectedExecutionHandler) {
        return ApexExecutorsHelper.newShrinkableFixedThreadPool(ApexExecutorsHelper.getDefaultNbThreads(), threadNamePrefix, queueCapacity, rejectedExecutionHandler);
    }

    public static ListeningExecutorService newShrinkableFixedThreadPool(int nbThreads, String threadNamePrefix, int queueCapacity, RejectedExecutionHandler rejectedExecutionHandler) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(queueCapacity);
        ThreadPoolExecutor tpExecutor = new ThreadPoolExecutor(nbThreads, nbThreads, 60L, TimeUnit.SECONDS, queue, ApexExecutorsHelper.makeDaemonThreadFactory(threadNamePrefix), rejectedExecutionHandler);
        tpExecutor.allowCoreThreadTimeOut(true);
        return MoreExecutors.listeningDecorator((ExecutorService)tpExecutor);
    }

    public static ListeningExecutorService newShrinkableCachedThreadPool(String threadNamePrefix, RejectedExecutionHandler rejectedExecutionHandler) {
        ThreadPoolExecutor tpExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ApexExecutorsHelper.makeDaemonThreadFactory(threadNamePrefix), rejectedExecutionHandler);
        tpExecutor.allowCoreThreadTimeOut(true);
        return MoreExecutors.listeningDecorator((ExecutorService)tpExecutor);
    }

    public static ListeningScheduledExecutorService newShrinkableScheduledThreadPool(String threadNamePrefix) {
        return ApexExecutorsHelper.newShrinkableScheduledThreadPool(threadNamePrefix, DEFAULT_REJECTION_POLICY);
    }

    public static ListeningScheduledExecutorService newShrinkableScheduledThreadPool(String threadNamePrefix, RejectedExecutionHandler rejectedExecutionHandler) {
        int nbThreads = ApexExecutorsHelper.getDefaultNbThreads();
        ScheduledThreadPoolExecutor tpExecutor = new ScheduledThreadPoolExecutor(nbThreads, ApexExecutorsHelper.makeDaemonThreadFactory(threadNamePrefix), rejectedExecutionHandler);
        tpExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        tpExecutor.allowCoreThreadTimeOut(true);
        return MoreExecutors.listeningDecorator((ScheduledExecutorService)tpExecutor);
    }

    @Deprecated
    public static RejectedExecutionHandler makeRejectedExecutionHandler(int timeout, TimeUnit unit) {
        return new OfferWithTimeoutPolicy(timeout, unit);
    }

    public static <T> List<? extends ListenableFuture<T>> invokeAll(Collection<? extends Supplier<? extends T>> tasks, ListeningExecutorService executorService) throws InterruptedException {
        Collection callables = Collections2.transform(tasks, ApexExecutorsHelper.supplierToCallable());
        return executorService.invokeAll(callables);
    }

    private static <T> Function<Callable<? extends T>, Callable<T>> callableToCallable() {
        return input -> () -> input.call();
    }

    private static <T> Function<Supplier<? extends T>, Callable<T>> supplierToCallable() {
        return new Function<Supplier<? extends T>, Callable<T>>(){

            public Callable<T> apply(Supplier<? extends T> input) {
                return () -> input.get();
            }
        };
    }

    public static <T> List<? extends ListenableFuture<T>> invokeAll(Collection<? extends Callable<? extends T>> tasks, ListeningExecutorService executorService, long timeout, TimeUnit unit) throws InterruptedException {
        Collection callables = Collections2.transform(tasks, ApexExecutorsHelper.callableToCallable());
        return executorService.invokeAll(callables, timeout, unit);
    }

    public static void executeAllRunnable(Collection<? extends Runnable> tasks, ListeningExecutorService executorService) throws InterruptedException {
        ApexExecutorsHelper.invokeAllRunnable(tasks, executorService, Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    public static List<? extends ListenableFuture<?>> invokeAllRunnable(Collection<? extends Runnable> tasks, ListeningExecutorService executorService, long timeout, TimeUnit unit) throws InterruptedException {
        return ApexExecutorsHelper.invokeAll(Collections2.transform(tasks, RUNNABLE_TO_CALLABLE), executorService, timeout, unit);
    }

    public static <T, V> Iterator<? extends Supplier<V>> partitions(Iterator<T> input, Function<? super List<T>, V> function) {
        return ApexExecutorsHelper.partitions(input, function, 1023);
    }

    public static <T, V> Iterator<? extends Supplier<V>> partitions(Iterator<T> input, Function<? super List<T>, V> function, int partitionSize) {
        UnmodifiableIterator underlyingIterator = Iterators.partition(input, (int)partitionSize);
        return new AbstractIterator<Supplier<V>>((Iterator)underlyingIterator, function){
            final /* synthetic */ Iterator val$underlyingIterator;
            final /* synthetic */ Function val$function;
            {
                this.val$underlyingIterator = iterator;
                this.val$function = function;
            }

            protected Supplier<V> computeNext() {
                if (this.val$underlyingIterator.hasNext()) {
                    List next = (List)this.val$underlyingIterator.next();
                    return () -> this.val$function.apply((Object)next);
                }
                return (Supplier)this.endOfData();
            }
        };
    }

    public static <T, V> Iterator<? extends Runnable> partitions(Iterator<T> input, Consumer<? super List<T>> consumer) {
        return ApexExecutorsHelper.partitions(input, consumer, 1023);
    }

    public static <T> Iterator<? extends Runnable> partitions(Iterator<T> input, final Consumer<? super List<T>> consumer, int partitionSize) {
        final UnmodifiableIterator underlyingIterator = Iterators.partition(input, (int)partitionSize);
        return new AbstractIterator<Runnable>(){

            protected Runnable computeNext() {
                if (underlyingIterator.hasNext()) {
                    List next = (List)underlyingIterator.next();
                    return () -> consumer.accept(next);
                }
                return (Runnable)this.endOfData();
            }
        };
    }

    public static ForkJoinPool newForkJoinPool(String threadPrefix) {
        return ApexExecutorsHelper.newForkJoinPool(threadPrefix, ApexExecutorsHelper.defaultForkJoinPoolParallelism());
    }

    private static int defaultForkJoinPoolParallelism() {
        return Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors());
    }

    public static ForkJoinPool newForkJoinPool(String threadPrefix, int parallelism) {
        return new ForkJoinPool(parallelism, new NamingForkJoinWorkerThreadFactory(threadPrefix), null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long consumeByTimeBlock(Consumer<Long> c, Stream<T> conditionsToUpdate, int niceTransactionSeconds, Object object) {
        Iterator iterator = conditionsToUpdate.iterator();
        long nbTransactions = 0L;
        while (iterator.hasNext()) {
            try {
                long start = System.currentTimeMillis();
                c.accept(start);
            }
            finally {
                ++nbTransactions;
            }
        }
        return nbTransactions;
    }

    static {
        DEFAULT_REJECTION_POLICY = DEFAULT_ABORT_POLICY = new ThreadPoolExecutor.AbortPolicy();
        DEFAULT_NB_CORES = Runtime.getRuntime().availableProcessors();
        DEFAULT_ACTIVE_TASKS = DEFAULT_NB_CORES * 2;
        NOOP_CALLABLE = () -> null;
        allowTryMax = false;
        RUNNABLE_TO_CALLABLE = task -> {
            if (task == null) {
                return NOOP_CALLABLE;
            }
            return Executors.callable(task);
        };
    }
}

