/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.util;

import blasd.apex.core.logging.ApexLogHelper;
import com.google.common.annotations.VisibleForTesting;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexTimeHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexTimeHelper.class);
    protected static final long NB_OCCURENCES_FOR_INFO = 1000L;
    @VisibleForTesting
    public static final AtomicLong NB_LOG_FOR_OUTLIER = new AtomicLong();

    protected ApexTimeHelper() {
    }

    @Deprecated
    public static Object getNiceTimeInTransaction(long timeInMs) {
        return ApexLogHelper.getNiceTime(timeInMs);
    }

    @Deprecated
    public static String getNiceRate(long nbEntries, long time, TimeUnit timeUnit) {
        return ApexLogHelper.getNiceRate(nbEntries, time, timeUnit).toString();
    }

    @Deprecated
    public static Object getPercentage(long numerator, long denominator, int digits) {
        return ApexLogHelper.getNicePercentage(numerator, denominator);
    }

    public static boolean updateOutlierDetectorStatistics(AtomicLong nb, AtomicLong max, long newValue, Object className, Object methodName, Object ... more) {
        nb.incrementAndGet();
        long currentMax = max.get();
        if (newValue > currentMax) {
            if (max.compareAndSet(currentMax, newValue)) {
                if (nb.get() > 1000L) {
                    NB_LOG_FOR_OUTLIER.incrementAndGet();
                    if (more != null && more.length > 0) {
                        LOGGER.info("{}.{}.{} increased its max from {} to {}", new Object[]{className, methodName, Arrays.asList(more), currentMax, newValue});
                    } else {
                        LOGGER.info("{}.{} increased its max from {} to {}", new Object[]{className, methodName, newValue});
                    }
                }
            } else {
                LOGGER.trace("Race-condition. We may have lost a max");
            }
            return true;
        }
        return false;
    }

    public static long jodaToTime(org.joda.time.LocalDateTime localDateTime) {
        return localDateTime.toDate().getTime();
    }

    public static long java8ToTime(LocalDateTime localDateTime) {
        return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }
}

