/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ApexCartesianProductHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexCartesianProductHelper.class);
    public static final Object GROUP_NOT_EXPRESSED = new Object();
    private static final int CARTESIAN_CARDINALITY_LOG = 1000000;

    protected ApexCartesianProductHelper() {
    }

    @Beta
    public static <T, V> Set<? extends Map<T, ? extends Set<V>>> groupByKeyAndInValues(Iterable<? extends Map<? extends T, ? extends V>> input) {
        return ApexCartesianProductHelper.groupByKeyAndInValues(input, any -> LOGGER.trace("Working"));
    }

    public static <T, V> Set<? extends Map<T, ? extends Set<V>>> groupByKeyAndInValues(Iterable<? extends Map<? extends T, ? extends V>> input, Consumer<Object> checkRegularly) {
        if (input instanceof Collection) {
            Collection asCollection = (Collection)input;
            if (asCollection.size() >= 2) {
                LOGGER.debug("Compute covering cartesian products over {} entries", (Object)asCollection.size());
            } else {
                LOGGER.trace("Compute covering cartesian products over {} entries", (Object)asCollection.size());
            }
        } else {
            LOGGER.debug("Compute covering cartesian products over an Iterable");
        }
        LinkedHashMap<Set<T>, SetMultimap<T, V>> keysToKeyToEncountered = new LinkedHashMap<Set<T>, SetMultimap<T, V>>();
        LinkedHashMap<Set<T>, Set<Map<T, V>>> keysToFlatMap = new LinkedHashMap<Set<T>, Set<Map<T, V>>>();
        ApexCartesianProductHelper.flattenInput(input, keysToKeyToEncountered, keysToFlatMap);
        if (LOGGER.isTraceEnabled()) {
            for (Map.Entry entry : keysToFlatMap.entrySet()) {
                LOGGER.trace("We flatten to {} entries for {}", (Object)((Set)entry.getValue()).size(), entry.getKey());
            }
        }
        Set<Set<T>> impactedKeySets = ApexCartesianProductHelper.removeRedundantConditions(keysToKeyToEncountered, keysToFlatMap);
        for (Set<T> set : impactedKeySets) {
            keysToKeyToEncountered.remove(set);
            Set impactedKeySetFlatMaps = (Set)keysToFlatMap.remove(set);
            assert (impactedKeySetFlatMaps != null);
            ApexCartesianProductHelper.flattenInput(impactedKeySetFlatMaps, keysToKeyToEncountered, keysToFlatMap);
        }
        LinkedHashSet<Map<T, Set<V>>> coveringMaps = new LinkedHashSet<Map<T, Set<V>>>();
        for (Map.Entry entry : keysToKeyToEncountered.entrySet()) {
            Set keyset = (Set)entry.getKey();
            coveringMaps.addAll(ApexCartesianProductHelper.computeCoveringMaps(keyset, (SetMultimap)entry.getValue(), (Set)keysToFlatMap.get(keyset)));
        }
        return coveringMaps;
    }

    protected static <T, V> Set<Set<T>> removeRedundantConditions(Map<Set<T>, SetMultimap<T, V>> keysToKeyToEncountered, Map<Set<T>, Set<Map<T, V>>> keysToFlatMap) {
        HashSet impactedKeySet = new HashSet();
        Sets.cartesianProduct(Arrays.asList(keysToFlatMap.keySet(), keysToFlatMap.keySet())).stream().filter(list -> ((Set)list.get(0)).size() > ((Set)list.get(1)).size()).filter(list -> ((Set)list.get(0)).containsAll((Collection)list.get(1))).forEach(list -> {
            Set biggerKeySet = (Set)list.get(0);
            Set smallerKeySet = (Set)list.get(1);
            for (Map smallestCondition : (Set)keysToFlatMap.get(smallerKeySet)) {
                Iterator biggestConditionIt = ((Set)keysToFlatMap.get(biggerKeySet)).iterator();
                while (biggestConditionIt.hasNext()) {
                    Map biggestCondition = (Map)biggestConditionIt.next();
                    if (!biggestCondition.entrySet().containsAll(smallestCondition.entrySet())) continue;
                    biggestConditionIt.remove();
                    impactedKeySet.add(biggerKeySet);
                }
            }
        });
        return impactedKeySet;
    }

    protected static <T, V> void flattenInput(Iterable<? extends Map<? extends T, ? extends V>> input, Map<Set<T>, SetMultimap<T, V>> keysToKeyToEncountered, Map<Set<T>, Set<Map<T, V>>> keysToFlatMap) {
        block0: for (Map<T, V> map : input) {
            SetMultimap keyToInValues = keysToKeyToEncountered.get(map.keySet());
            Set<Map<T, V>> flatMaps = keysToFlatMap.get(map.keySet());
            if (keyToInValues == null) {
                assert (flatMaps == null);
                keyToInValues = MultimapBuilder.SetMultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
                flatMaps = new LinkedHashSet<Map<T, V>>();
                LinkedHashSet<? extends T> cleanKeySet = new LinkedHashSet<T>(map.keySet());
                keysToKeyToEncountered.put(cleanKeySet, keyToInValues);
                keysToFlatMap.put(new LinkedHashSet<T>(map.keySet()), flatMaps);
            } else assert (flatMaps != null);
            ArrayList<T> keyWithCollection = new ArrayList<T>();
            ArrayList collectionValues = new ArrayList();
            for (Map.Entry<T, V> entry : map.entrySet()) {
                V value = entry.getValue();
                if (value == null) {
                    LOGGER.debug("We skip {} as it holds a null value", map);
                    continue block0;
                }
                if (value instanceof Collection) {
                    Collection collectionValue = (Collection)value;
                    LinkedHashSet valueAsSet = new LinkedHashSet(collectionValue);
                    if (valueAsSet.size() == 0) {
                        LOGGER.debug("We skip {} as it holds an empty Collection value", map);
                        continue block0;
                    }
                    keyWithCollection.add(entry.getKey());
                    collectionValues.add(valueAsSet);
                    keyToInValues.putAll(entry.getKey(), valueAsSet);
                    continue;
                }
                keyWithCollection.add(entry.getKey());
                collectionValues.add(ImmutableSet.of(value));
                keyToInValues.put(entry.getKey(), value);
            }
            Set allCombinations = Sets.cartesianProduct(collectionValues);
            for (List oneCombination : allCombinations) {
                LinkedHashMap duplicate = new LinkedHashMap();
                for (int i = 0; i < oneCombination.size(); ++i) {
                    duplicate.put(keyWithCollection.get(i), oneCombination.get(i));
                }
                flatMaps.add(duplicate);
            }
        }
    }

    protected static <T, V> Collection<? extends Map<T, ? extends Set<V>>> computeCoveringMaps(Set<T> keySet, SetMultimap<T, V> keyToEncountered, Set<Map<T, V>> flatMaps) {
        if (keyToEncountered.isEmpty()) {
            if (flatMaps.isEmpty()) {
                LOGGER.debug("There is not a single entry to match for keyset={}", keySet);
                return Collections.emptySet();
            }
            if (flatMaps.size() == 1 && flatMaps.iterator().next().isEmpty()) {
                return Collections.singleton(Collections.emptyMap());
            }
            throw new IllegalStateException("keyToEncountered is empty while flatMaps holds " + flatMaps);
        }
        int inputToCoverSize = flatMaps.size();
        long cartesianProductSize = ApexCartesianProductHelper.computeCartesianSize(keyToEncountered);
        assert ((long)inputToCoverSize <= cartesianProductSize);
        if ((long)inputToCoverSize == cartesianProductSize) {
            if (inputToCoverSize >= 2) {
                LOGGER.debug("We have a perfect cartesian product for keyset={} with size {}", keySet, (Object)cartesianProductSize);
            } else {
                LOGGER.trace("We have a perfect cartesian product for keyset={} with size {}", keySet, (Object)cartesianProductSize);
            }
            return Arrays.asList(Multimaps.asMap(keyToEncountered));
        }
        List<T> keysOrderedByInSize = ApexCartesianProductHelper.computeKeysOrder(keyToEncountered);
        Iterator<T> keysToConsider = keysOrderedByInSize.iterator();
        ArrayList<T> subCartesianKeys = new ArrayList<T>();
        while (keysToConsider.hasNext()) {
            T currentSplitKey = keysToConsider.next();
            Set splitValues = keyToEncountered.get(currentSplitKey);
            if (splitValues.size() == 1) continue;
            subCartesianKeys.add(currentSplitKey);
            break;
        }
        SetMultimap reverseCovering = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
        ApexCartesianProductHelper.fillReverseCovering(flatMaps, subCartesianKeys, keySet, keysToConsider, reverseCovering);
        LinkedHashSet coveringMaps = new LinkedHashSet();
        for (Map sharedCounterCovering : reverseCovering.keySet()) {
            Set subCartesian = reverseCovering.get((Object)sharedCounterCovering);
            Set<Map<T, Set<V>>> grouped = ApexCartesianProductHelper.groupByKeyAndInValues(subCartesian);
            for (Map<T, Set<V>> oneGroup : grouped) {
                LinkedHashMap<T, Set<V>> coveringMap = new LinkedHashMap<T, Set<V>>(keySet.size());
                for (T key : keySet) {
                    if (oneGroup.containsKey(key)) {
                        coveringMap.put(key, oneGroup.get(key));
                        continue;
                    }
                    if (sharedCounterCovering.containsKey(key)) {
                        coveringMap.put(key, (Set<V>)sharedCounterCovering.get(key));
                        continue;
                    }
                    LOGGER.warn("We expected to find {} in {} or {}", new Object[]{key, oneGroup, sharedCounterCovering});
                }
                coveringMaps.add(coveringMap);
            }
        }
        return coveringMaps;
    }

    private static <T, V> void fillReverseCovering(Set<Map<T, V>> flatMaps, List<T> subCartesianKeys, Set<T> keySet, Iterator<T> keysToConsider, SetMultimap<Map<T, ? extends Set<V>>, Map<T, V>> reverseCovering) {
        while (!flatMaps.isEmpty()) {
            if (subCartesianKeys.size() + 1 == keySet.size()) {
                LOGGER.debug("We fallback on guaranteed sub-cartesian keyset={} for keyset={}", subCartesianKeys, keySet);
            } else {
                LOGGER.debug("We search for sub-cartesian keyset={} for keyset={}", subCartesianKeys, keySet);
            }
            LinkedHashMap splitKeyToSmallCartesian = new LinkedHashMap();
            SetMultimap splitKeyToFlatMap = MultimapBuilder.SetMultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
            for (Map<T, V> flatMap : flatMaps) {
                Map subCartesianMap = new LinkedHashMap();
                for (T subCartesianKey : subCartesianKeys) {
                    subCartesianMap.put(subCartesianKey, flatMap.get(subCartesianKey));
                }
                splitKeyToFlatMap.put(subCartesianMap, flatMap);
                SetMultimap subCartesian = (SetMultimap)splitKeyToSmallCartesian.get(subCartesianMap);
                if (subCartesian == null) {
                    subCartesian = MultimapBuilder.SetMultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
                    splitKeyToSmallCartesian.put(subCartesianMap, subCartesian);
                }
                for (Map.Entry<T, V> entry : flatMap.entrySet()) {
                    subCartesian.put(entry.getKey(), entry.getValue());
                }
            }
            LinkedHashSet matchingSubCartesianKeys = new LinkedHashSet();
            for (Map subCartesianMap : splitKeyToFlatMap.keySet()) {
                long nbFlatMap = splitKeyToFlatMap.get(subCartesianMap).size();
                SetMultimap cartesian = (SetMultimap)splitKeyToSmallCartesian.get(subCartesianMap);
                long cartesianSize = ApexCartesianProductHelper.computeCartesianSize(cartesian);
                if (cartesianSize != nbFlatMap) continue;
                Map cartesianAsMap = Multimaps.asMap((SetMultimap)cartesian);
                LinkedHashMap difference = new LinkedHashMap(cartesianAsMap);
                difference.keySet().removeAll(subCartesianMap.keySet());
                reverseCovering.put(difference, subCartesianMap);
                matchingSubCartesianKeys.add(subCartesianMap);
            }
            for (Map subCartesianMap : matchingSubCartesianKeys) {
                splitKeyToFlatMap.removeAll(subCartesianMap);
            }
            flatMaps = ImmutableSet.copyOf((Collection)splitKeyToFlatMap.values());
            if (keysToConsider.hasNext()) {
                subCartesianKeys.add(keysToConsider.next());
                continue;
            }
            throw new IllegalStateException("We have depleted keys without covering all maps");
        }
    }

    protected static <T, V> List<T> computeKeysOrder(SetMultimap<T, V> keyToEncountered) {
        ArrayList keysOrderedByInSize = new ArrayList(keyToEncountered.keySet());
        Collections.sort(keysOrderedByInSize, (o1, o2) -> {
            int compareBySize = keyToEncountered.get(o1).size() - keyToEncountered.get(o2).size();
            if (compareBySize != 0) {
                return compareBySize;
            }
            return o1.toString().compareTo(o2.toString());
        });
        return keysOrderedByInSize;
    }

    public static <T> long computeCartesianSize(SetMultimap<T, ?> keyToEncountered) {
        if (keyToEncountered.isEmpty()) {
            return 0L;
        }
        long size = 1L;
        for (Object key : keyToEncountered.keySet()) {
            size *= (long)keyToEncountered.get(key).size();
        }
        return size;
    }

    public static <T> Set<? extends Map<T, ?>> mergeCartesianProducts(Iterable<? extends Set<? extends Map<? extends T, ?>>> templates) {
        return ApexCartesianProductHelper.mergeCartesianProducts(templates, o -> LOGGER.trace("Working..."));
    }

    public static <T> Set<? extends Map<T, ?>> mergeCartesianProducts(Iterable<? extends Set<? extends Map<? extends T, ?>>> templates, Consumer<Object> checkRegularly) {
        if (!templates.iterator().hasNext()) {
            return Collections.emptySet();
        }
        LinkedHashSet simplerTemplates = new LinkedHashSet();
        for (Set<Map<T, ?>> oneGroupTemplates : templates) {
            if (oneGroupTemplates.isEmpty()) {
                return Collections.emptySet();
            }
            Set simplerTemplate = ApexCartesianProductHelper.groupByKeyAndInValues(oneGroupTemplates);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Simplified {} to {}", oneGroupTemplates, simplerTemplate);
            } else {
                LOGGER.debug("Simplified {} templates to {} templates", (Object)oneGroupTemplates.size(), (Object)simplerTemplate.size());
            }
            simplerTemplates.add(simplerTemplate);
        }
        Set cartesianProduct = Sets.cartesianProduct((List)Lists.newArrayList(simplerTemplates));
        int cartesianProductSize = cartesianProduct.size();
        AtomicLong nbChecked = new AtomicLong();
        Iterable merged = Iterables.transform((Iterable)cartesianProduct, input -> {
            checkRegularly.accept(null);
            long currentCheck = nbChecked.incrementAndGet();
            if (currentCheck % 1000000L == 0L) {
                LOGGER.info("Checking cartesian product: {}/{}", (Object)nbChecked, (Object)cartesianProductSize);
            }
            Map oneMerged = new LinkedHashMap();
            for (Map oneToMerge : input) {
                Optional mergedAgainTemplate = ApexCartesianProductHelper.mergeTemplate(oneMerged, oneToMerge);
                if (mergedAgainTemplate.isPresent()) {
                    oneMerged = (Map)mergedAgainTemplate.get();
                    continue;
                }
                LOGGER.trace("We rejected combination {} after adding {} to {}", new Object[]{input, oneToMerge, oneMerged});
                return null;
            }
            return oneMerged;
        });
        LinkedHashSet output = Sets.newLinkedHashSet((Iterable)Iterables.filter((Iterable)merged, (Predicate)Predicates.notNull()));
        LOGGER.trace("Reduced to {} combinations", (Object)output.size());
        return output;
    }

    public static <T> Optional<Map<T, Object>> mergeTemplate(Map<? extends T, ?> currentTemplate, Map<? extends T, ?> additionalTemplate) {
        LinkedHashMap<T, Object> mergedTemplate = new LinkedHashMap<T, Object>();
        mergedTemplate.putAll(currentTemplate);
        for (T key : additionalTemplate.keySet()) {
            if (mergedTemplate.containsKey(key)) {
                Object additionalCoordinate;
                Object baseCoordinate = currentTemplate.get(key);
                Object intersection = ApexCartesianProductHelper.intersectCoordinates(baseCoordinate, additionalCoordinate = additionalTemplate.get(key));
                if (intersection == GROUP_NOT_EXPRESSED) {
                    return Optional.absent();
                }
                mergedTemplate.put(key, intersection);
                continue;
            }
            mergedTemplate.put(key, additionalTemplate.get(key));
        }
        return Optional.of(mergedTemplate);
    }

    public static <T> boolean intersectCoordinates(Map<T, Object> columnNameToConstraint, T columnName, Object rangeCoordinate) {
        Object existingConstrain = columnNameToConstraint.get(columnName);
        Object intersection = ApexCartesianProductHelper.intersectCoordinates(existingConstrain, rangeCoordinate);
        if (intersection == null) {
            return true;
        }
        if (intersection == GROUP_NOT_EXPRESSED) {
            columnNameToConstraint.put(columnName, GROUP_NOT_EXPRESSED);
            return false;
        }
        columnNameToConstraint.put(columnName, intersection);
        return true;
    }

    public static <T> boolean intersectMapCoordinates(Map<T, Object> target, Map<? extends T, ?> source) {
        boolean result = true;
        for (Map.Entry<T, ?> sourceEntry : source.entrySet()) {
            boolean entryResult = ApexCartesianProductHelper.intersectCoordinates(target, sourceEntry.getKey(), sourceEntry.getValue());
            if (entryResult) continue;
            result = false;
        }
        return result;
    }

    public static Object intersectCoordinates(Object baseCoordinate, Object additionalCoordinate) {
        if (baseCoordinate == null) {
            return additionalCoordinate;
        }
        if (additionalCoordinate == null) {
            return baseCoordinate;
        }
        if (baseCoordinate instanceof Collection) {
            if (additionalCoordinate instanceof Collection) {
                LinkedHashSet intersection = new LinkedHashSet((Collection)baseCoordinate);
                intersection.retainAll((Collection)additionalCoordinate);
                if (intersection.isEmpty()) {
                    return GROUP_NOT_EXPRESSED;
                }
                if (intersection.size() == 1) {
                    return intersection.iterator().next();
                }
                return intersection;
            }
            if (((Collection)baseCoordinate).contains(additionalCoordinate)) {
                return additionalCoordinate;
            }
            return GROUP_NOT_EXPRESSED;
        }
        if (additionalCoordinate instanceof Collection) {
            if (((Collection)additionalCoordinate).contains(baseCoordinate)) {
                return baseCoordinate;
            }
            return GROUP_NOT_EXPRESSED;
        }
        if (baseCoordinate.equals(additionalCoordinate)) {
            return baseCoordinate;
        }
        return GROUP_NOT_EXPRESSED;
    }

    public static long cartesianProductSize(List<? extends Set<?>> listOfSets) {
        if (listOfSets.isEmpty()) {
            return 0L;
        }
        return listOfSets.stream().mapToLong(s -> s.size()).reduce(1L, (l, r) -> LongMath.checkedMultiply((long)l, (long)r));
    }
}

