/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexGzipHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexGzipHelper.class);
    private static final int GZIP_MAGIC_SHIFT = 8;

    protected ApexGzipHelper() {
    }

    public static boolean isGZIPStream(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117;
    }

    public static String toStringOptCompressed(byte[] bytes) throws IOException {
        if (ApexGzipHelper.isGZIPStream(bytes)) {
            return ApexGzipHelper.toStringCompressed(bytes);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String toStringCompressed(byte[] bytes) throws IOException {
        return ApexGzipHelper.inflate(bytes);
    }

    @Deprecated
    public static byte[] compress(String someString) throws IOException {
        return ApexGzipHelper.deflate(someString);
    }

    public static byte[] deflate(String someString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), StandardCharsets.UTF_8);){
            osw.write(someString);
        }
        return baos.toByteArray();
    }

    public static String inflate(byte[] inflated) throws IOException {
        return ApexGzipHelper.inflate(inflated, StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    public static String inflate(byte[] inflated, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void packToZip(File folder, File zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File next : Files.fileTreeTraverser().preOrderTraversal((Object)folder)) {
                if (next.isDirectory()) {
                    zos.putNextEntry(new ZipEntry(folder.toURI().relativize(next.toURI()).getPath() + "/"));
                    zos.closeEntry();
                    continue;
                }
                if (!next.isFile()) continue;
                LOGGER.debug("Adding {} in {}", (Object)next, (Object)zipFilePath);
                zos.putNextEntry(new ZipEntry(folder.toURI().relativize(next.toURI()).getPath()));
                Files.copy((File)next, (OutputStream)zos);
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            if (zipFilePath.isFile() && !zipFilePath.delete()) {
                LOGGER.debug("For some reason, we failed deleting {}", (Object)zipFilePath);
            }
            throw new IOException("Issue while writing in " + zipFilePath, e);
        }
    }

    public static void packToGzip(File inputPath, File zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             GZIPOutputStream zos = new GZIPOutputStream(fos);){
            Files.copy((File)inputPath, (OutputStream)zos);
        }
    }
}

