/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import blasd.apex.core.io.ApexHostDescriptor;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class ApexURLHelper {
    private static final String DEFAULT_PROTOCOL = "http";

    protected ApexURLHelper() {
    }

    public static boolean equalsUrl(URL left, URL right) {
        if (left == null) {
            return right == null;
        }
        if (right == null) {
            return left == null;
        }
        return Objects.equals(left.toExternalForm(), right.toExternalForm());
    }

    public static URL toHttpURL(String asString) {
        if (Strings.isNullOrEmpty((String)asString)) {
            throw new IllegalArgumentException("Should not be null");
        }
        try {
            OptionalInt notProtocolChar;
            int indexOfSemiColumn = asString.indexOf(58);
            boolean addHttpPrefix = indexOfSemiColumn < 0 ? true : (notProtocolChar = asString.chars().limit(indexOfSemiColumn).filter(c -> !CharMatcher.javaLetter().matches((char)c)).findFirst()).isPresent();
            if (addHttpPrefix) {
                return new URL("http://" + asString);
            }
            return new URL(asString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Issue while converting '" + asString + "'");
        }
    }

    public static Optional<ApexHostDescriptor> getHost(URL url) {
        Objects.requireNonNull(url);
        return ApexHostDescriptor.parseHost(url.getHost());
    }

    public static Optional<ApexHostDescriptor> getHost(String string) {
        return ApexURLHelper.getHost(ApexURLHelper.toHttpURL(string));
    }

    public static String resolve(String baseUrl, String relUrl) {
        try {
            URL base;
            try {
                base = new URL(baseUrl);
            }
            catch (MalformedURLException e) {
                URL abs = new URL(relUrl);
                return abs.toExternalForm();
            }
            return ApexURLHelper.resolve(base, relUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static URL resolve(URL base, String relUrl) throws MalformedURLException {
        if (relUrl.startsWith("?")) {
            relUrl = base.getPath() + relUrl;
        }
        if (relUrl.indexOf(46) == 0 && base.getFile().indexOf(47) != 0) {
            base = new URL(base.getProtocol(), base.getHost(), base.getPort(), "/" + base.getFile());
        }
        return new URL(base, relUrl);
    }
}

