/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.spring;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.RequiredModelMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jmx.export.SpringModelMBean;
import org.springframework.jmx.export.annotation.AnnotationMBeanExporter;

public class LoggingMethodCallAnnotationMBeanExporter
extends AnnotationMBeanExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingMethodCallAnnotationMBeanExporter.class);
    protected final AtomicLong nbErrors = new AtomicLong();

    public long getNbErrors() {
        return this.nbErrors.get();
    }

    protected ModelMBean createModelMBean() throws MBeanException {
        ModelMBean superModelMBean = super.createModelMBean();
        if (superModelMBean instanceof SpringModelMBean) {
            return new SpringModelMBean(){

                public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
                    try {
                        return super.invoke(opName, opArgs, sig);
                    }
                    catch (Error | RuntimeException | MBeanException | ReflectionException e) {
                        LoggingMethodCallAnnotationMBeanExporter.this.nbErrors.incrementAndGet();
                        LoggingMethodCallAnnotationMBeanExporter.this.onErrorInRemoteCall(e);
                        throw e;
                    }
                }
            };
        }
        return new RequiredModelMBean(){

            @Override
            public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
                try {
                    return super.invoke(opName, opArgs, sig);
                }
                catch (Error | RuntimeException | MBeanException | ReflectionException e) {
                    LoggingMethodCallAnnotationMBeanExporter.this.nbErrors.incrementAndGet();
                    LoggingMethodCallAnnotationMBeanExporter.this.onErrorInRemoteCall(e);
                    throw e;
                }
            }
        };
    }

    protected void onErrorInRemoteCall(Throwable e) {
        LOGGER.warn("Issue on a remote call", e);
    }
}

