/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexPropertiesHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexPropertiesHelper.class);

    protected ApexPropertiesHelper() {
    }

    public static void checkProperties(Properties properties) {
        ApexPropertiesHelper.checkProperties(properties, Collections.emptySet());
    }

    public static void checkProperties(Properties properties, Set<String> exceptionsKeys) {
        if (properties != null) {
            try {
                Enumeration<?> keys = properties.propertyNames();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object value = properties.get(key);
                    if (value == null) {
                        if (key instanceof String) {
                            String valueAsString = properties.getProperty((String)key);
                            if (valueAsString != null) continue;
                            LOGGER.warn("It is unsafe to associate the key {} to !String (in base or default Properties)", key);
                            continue;
                        }
                        LOGGER.warn("It is unsafe to associate the key {} to null", key);
                        continue;
                    }
                    if (value instanceof String) continue;
                    if (exceptionsKeys.contains(key)) {
                        LOGGER.debug("It is unsafe to associate the key {} to !String: {}({})", new Object[]{key, value.getClass(), value});
                        continue;
                    }
                    LOGGER.warn("It is unsafe to associate the key {} to !String: {}({})", new Object[]{key, value.getClass(), value});
                }
            }
            catch (Exception e) {
                LOGGER.warn("Something is wrong in properties: " + properties, (Throwable)e);
            }
        }
    }
}

