/*
 * Decompiled with CFR 0.152.
 */
package io.cormoran.buffer;

import com.google.common.annotations.Beta;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;

@Beta
public class ApexBufferHelper {
    public static IntBuffer makeIntBuffer(int size) throws IOException {
        File tmpFile = ApexBufferHelper.prepareIntArrayInFile(".IntArray1NWriter", size);
        FileChannel fc = new RandomAccessFile(tmpFile, "rw").getChannel();
        return fc.map(FileChannel.MapMode.READ_WRITE, 0L, fc.size()).asIntBuffer();
    }

    private static File prepareIntArrayInFile(String suffix, int size) throws IOException {
        File tmpFile = File.createTempFile("mat", suffix);
        tmpFile.deleteOnExit();
        try (RandomAccessFile out = new RandomAccessFile(tmpFile, "rw");){
            out.setLength(4L * (long)size);
        }
        return tmpFile;
    }
}

