/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import blasd.apex.core.collection.NavigableMapComparator;
import blasd.apex.core.collection.UnsafeNavigableMapListValueComparator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigableMapListValueComparator
implements Comparator<NavigableMap<? extends Comparable<?>, ? extends List<? extends Comparable<?>>>>,
Serializable {
    private static final long serialVersionUID = 7928339315645573854L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(NavigableMapComparator.class);

    @Override
    public int compare(NavigableMap<? extends Comparable<?>, ? extends List<? extends Comparable<?>>> o1, NavigableMap<? extends Comparable<?>, ? extends List<? extends Comparable<?>>> o2) {
        return NavigableMapListValueComparator.staticCompare(o1, o2, UnsafeNavigableMapListValueComparator.KEY_COMPARATOR, UnsafeNavigableMapListValueComparator.LIST_VALUES_COMPARATOR);
    }

    public static <T> int staticCompare(NavigableMap<? extends T, ? extends List<? extends T>> o1, NavigableMap<? extends T, ? extends List<? extends T>> o2, Comparator<? super T> keyComparator, Comparator<? super List<? extends T>> listValueComparator) {
        Iterator itKey1 = o1.entrySet().iterator();
        Iterator itKey2 = o2.entrySet().iterator();
        int valueCompare = 0;
        while (itKey1.hasNext() && itKey2.hasNext()) {
            Map.Entry next1 = itKey1.next();
            Map.Entry next2 = itKey2.next();
            int keyCompare = keyComparator.compare(next1.getKey(), next2.getKey());
            if (keyCompare != 0) {
                return keyCompare;
            }
            if (valueCompare != 0) continue;
            valueCompare = listValueComparator.compare(next1.getValue(), next2.getValue());
        }
        if (itKey1.hasNext()) {
            return 1;
        }
        if (itKey2.hasNext()) {
            return -1;
        }
        if (valueCompare == 0) {
            assert (o1.equals(o2));
            return 0;
        }
        return valueCompare;
    }
}

