/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import blasd.apex.core.jmx.SetStaticMBean;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexSerializationHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexSerializationHelper.class);
    public static final int MAX_CHARS_PER_COLUMN = 8192;
    public static final char MAP_KEY_VALUE_SEPARATOR = '=';
    public static final char MAP_ENTRY_SEPARATOR = ',';
    public static final char MAP_ENTRY_SEPARATOR_SEMICOLUMN = ';';
    public static final Splitter.MapSplitter MAP_TO_STRING_SPLITTER = Splitter.on((char)',').trimResults().withKeyValueSeparator('=');
    public static final Splitter.MapSplitter MAP_TO_STRING_SPLITTER_SEMICOLUMN = Splitter.on((char)';').trimResults().withKeyValueSeparator('=');
    public static final char PIPE = '|';
    public static final char COLLECTION_SEPARATOR = '|';
    public static final char FORCE_SEPARATOR = '#';
    private static final int HEX_FILTER = 255;
    @Deprecated
    protected static final Function<Object, CharSequence> OBJECT_TO_STRING = input -> {
        if (input == null) {
            return "";
        }
        return input.toString();
    };
    private static final Function<Object, CharSequence> OBJECT_TO_QUOTED_STRING = input -> {
        if (input == null) {
            return "";
        }
        String asString = input.toString();
        if (input instanceof CharSequence && ((CharSequence)input).length() >= 2 && ((CharSequence)input).charAt(0) == '\"' && ((CharSequence)input).charAt(((CharSequence)input).length() - 1) == '\"') {
            return asString;
        }
        String replaceDoubleQuotes = asString.replace("\"", "\"\"");
        return "\"" + replaceDoubleQuotes + "\"";
    };

    protected ApexSerializationHelper() {
    }

    public static Map<String, Object> convertToMap(CharSequence asString) {
        Map<String, String> mapStringString = ApexSerializationHelper.convertToMapStringString(asString);
        return ImmutableMap.copyOf((Map)Maps.transformValues(mapStringString, input -> ApexSerializationHelper.convertStringToObject(input)));
    }

    public static Map<String, String> convertToMapStringString(CharSequence asString) {
        Map notFullyTrimmed;
        if (asString == null || asString.length() == 0) {
            return Collections.emptyMap();
        }
        try {
            notFullyTrimmed = MAP_TO_STRING_SPLITTER.split(asString);
        }
        catch (IllegalArgumentException e) {
            LOGGER.trace("Can not parse " + asString + " with " + MAP_TO_STRING_SPLITTER);
            notFullyTrimmed = MAP_TO_STRING_SPLITTER_SEMICOLUMN.split(asString);
        }
        LinkedHashMap<String, String> fullyTrimmed = new LinkedHashMap<String, String>();
        for (Map.Entry notTrimmed : notFullyTrimmed.entrySet()) {
            String valueAsObject = ((String)notTrimmed.getValue()).trim();
            fullyTrimmed.put(((String)notTrimmed.getKey()).trim(), valueAsObject);
        }
        return fullyTrimmed;
    }

    public static Map<String, List<String>> convertToMapStringListString(String asString) {
        Map<String, String> mapStringString = ApexSerializationHelper.convertToMapStringString(asString);
        return Maps.transformValues(mapStringString, value -> ApexSerializationHelper.convertToListString(value));
    }

    public static Set<?> convertToSet(CharSequence asString) {
        return new LinkedHashSet<Object>(ApexSerializationHelper.convertToList(asString));
    }

    public static Set<? extends String> convertToSetString(CharSequence asString) {
        return new LinkedHashSet<String>(ApexSerializationHelper.convertToListString(asString));
    }

    public static List<Object> convertToList(CharSequence asString) {
        if (CharMatcher.is((char)'|').indexIn(asString) >= 0) {
            return ApexSerializationHelper.convertToList(asString, '|');
        }
        return ApexSerializationHelper.convertToList(asString, ',');
    }

    public static List<String> convertToListString(CharSequence asString) {
        if (CharMatcher.is((char)'|').indexIn(asString) >= 0) {
            return ApexSerializationHelper.convertToListString(asString, '|');
        }
        return ApexSerializationHelper.convertToListString(asString, ',');
    }

    public static List<Object> convertToList(CharSequence asString, char separator) {
        List<String> stringList = ApexSerializationHelper.convertToListString(asString, separator);
        return ImmutableList.copyOf((Collection)Lists.transform(stringList, input -> ApexSerializationHelper.convertStringToObject(input)));
    }

    public static List<String> convertToListString(CharSequence asString, char separator) {
        return Splitter.on((char)separator).trimResults().splitToList(asString);
    }

    public static String convertToString(Map<?, ?> asMap) {
        return Joiner.on((char)',').withKeyValueSeparator(Character.toString('=')).join(Maps.transformValues(asMap, input -> {
            if (input == null) {
                return "";
            }
            if (input instanceof Iterable) {
                return ApexSerializationHelper.convertToString2((Iterable)input);
            }
            if (input instanceof CharSequence) {
                return input.toString();
            }
            return ApexSerializationHelper.convertObjectToString(input);
        }));
    }

    public static String convertToString(Iterable<?> asList) {
        return Joiner.on((char)',').join(asList);
    }

    public static String convertToString2(Iterable<?> asList) {
        return Joiner.on((char)'|').join(asList);
    }

    public static String convertObjectToString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof CharSequence) {
            return object.toString();
        }
        return object.getClass().getName() + '#' + object;
    }

    public static Object convertStringToObject(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        String string = charSequence.toString();
        int indexofForceSep = string.indexOf(35);
        if (indexofForceSep >= 0) {
            String className = string.substring(0, indexofForceSep);
            try {
                Class<?> clazz = Class.forName(className);
                String subString = string.substring(indexofForceSep + 1);
                Object asObject = SetStaticMBean.safeTrySingleArgConstructor(clazz, subString);
                if (asObject != null) {
                    return asObject;
                }
                return string;
            }
            catch (ClassNotFoundException e) {
                LOGGER.trace("No class for {}", (Object)className);
                return string;
            }
        }
        return string;
    }

    @Beta
    public static Object toDoubleLowDigits(Object value) {
        return value;
    }

    @Beta
    public static synchronized void appendLineInCSVFile(Path file, Iterable<?> row) throws IOException {
        ApexSerializationHelper.appendLineInCSVFile(new FileWriter(file.toFile(), true), row);
    }

    @Beta
    public static void appendLineInCSVFile(Writer writer, Iterable<?> row) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(writer){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };){
            ApexSerializationHelper.rawAppendLineInCSVFile(bufferedWriter, row, true, 8192);
            bufferedWriter.newLine();
        }
    }

    @Beta
    public static void rawAppendLineInCSVFile(Writer writer, Iterable<?> row, boolean wrapInQuotes, int maxLength) throws IOException {
        Iterable asString = Iterables.transform(row, OBJECT_TO_QUOTED_STRING);
        asString = Iterables.transform((Iterable)asString, input -> {
            if (input == null || maxLength < 0) {
                return input;
            }
            if (!wrapInQuotes && input.length() > maxLength) {
                return input.subSequence(0, maxLength);
            }
            if (wrapInQuotes && input.length() - 2 > maxLength) {
                return "\"" + input.subSequence(1, maxLength + 1) + '\"';
            }
            return input;
        });
        Joiner.on((char)';').appendTo((Appendable)writer, asString);
    }

    @Beta
    public static void appendLineInCSVFile(FileOutputStream outputFileIS, Iterable<?> row) throws IOException {
        FileLock lock = outputFileIS.getChannel().lock();
        try {
            ApexSerializationHelper.appendLineInCSVFile(new OutputStreamWriter((OutputStream)outputFileIS, Charsets.UTF_8), row);
        }
        finally {
            lock.release();
        }
    }

    public static List<String> parseList(String asString) {
        return Splitter.on((char)',').trimResults().splitToList((CharSequence)asString.substring(asString.indexOf(91) + 1, asString.lastIndexOf(93)));
    }

    public static <T extends Serializable> T fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.getDecoder().decode(s);
        return ApexSerializationHelper.fromBytes(data);
    }

    public static <T extends Serializable> T fromBytes(byte[] data) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
    }

    public static <T extends Serializable> T fromBytes(ByteBuffer data) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data.array()));){
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
    }

    public static String toString(Serializable o) throws IOException {
        return Base64.getEncoder().encodeToString(ApexSerializationHelper.toBytes(o));
    }

    public static byte[] toBytes(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
        }
        return baos.toByteArray();
    }

    public static String toMD5(String input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return ApexSerializationHelper.toMD5(input, Charset.defaultCharset(), md);
    }

    public static String toMD5(String input, Charset charset, MessageDigest md) {
        try (DigestInputStream baos = new DigestInputStream(new ByteArrayInputStream(input.getBytes(charset)), md);){
            ByteStreams.exhaust((InputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] digest = md.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

