/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.metrics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMetricEvent {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AMetricEvent.class);
    public static final String INSTANCE_UUID = UUID.randomUUID().toString();
    private static final AtomicLong EVENT_INCREMENTER = new AtomicLong();
    public final long eventId = EVENT_INCREMENTER.getAndIncrement();
    protected static final Set<Class<?>> SOURCE_CLASSES = Sets.newConcurrentHashSet();
    public final Object source;
    public final List<? extends String> names;

    public static Set<Class<?>> getEncounteredSourceClasses() {
        return ImmutableSet.copyOf(SOURCE_CLASSES);
    }

    public AMetricEvent(Object source, List<? extends String> names) {
        this.source = Objects.requireNonNull(source);
        this.names = names == null ? Collections.emptyList() : names;
        SOURCE_CLASSES.add(source.getClass());
    }

    public AMetricEvent(Object source, String firstName, String ... otherNames) {
        this(source, Lists.asList((Object)firstName, (Object[])otherNames));
    }

    public static void post(Consumer<? super AMetricEvent> eventBus, AMetricEvent simpleEvent) {
        if (eventBus == null) {
            AMetricEvent.logNoEventBus(simpleEvent.source, simpleEvent.names);
        } else {
            eventBus.accept(simpleEvent);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("names", this.names).add("source", this.source).toString();
    }

    protected static void logNoEventBus(Object source, List<?> names) {
        LOGGER.info("No EventBus has been injected for {} on {}", names, source);
    }

    public static Set<Class<?>> getSourceClasses() {
        return Collections.unmodifiableSet(SOURCE_CLASSES);
    }
}

