/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApexMapHelper {
    protected ApexMapHelper() {
    }

    public static <K1, V, K2 extends K1> Map<K1, V> transcodeColumns(BiMap<?, ? extends K2> mapping, Map<K1, V> map) {
        return map.entrySet().stream().collect(HashMap::new, (m, e) -> {
            Object newKey = mapping.containsKey(e.getKey()) ? mapping.get(e.getKey()) : e.getKey();
            m.put(newKey, e.getValue());
        }, HashMap::putAll);
    }

    public static <K, V> Map<K, V> fromLists(List<? extends K> keys, List<? extends V> values) {
        Objects.requireNonNull(keys);
        Objects.requireNonNull(values);
        if (keys.size() != values.size()) {
            throw new RuntimeException(String.valueOf(keys.size()) + " keys but " + values.size() + " values");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int i = 0;
        while (i < keys.size()) {
            builder.put(keys.get(i), values.get(i));
            ++i;
        }
        return builder.build();
    }

    public static <K, V> Map<K, V> decoratePutAll(Map<? extends K, ? extends V> first, Map<? extends K, ? extends V> second) {
        HashMap<? extends K, ? extends V> clone = new HashMap<K, V>(second);
        clone.putAll(first);
        return Collections.unmodifiableMap(clone);
    }
}

