/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrayWithHashcodeEquals {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ArrayWithHashcodeEquals.class);
    public static final int COLLISION_COUNT_LOG = 1000000;
    protected final int hashcode;
    protected final Object[] array;
    protected static final AtomicLong COLLISION_COUNTER = new AtomicLong();

    public ArrayWithHashcodeEquals(Object[] array) {
        this.array = array;
        this.hashcode = Objects.hash(array);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayWithHashcodeEquals other = (ArrayWithHashcodeEquals)obj;
        if (this.hashcode != other.hashcode) {
            return false;
        }
        if (!Arrays.equals(this.array, other.array)) {
            ArrayWithHashcodeEquals.incrementCollision();
            return false;
        }
        return true;
    }

    private static void incrementCollision() {
        if (0L == COLLISION_COUNTER.incrementAndGet() % 1000000L) {
            LOGGER.warn("{} collisions on {}", (Object)COLLISION_COUNTER, ArrayWithHashcodeEquals.class);
        }
    }
}

