/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class ApexFileHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexFileHelper.class);

    protected ApexFileHelper() {
    }

    public static Path getResourceAsPath(Resource resource) {
        try {
            if (resource.exists()) {
                try {
                    return resource.getFile().toPath();
                }
                catch (FileNotFoundException e) {
                    Path tmpFile = Files.createTempFile("ApexFileHelper", resource.getFilename(), new FileAttribute[0]);
                    byte[] from = ByteStreams.toByteArray((InputStream)resource.getInputStream());
                    Files.write(tmpFile, from, new OpenOption[0]);
                    return tmpFile;
                }
            }
            return resource.getFile().toPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static URL getResourceURL(String path) {
        try {
            return new ClassPathResource(path).getURL();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path createTempPath(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        File asFile = path.toFile();
        if (asFile.exists()) {
            LOGGER.trace("Tmp file exists: delete it as we have been requested for a path");
            if (!asFile.delete()) {
                throw new IllegalStateException("We failed creating a non-existing tmp file");
            }
        }
        if (deleteOnExit) {
            asFile.deleteOnExit();
        }
        return path;
    }

    public static String cleanWhitespaces(String mdx) {
        if (Strings.isNullOrEmpty((String)mdx)) {
            return "";
        }
        return mdx.replaceAll("\\s+", " ");
    }

    @Beta
    public static void expandJarToDisk(Path jarPath, Path targetPath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (JarFile jar = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> enumEntries = jar.entries();
            File destDir = targetPath.toFile();
            destDir.mkdirs();
            while (enumEntries.hasMoreElements()) {
                JarEntry file = enumEntries.nextElement();
                Path diskPath = targetPath.resolve(file.getName());
                if (file.isDirectory()) {
                    if (diskPath.toFile().mkdir()) continue;
                    throw new IllegalStateException("Failed creating " + file);
                }
                diskPath.getParent().toFile().mkdirs();
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (InputStream is = jar.getInputStream(file);){
                    Files.copy(is, diskPath, new CopyOption[0]);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static Optional<Path> getHoldingJarPath(URI resource) throws IOException {
        if (resource.getScheme().toLowerCase().equals("jar")) {
            String path = resource.getRawSchemeSpecificPart();
            int indexOfInsideJar = path.indexOf("!/");
            DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
            if (indexOfInsideJar == -1) {
                return Optional.of(defaultResourceLoader.getResource(resource.toString()).getFile().toPath());
            }
            String jarOnly = path.substring(0, indexOfInsideJar);
            return Optional.of(defaultResourceLoader.getResource(jarOnly).getFile().toPath());
        }
        return Optional.empty();
    }
}

