/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexGzipHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexGzipHelper.class);
    private static final int GZIP_MAGIC_SHIFT = 8;

    protected ApexGzipHelper() {
    }

    public static boolean isGZIPStream(byte[] bytes) {
        return bytes != null && bytes.length >= 2 && bytes[0] == 31 && bytes[1] == -117;
    }

    public static String toStringOptCompressed(byte[] bytes) throws IOException {
        if (ApexGzipHelper.isGZIPStream(bytes)) {
            return ApexGzipHelper.toStringCompressed(bytes);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static String toStringCompressed(byte[] bytes) throws IOException {
        return ApexGzipHelper.inflate(bytes);
    }

    @Deprecated
    public static byte[] compress(String someString) throws IOException {
        return ApexGzipHelper.deflate(someString);
    }

    public static byte[] deflate(String someString) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), StandardCharsets.UTF_8);){
            osw.write(someString);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return baos.toByteArray();
    }

    public static String inflate(byte[] inflated) throws IOException {
        return ApexGzipHelper.inflate(inflated, StandardCharsets.UTF_8);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String inflate(byte[] inflated, Charset charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            GZIPInputStream gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(inflated));
            try {
                String string;
                block14: {
                    InputStreamReader osw = new InputStreamReader((InputStream)gzipInputStream, charset);
                    try {
                        string = CharStreams.toString((Readable)osw);
                        return string;
                    }
                    finally {
                        if (osw == null) break block14;
                        osw.close();
                    }
                }
                if (gzipInputStream != null) {
                    gzipInputStream.close();
                }
                return string;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (gzipInputStream == null) throw throwable;
                gzipInputStream.close();
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void packToZip(File folder, File zipFilePath) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(zipFilePath);
                try {
                    try (ZipOutputStream zos = new ZipOutputStream(fos);){
                        for (File next : Files.fileTreeTraverser().preOrderTraversal((Object)folder)) {
                            if (next.isDirectory()) {
                                zos.putNextEntry(new ZipEntry(String.valueOf(folder.toURI().relativize(next.toURI()).getPath()) + "/"));
                                zos.closeEntry();
                                continue;
                            }
                            if (!next.isFile()) continue;
                            LOGGER.debug("Adding {} in {}", (Object)next, (Object)zipFilePath);
                            zos.putNextEntry(new ZipEntry(folder.toURI().relativize(next.toURI()).getPath()));
                            Files.copy((File)next, (OutputStream)zos);
                            zos.closeEntry();
                        }
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            if (!zipFilePath.isFile() || zipFilePath.delete()) throw new IOException("Issue while writing in " + zipFilePath, e);
            LOGGER.debug("For some reason, we failed deleting {}", (Object)zipFilePath);
            throw new IOException("Issue while writing in " + zipFilePath, e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void packToGzip(File inputPath, File zipFilePath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileOutputStream fos = new FileOutputStream(zipFilePath);
            try {
                try (GZIPOutputStream zos = new GZIPOutputStream(fos);){
                    Files.copy((File)inputPath, (OutputStream)zos);
                }
                if (fos == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
            fos.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

