/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.jmx;

import blasd.apex.core.jmx.ApexBasicConnectionDTO;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxAttributesDumper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JmxAttributesDumper.class);
    public static final int HOST_INDEX = 0;
    public static final int PORT_INDEX = 1;
    public static final int USERNAME_INDEX = 2;
    public static final int PASSWORD_INDEX = 3;
    private static final String DEFAULT_USERNAME = "username";
    public static final int DEFAULT_JMX_PORT = 8050;
    public static final String QFS_REFRESH_OPERATION_NAME = "Refresh underlying MBeans";

    public static void main(String[] args) throws IOException {
        JmxAttributesDumper dumper = new JmxAttributesDumper();
        Throwable throwable = null;
        Object var3_4 = null;
        try (JMXConnector connector = dumper.openConnector(JmxAttributesDumper.prepareConnection(Arrays.asList(args)));){
            Map<ObjectName, Map<String, Object>> output;
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            try {
                output = new JmxAttributesDumper().dump(connection, null, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<ObjectName, Map<String, Object>> entry : output.entrySet()) {
                LOGGER.info("{} - {}", (Object)entry.getKey(), entry.getValue());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ApexBasicConnectionDTO prepareConnection(List<? extends String> args) {
        if (args == null) {
            return new ApexBasicConnectionDTO("HOST", 8050, DEFAULT_USERNAME, DEFAULT_USERNAME);
        }
        String host = args.size() > 0 ? args.get(0) : "HOST";
        int port = args.size() > 1 ? Integer.parseInt(args.get(1)) : 8050;
        String userName = args.size() > 2 ? args.get(2) : DEFAULT_USERNAME;
        String password = args.size() > 3 ? args.get(3) : userName;
        return new ApexBasicConnectionDTO(host, port, userName, password);
    }

    public JMXConnector openConnector(ApexBasicConnectionDTO connectionDetails) throws IOException {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String userName = connectionDetails.userName;
        if (!Strings.isNullOrEmpty((String)userName)) {
            env.put("jmx.remote.credentials", new String[]{userName, connectionDetails.password});
        }
        String url = JmxAttributesDumper.buildJmxUrl(connectionDetails.host, connectionDetails.port);
        JMXServiceURL address = new JMXServiceURL(url);
        try {
            return JMXConnectorFactory.connect(address, env);
        }
        catch (IOException | RuntimeException e) {
            throw new RuntimeException("Issue while connecting as " + userName + " to " + url, e);
        }
    }

    public static String buildJmxUrl(String host, int port) {
        return "service:jmx:rmi:///jndi/rmi://" + host + ":" + port + "/jmxrmi";
    }

    public Map<ObjectName, Map<String, Object>> dump(MBeanServerConnection mbs, ObjectName template, QueryExp query) throws IOException {
        Set<ObjectInstance> beans = this.getAllBeans(mbs, template, query);
        HashMap<ObjectName, Map<String, Object>> output = new HashMap<ObjectName, Map<String, Object>>();
        for (ObjectInstance instance : beans) {
            AttributeList attributeValues;
            MBeanInfo info;
            ObjectName name = instance.getObjectName();
            try {
                info = mbs.getMBeanInfo(name);
            }
            catch (IOException | InstanceNotFoundException | IntrospectionException | ReflectionException e) {
                LOGGER.warn("Issue when calling MBeanInfo for " + name, (Throwable)e);
                continue;
            }
            ArrayList<String> attributes = new ArrayList<String>();
            MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
            int n = mBeanAttributeInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                MBeanAttributeInfo attribute = mBeanAttributeInfoArray[n2];
                attributes.add(attribute.getName());
                ++n2;
            }
            try {
                attributeValues = mbs.getAttributes(name, attributes.toArray(new String[0]));
            }
            catch (IOException | RuntimeException | InstanceNotFoundException | ReflectionException e) {
                attributeValues = Collections.emptyList();
            }
            HashMap attributeToValue = new HashMap();
            int i = 0;
            while (i < attributeValues.size()) {
                attributeToValue.put((String)attributes.get(i), attributeValues.get(i));
                ++i;
            }
            output.put(name, attributeToValue);
        }
        return output;
    }

    protected Set<ObjectInstance> getAllBeans(MBeanServerConnection mbs, ObjectName template, QueryExp query) throws IOException {
        HashSet<ObjectName> objectNameExecuted = new HashSet<ObjectName>();
        boolean hasPotentiallyMoreUndelryingBeans = true;
        Set<ObjectInstance> beans = Collections.emptySet();
        while (hasPotentiallyMoreUndelryingBeans) {
            beans = mbs.queryMBeans(template, query);
            hasPotentiallyMoreUndelryingBeans = false;
            for (ObjectInstance instance : beans) {
                try {
                    MBeanInfo info = mbs.getMBeanInfo(instance.getObjectName());
                    if (!objectNameExecuted.add(instance.getObjectName())) continue;
                    MBeanOperationInfo[] mBeanOperationInfoArray = info.getOperations();
                    int n = mBeanOperationInfoArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MBeanOperationInfo operation = mBeanOperationInfoArray[n2];
                        if (QFS_REFRESH_OPERATION_NAME.equals(operation.getName())) {
                            try {
                                mbs.invoke(instance.getObjectName(), QFS_REFRESH_OPERATION_NAME, null, null);
                                hasPotentiallyMoreUndelryingBeans = true;
                            }
                            catch (MBeanException e) {
                                LOGGER.warn("Issue on " + instance, (Throwable)e);
                            }
                        }
                        ++n2;
                    }
                }
                catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
                    LOGGER.warn("Issue on " + instance, (Throwable)e);
                }
            }
        }
        return beans;
    }
}

