/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.memory;

import blasd.apex.core.agent.InstrumentationAgent;
import blasd.apex.core.memory.IApexMemoryConstants;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ApexMemoryHelper
implements IApexMemoryConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexMemoryHelper.class);
    public static final int JVM_MEMORY_CHUNK = 8;
    public static final int JVM_BYTES_PER_CHAR = 2;
    public static final int JVM_STRING_HEADER = 45;
    private static final long MASK = 0xFFFFFFFFL;
    private static final int SHIFT = 32;

    protected ApexMemoryHelper() {
    }

    public static long getStringMemory(CharSequence existingRef) {
        int nbChars = existingRef.length();
        long nbBits = (long)nbChars * 2L + 45L;
        return 8L * (nbBits / 8L);
    }

    @Deprecated
    public static long recursiveSize(Object object) {
        return ApexMemoryHelper.deepSize(object);
    }

    public static long deepSize(Object object) {
        return ApexMemoryHelper.deepSizeWithBloomFilter(object, 0x1FFFFFL);
    }

    public static long recursiveSize(Object object, IntPredicate identityPredicate) {
        return ApexMemoryHelper.deepSize(object, identityPredicate);
    }

    public static long deepSize(Object object, IntPredicate identityPredicate) {
        if (object == null) {
            return 0L;
        }
        Optional instrumentation = InstrumentationAgent.getInstrumentation();
        if (instrumentation.isPresent()) {
            LongAdder totalSize = new LongAdder();
            ApexMemoryHelper.deepSize((Instrumentation)instrumentation.get(), identityPredicate, totalSize, object);
            return totalSize.sum();
        }
        LOGGER.debug("Instrumentation is not available for {}", object);
        return Long.MAX_VALUE;
    }

    @Deprecated
    public static long recursiveSizeWithBloomFilter(Object object, long expectedObjectCardinality) {
        return ApexMemoryHelper.deepSizeWithBloomFilter(object, expectedObjectCardinality);
    }

    public static long deepSizeWithBloomFilter(Object object, long expectedObjectCardinality) {
        BloomFilter identities = BloomFilter.create((Funnel)Funnels.integerFunnel(), (long)expectedObjectCardinality);
        return ApexMemoryHelper.recursiveSize(object, arg_0 -> ((BloomFilter)identities).put(arg_0));
    }

    @Deprecated
    public static void recursiveSize(Instrumentation instrumentation, IntPredicate identities, LongAdder totalSize, Object object) {
        ApexMemoryHelper.deepSize(instrumentation, identities, totalSize, object);
    }

    public static void deepSize(Instrumentation instrumentation, IntPredicate identities, LongAdder totalSize, Object object) {
        Objects.requireNonNull(instrumentation);
        if (object == null) {
            return;
        }
        if (identities.test(System.identityHashCode(object))) {
            long currentSize = instrumentation.getObjectSize(object);
            totalSize.add(currentSize);
            if (object instanceof Object[]) {
                Arrays.stream((Object[])object).forEach(element -> ApexMemoryHelper.recursiveSize(instrumentation, identities, totalSize, element));
            } else {
                ReflectionUtils.doWithFields(object.getClass(), field -> ApexMemoryHelper.recursiveSize(instrumentation, identities, totalSize, field.get(object)), field -> {
                    if (Modifier.isStatic(field.getModifiers())) {
                        return false;
                    }
                    if (field.getType().isPrimitive()) {
                        return false;
                    }
                    ReflectionUtils.makeAccessible((Field)field);
                    return true;
                });
            }
        }
    }

    public static long getDoubleMemory() {
        long charArrayWeight = 16L;
        return charArrayWeight;
    }

    public static long getObjectArrayMemory(Object[] asArray) {
        if (asArray == null) {
            return 0L;
        }
        long footprint = 8L;
        return footprint += 8L * (long)asArray.length;
    }

    public static long getObjectArrayMemory(Object asArray) {
        if (asArray == null) {
            return 0L;
        }
        Class<?> arrayClass = asArray.getClass();
        if (!arrayClass.isArray()) {
            return 0L;
        }
        Class<?> elementClass = arrayClass.getComponentType();
        long footprint = 8L;
        long componentWeight = elementClass == Integer.TYPE ? 4L : (elementClass == Float.TYPE ? 4L : 8L);
        return footprint += componentWeight * (long)Array.getLength(asArray);
    }

    public static final long positivePack(int i1, int i2) {
        long packed1 = (long)i1 << 32;
        long packed2 = (long)Integer.rotateLeft(i2, 1) & 0xFFFFFFFFL;
        return Long.rotateRight(packed1 | packed2, 1);
    }

    public static final int positiveUnpack1(long packed) {
        return (int)(Long.rotateLeft(packed, 1) >>> 32);
    }

    public static final int positiveUnpack2(long packed) {
        return Integer.rotateRight((int)(Long.rotateLeft(packed, 1) & 0xFFFFFFFFL), 1);
    }

    public static long memoryAsLong(String targetMax) {
        String digits;
        long multiplier;
        if (targetMax.isEmpty()) {
            throw new UnsupportedOperationException("Can not be empty");
        }
        int lastDigit = targetMax.length();
        char lastChar = targetMax.charAt(lastDigit - 1);
        if (CharMatcher.javaDigit().matches(lastChar)) {
            multiplier = 1L;
            digits = targetMax;
        } else {
            --lastDigit;
            if (lastChar == 'b' || lastChar == 'B') {
                if (targetMax.length() <= 1) {
                    return 0L;
                }
                lastChar = targetMax.charAt(targetMax.length() - 2);
                --lastDigit;
            }
            if (lastChar == 'k' || lastChar == 'K') {
                multiplier = 1024L;
            } else if (lastChar == 'm' || lastChar == 'M') {
                multiplier = 0x100000L;
            } else if (lastChar == 'g' || lastChar == 'G') {
                multiplier = 0x40000000L;
            } else {
                throw new IllegalArgumentException("Can not parse " + targetMax + ". It should end by a digit or one of 'k', 'm','g'");
            }
            digits = targetMax.substring(0, lastDigit).trim();
        }
        if (digits.length() >= 5 && !CharMatcher.digit().matches(digits.charAt(digits.length() - 4))) {
            digits = String.valueOf(digits.substring(0, digits.length() - 4)) + digits.substring(digits.length() - 3);
        }
        double parsedAsDouble = Double.parseDouble(digits);
        return (long)(parsedAsDouble * (double)multiplier);
    }

    public static String memoryAsString(long bytes) {
        long kb;
        long mb;
        long gb;
        String string = "";
        int unitsDone = 0;
        if (unitsDone < 2 && (gb = bytes / 0x40000000L) > 0L) {
            ++unitsDone;
            string = String.valueOf(string) + gb + "G";
            bytes -= gb * 0x40000000L;
        }
        if (unitsDone < 2 && (mb = bytes / 0x100000L) > 0L) {
            ++unitsDone;
            string = String.valueOf(string) + mb + "M";
            bytes -= mb * 0x100000L;
        }
        if (unitsDone < 2 && (kb = bytes / 1024L) > 0L) {
            ++unitsDone;
            string = String.valueOf(string) + kb + "K";
            bytes -= kb * 1024L;
        }
        if (unitsDone < 2) {
            if (bytes > 0L) {
                string = String.valueOf(string) + bytes + "B";
            } else {
                LOGGER.trace("No more bytes");
            }
        }
        return string;
    }
}

