/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.memory.histogram;

import blasd.apex.core.agent.VirtualMachineWithoutToolsJar;
import blasd.apex.core.memory.histogram.ClassInfo;
import blasd.apex.core.memory.histogram.ClassInfoComparator;
import blasd.apex.core.memory.histogram.IHeapHistogram;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapHistogram
implements IHeapHistogram,
Serializable {
    private static final long serialVersionUID = 2163916067335213382L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(HeapHistogram.class);
    private final List<ClassInfo> classes;
    private final List<ClassInfo> permGenClasses;
    private final Date time = new Date();
    private long totalHeapBytes;
    private long totalHeapInstances;
    private long totalPermGenBytes;
    private long totalPermgenInstances;
    private boolean sourceDisplayed;
    private static final int DECIMAL_RADIX = 10;

    HeapHistogram(InputStream in, boolean jrockit) {
        Scanner sc = new Scanner(in, JMAP_CHARSET.toString());
        List<ClassInfo> classInfos = this.scan(sc, jrockit);
        this.classes = new ArrayList<ClassInfo>();
        this.permGenClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : classInfos) {
            if (classInfo.isPermGen()) {
                this.permGenClasses.add(classInfo);
                this.totalPermGenBytes += classInfo.getBytes();
                this.totalPermgenInstances += classInfo.getInstancesCount();
            } else {
                this.classes.add(classInfo);
                this.totalHeapBytes += classInfo.getBytes();
                this.totalHeapInstances += classInfo.getInstancesCount();
            }
            if (this.sourceDisplayed || classInfo.getSource() == null) continue;
            this.sourceDisplayed = true;
        }
        if (!jrockit) {
            sc.next("Total");
            long totalInstances = sc.nextLong();
            long totalBytes = sc.nextLong();
            assert (totalInstances == this.totalPermgenInstances + this.totalHeapInstances);
            assert (totalBytes == this.totalPermGenBytes + this.totalHeapBytes);
        }
        this.sort();
    }

    private void addClassInfo(ClassInfo newClInfo, Map<String, ClassInfo> map) {
        ClassInfo oldClInfo = map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.add(newClInfo);
        }
    }

    protected Date getTime() {
        return this.time;
    }

    protected List<ClassInfo> getHeapHistogram() {
        return Collections.unmodifiableList(this.classes);
    }

    protected long getTotalHeapInstances() {
        return this.totalHeapInstances;
    }

    @Override
    public long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    List<ClassInfo> getPermGenHistogram() {
        return Collections.unmodifiableList(this.permGenClasses);
    }

    long getTotalPermGenInstances() {
        return this.totalPermgenInstances;
    }

    long getTotalPermGenBytes() {
        return this.totalPermGenBytes;
    }

    boolean isSourceDisplayed() {
        return this.sourceDisplayed;
    }

    private void sort() {
        Comparator<ClassInfo> classInfoReversedComparator = Collections.reverseOrder(new ClassInfoComparator());
        Collections.sort(this.permGenClasses, classInfoReversedComparator);
        Collections.sort(this.classes, classInfoReversedComparator);
    }

    protected void skipHeader(Scanner sc, boolean jrockit) {
        sc.nextLine();
        sc.nextLine();
        if (!jrockit) {
            sc.skip("-+");
            sc.nextLine();
        }
    }

    protected List<ClassInfo> scan(Scanner sc, boolean jrockit) {
        HashMap<String, ClassInfo> classInfoMap = new HashMap<String, ClassInfo>();
        sc.useRadix(10);
        this.skipHeader(sc, jrockit);
        String nextLine = jrockit ? "[0-9.]+%" : "[0-9]+:";
        while (sc.hasNext(nextLine)) {
            ClassInfo newClInfo = new ClassInfo(sc, jrockit);
            this.addClassInfo(newClInfo, classInfoMap);
        }
        return new ArrayList<ClassInfo>(classInfoMap.values());
    }

    public static HeapHistogram createHeapHistogram() throws IOException {
        return (HeapHistogram)VirtualMachineWithoutToolsJar.heapHisto().transform(is -> {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream input = is;){
                    return new HeapHistogram(input, VirtualMachineWithoutToolsJar.isJRockit());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).orNull();
    }

    public static String createHeapHistogramAsString() throws IOException {
        return (String)VirtualMachineWithoutToolsJar.heapHisto().transform(is -> {
            try {
                return new String(ByteStreams.toByteArray((InputStream)is), JMAP_CHARSET);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).or((Object)"Heap Histogram is not available");
    }

    public static String saveHeapDump(File file) throws IOException {
        String output = (String)VirtualMachineWithoutToolsJar.heapDump((File)file, (boolean)true).transform(is -> {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream input = is;){
                    return CharStreams.toString((Readable)new InputStreamReader(input));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).or((Object)"Heap Histogram is not available");
        if (output.startsWith("Heap dump file created")) {
            LOGGER.info("Heap-Dump seems to have been successfully generated in {}", (Object)file);
        }
        return output;
    }
}

