/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.metrics;

import blasd.apex.core.metrics.AMetricEvent;
import blasd.apex.core.metrics.StartMetricEvent;
import java.util.Objects;
import java.util.function.Consumer;

public class EndMetricEvent
extends AMetricEvent {
    public static final String KEY_RESULT_SIZE = "resultSize";
    public final StartMetricEvent startEvent;

    protected EndMetricEvent(StartMetricEvent startEvent) {
        super(startEvent.source, startEvent.names);
        this.startEvent = Objects.requireNonNull(startEvent);
    }

    public long durationInMs() {
        return System.currentTimeMillis() - this.startEvent.startTime;
    }

    public static EndMetricEvent postEndEvent(Consumer<? super AMetricEvent> eventBus, StartMetricEvent startEvent) {
        if (startEvent == null) {
            LOGGER.info("No StartMetricEvent has been provided");
            return null;
        }
        EndMetricEvent endMetricEvent = EndMetricEvent.buildEndEvent(startEvent);
        if (startEvent.endMetricEvent.get() == endMetricEvent) {
            EndMetricEvent.post(eventBus, endMetricEvent);
            return endMetricEvent;
        }
        return startEvent.endMetricEvent.get();
    }

    public static EndMetricEvent buildEndEvent(StartMetricEvent start) {
        EndMetricEvent endEvent = new EndMetricEvent(start);
        start.registerEndEvent(endEvent);
        return endEvent;
    }
}

