/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.metrics;

import blasd.apex.core.metrics.AMetricEvent;
import blasd.apex.core.metrics.AutoCloseableStartMetricEvent;
import blasd.apex.core.metrics.EndMetricEvent;
import blasd.apex.core.thread.CurrentThreadStack;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.LongSupplier;

public class StartMetricEvent
extends AMetricEvent {
    public static final String KEY_USERNAME = "UserName";
    public static final String KEY_PIVOT_ID = "ActivePivot";
    public static final String KEY_ROOT_SOURCE = "RootSource";
    public static final String KEY_CLIENT = "Client";
    public static final String VALUE_CLIENT_XMLA = "XMLA";
    public static final String VALUE_CLIENT_STREAMING = "Streaming";
    private static boolean doRememberStack = false;
    public final Optional<StackTraceElement[]> stack;
    protected final String startThread = Thread.currentThread().getName();
    public final long startTime = System.currentTimeMillis();
    protected final Map<String, ?> startDetails;
    protected final Map<String, Object> endDetails;
    final AtomicReference<EndMetricEvent> endMetricEvent = new AtomicReference();
    protected final LongSupplier progress;
    private static final LongSupplier NO_PROGRESS = () -> -1L;

    public static void setDoRememberStack(boolean doRememberStack) {
        StartMetricEvent.doRememberStack = doRememberStack;
    }

    private static Optional<StackTraceElement[]> fastCurrentStackIfRemembering() {
        if (doRememberStack) {
            return Optional.ofNullable(StartMetricEvent.fastCurrentStack());
        }
        return Optional.empty();
    }

    public StartMetricEvent(Object source, String firstName, String ... otherNames) {
        this(source, Collections.emptyMap(), NO_PROGRESS, Lists.asList((Object)firstName, (Object[])otherNames));
    }

    public StartMetricEvent(Object source, Map<String, ?> details, LongSupplier progress, String firstName, String ... otherNames) {
        this(source, details, progress, Lists.asList((Object)firstName, (Object[])otherNames), StartMetricEvent.fastCurrentStackIfRemembering());
    }

    public StartMetricEvent(Object source, Map<String, ?> details, LongSupplier progress, List<? extends String> names) {
        this(source, details, progress, names, StartMetricEvent.fastCurrentStackIfRemembering());
    }

    protected StartMetricEvent(Object source, Map<String, ?> details, LongSupplier progress, List<? extends String> names, Optional<StackTraceElement[]> stack) {
        super(source, names);
        this.startDetails = ImmutableMap.copyOf(details);
        this.endDetails = new ConcurrentHashMap<String, Object>();
        this.progress = progress;
        this.stack = stack;
    }

    public static StackTraceElement[] fastCurrentStack() {
        return CurrentThreadStack.snapshotStackTrace();
    }

    public static AutoCloseableStartMetricEvent post(Consumer<? super AMetricEvent> eventBus, Object source, String firstName, String ... otherNames) {
        return StartMetricEvent.post(eventBus, source, Collections.emptyMap(), NO_PROGRESS, firstName, otherNames);
    }

    public static AutoCloseableStartMetricEvent post(Consumer<? super AMetricEvent> eventBus, Object source, Map<String, ?> details, LongSupplier progress, String firstName, String ... otherNames) {
        StartMetricEvent startEvent = new StartMetricEvent(source, details, progress, firstName, otherNames);
        StartMetricEvent.post(eventBus, startEvent);
        return new AutoCloseableStartMetricEvent(startEvent, eventBus);
    }

    @Override
    public String toString() {
        return String.valueOf(this.toStringNoStack()) + this.stack.map(s -> String.valueOf('\n') + Joiner.on((char)'\n').join((Object[])s)).orElse("");
    }

    public String toStringNoStack() {
        String suffix = "";
        if (!this.startDetails.isEmpty()) {
            suffix = String.valueOf(suffix) + " startDetails=" + this.startDetails;
        }
        if (!this.endDetails.isEmpty()) {
            suffix = String.valueOf(suffix) + " endDetails=" + this.endDetails;
        }
        long currentProgress = this.progress.getAsLong();
        String prefix = "Started in '" + this.startThread + "': ";
        if (currentProgress < 0L) {
            return String.valueOf(prefix) + super.toString() + suffix;
        }
        return String.valueOf(prefix) + super.toString() + " progress=" + currentProgress + suffix;
    }

    public Object getDetail(String key) {
        Object result = this.endDetails.get(key);
        if (result == null) {
            result = this.startDetails.get(key);
        }
        return result;
    }

    public void setEndDetails(Map<String, ?> moreEndDetails) {
        this.endDetails.putAll(moreEndDetails);
    }

    public boolean registerEndEvent(EndMetricEvent endMetricEvent) {
        return this.endMetricEvent.compareAndSet(null, endMetricEvent);
    }

    public Optional<EndMetricEvent> getEndEvent() {
        return Optional.ofNullable(this.endMetricEvent.get());
    }

    public OptionalLong getProgress() {
        long current = this.progress.getAsLong();
        if (current == -1L) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(current);
    }
}

