/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.primitive;

import blasd.apex.core.primitive.ConcatCharSequence;
import com.google.common.base.CharMatcher;
import javolution.text.TypeFormat;

public class ApexParserHelper {
    private static double[] pow10;
    private static final CharMatcher E_UPPER_MATCHER;
    private static final CharMatcher PLUS_MATCHER;
    private static final CharMatcher MINUS_MATCHER;
    private static final CharMatcher E_LOWER_MATCHER;
    private static final CharMatcher DOT_MATCHER;

    static {
        E_UPPER_MATCHER = CharMatcher.is((char)'E').precomputed();
        PLUS_MATCHER = CharMatcher.is((char)'+').precomputed();
        MINUS_MATCHER = CharMatcher.is((char)'-').precomputed();
        E_LOWER_MATCHER = CharMatcher.is((char)'e').precomputed();
        DOT_MATCHER = CharMatcher.is((char)'.').precomputed();
    }

    public static void initialize() {
        pow10 = new double[634];
        int i = 0;
        while (i < pow10.length) {
            ApexParserHelper.pow10[i] = Double.parseDouble("1.0e" + (i - 325));
            ++i;
        }
    }

    public static double parseDouble(CharSequence s) {
        if (pow10 == null) {
            ApexParserHelper.initialize();
        }
        if (s.charAt(0) == 'N' && s.charAt(1) == 'a' && s.charAt(2) == 'N') {
            return Double.NaN;
        }
        if (s.charAt(0) == '+') {
            s = s.subSequence(1, s.length());
        }
        int exp = 0;
        int e = E_UPPER_MATCHER.indexIn(s);
        if (e < 0) {
            e = E_LOWER_MATCHER.indexIn(s);
        }
        if (e >= 0) {
            CharSequence ss = s.subSequence(e + 1, s.length());
            if (ss.charAt(0) == '+') {
                ss = ss.subSequence(1, ss.length());
            }
            exp = TypeFormat.parseShort((CharSequence)ss);
            s = s.subSequence(0, e);
        } else if (PLUS_MATCHER.lastIndexIn(s) > 0 || MINUS_MATCHER.lastIndexIn(s) > 0) {
            throw new RuntimeException("Not a number");
        }
        int p = DOT_MATCHER.indexIn(s);
        int n = s.length();
        if (p >= 0) {
            s = new ConcatCharSequence(s.subSequence(0, p), s.subSequence(p + 1, s.length()));
            exp += p - 1;
            --n;
        } else {
            exp += n - 1;
        }
        double pow10Exp = pow10[exp + 325];
        if (n > 17) {
            return (double)TypeFormat.parseLong((CharSequence)s.subSequence(0, 17)) * pow10[309] * pow10Exp;
        }
        if (n < 9) {
            return (double)TypeFormat.parseInt((CharSequence)s) * pow10[326 - n] * pow10Exp;
        }
        long asLong = s instanceof String ? Long.parseLong((String)s) : TypeFormat.parseLong((CharSequence)s);
        return (double)asLong * pow10[326 - n] * pow10Exp;
    }

    public static float parseFloat(CharSequence floatAsCharSequence) {
        return (float)ApexParserHelper.parseDouble(floatAsCharSequence);
    }
}

