/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.primitive;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsafeSubSequence
implements CharSequence {
    protected static final Logger LOGGER = LoggerFactory.getLogger(UnsafeSubSequence.class);
    protected final CharSequence undelrying;
    protected int start;
    protected int end;

    public UnsafeSubSequence(CharSequence undelrying) {
        this.undelrying = undelrying;
        this.start = -1;
        this.end = -1;
    }

    public UnsafeSubSequence(CharSequence undelrying, int from, int to) {
        this.undelrying = undelrying;
        this.start = from;
        this.end = to;
    }

    public void resetWindow(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public boolean isValid() {
        return this.start >= 0 && this.end >= this.start;
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public char charAt(int index) {
        if (index >= this.end) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " is above " + index + " on " + this);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + " is below " + 0 + " on " + this);
        }
        if (this.start + index >= this.undelrying.length()) {
            throw new IndexOutOfBoundsException("start=" + this.start + " + index=" + index + " is above underlying length=" + this.undelrying.length() + " on " + this);
        }
        return this.undelrying.charAt(this.start + index);
    }

    @Override
    public CharSequence subSequence(int subStart, int subEnd) {
        if (this.undelrying instanceof UnsafeSubSequence) {
            UnsafeSubSequence unsafeUnderlying = (UnsafeSubSequence)this.undelrying;
            return new UnsafeSubSequence(unsafeUnderlying.undelrying, unsafeUnderlying.start + subStart, unsafeUnderlying.start + subEnd);
        }
        return new UnsafeSubSequence(this.undelrying, this.start + subStart, this.start + subEnd);
    }

    public int hashCode() {
        throw new RuntimeException("UNsafe");
    }

    public boolean equals(Object obj) {
        throw new RuntimeException("UNsafe");
    }

    @Override
    public String toString() {
        if (this.isValid()) {
            return this.undelrying.subSequence(this.start, this.end).toString();
        }
        LOGGER.warn("We unexpectedly used .toString on a not initialized {}", this.getClass());
        return this.getClass() + " Not Initialized";
    }
}

