/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.thread;

import blasd.apex.core.thread.IApexThreadDumper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.LocalDateTime;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class ApexThreadDump
implements IApexThreadDumper {
    private final ThreadMXBean threadMXBean;

    public ApexThreadDump() {
        this(ManagementFactory.getThreadMXBean());
    }

    public ApexThreadDump(ThreadMXBean threadMXBean) {
        this.threadMXBean = threadMXBean;
    }

    public void dump(Charset charset, OutputStream out, boolean withMonitorsAndSynchronizers) throws IOException {
        this.dumpSkeleton(charset, out, withMonitorsAndSynchronizers, (writer, stream) -> stream.forEach(t -> {
            try {
                this.appendToWritable((Appendable)writer, (ThreadInfo)t);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    protected ThreadInfo[] dumpAllThreads(boolean withMonitors, boolean withSynchronizers) {
        return this.threadMXBean.dumpAllThreads(withMonitors, withSynchronizers);
    }

    protected void dumpSkeleton(Charset charset, OutputStream out, boolean withMonitorsAndSynchronizers, BiConsumer<PrintWriter, Stream<ThreadInfo>> threadInfoConsumer) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, charset));
        this.printHeader(writer);
        ThreadInfo[] threads = this.dumpAllThreads(withMonitorsAndSynchronizers, withMonitorsAndSynchronizers);
        Stream<ThreadInfo> stream = Arrays.stream(threads).sorted(Comparator.comparing(ti -> ti.getThreadState().ordinal()));
        threadInfoConsumer.accept(writer, stream);
        this.println(writer);
        writer.flush();
    }

    protected void printHeader(PrintWriter writer) throws IOException {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.println(writer, new LocalDateTime() + " " + runtimeMXBean.getName());
        this.println(writer, "Full thread dump " + runtimeMXBean.getVmName() + " (" + runtimeMXBean.getVmVersion() + " by " + runtimeMXBean.getVmVendor() + ")");
    }

    protected void appendToWritable(Appendable writer, ThreadInfo t) throws IOException {
        this.appendThreadHeader(writer, t);
        this.appendThreadStack(writer, t);
        this.appendThreadFooter(writer, t);
    }

    protected boolean hasFooter(ThreadInfo t) {
        return t.getLockedSynchronizers().length >= 1;
    }

    protected void appendThreadFooter(Appendable writer, ThreadInfo t) throws UnsupportedEncodingException, IOException {
        LockInfo[] locks = t.getLockedSynchronizers();
        if (locks.length > 0) {
            this.printf(writer, "    Locked synchronizers: count = %d%n", locks.length);
            LockInfo[] lockInfoArray = locks;
            int n = locks.length;
            int n2 = 0;
            while (n2 < n) {
                LockInfo l = lockInfoArray[n2];
                this.printf(writer, "      - %s%n", l);
                ++n2;
            }
            this.println(writer);
        }
    }

    protected void appendThreadStack(Appendable writer, ThreadInfo t) throws UnsupportedEncodingException, IOException {
        StackTraceElement[] elements = t.getStackTrace();
        MonitorInfo[] monitors = t.getLockedMonitors();
        int i = 0;
        while (i < elements.length) {
            StackTraceElement element = elements[i];
            this.printf(writer, "    at %s%n", element);
            int j = 1;
            while (j < monitors.length) {
                MonitorInfo monitor = monitors[j];
                if (monitor.getLockedStackDepth() == i) {
                    this.printf(writer, "      - locked %s%n", monitor);
                }
                ++j;
            }
            ++i;
        }
        this.println(writer);
    }

    protected void appendThreadHeader(Appendable writer, ThreadInfo t) throws UnsupportedEncodingException, IOException {
        this.printf(writer, "%s id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()});
        LockInfo lock = t.getLockInfo();
        if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
            this.printf(writer, "%n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            this.printf(writer, "%n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
        } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
            this.printf(writer, "%n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
        }
        if (t.isSuspended()) {
            writer.append(" (suspended)");
        }
        if (t.isInNative()) {
            writer.append(" (running in native)");
        }
        this.println(writer);
        if (t.getLockOwnerName() != null) {
            this.printf(writer, "     owned by %s id=%d%n", t.getLockOwnerName(), t.getLockOwnerId());
        }
    }

    protected void printf(Appendable writer, String format, Object ... parameters) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Charset charset = Charset.defaultCharset();
        PrintWriter printer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, charset));
        printer.printf(format, parameters);
        printer.flush();
        writer.append(baos.toString(charset.name()));
    }

    protected void println(Appendable writer) throws IOException {
        writer.append(System.getProperty("line.separator"));
    }

    protected void println(Appendable writer, String string) throws IOException {
        writer.append(string);
        this.println(writer);
    }

    @Override
    @ManagedOperation
    public String getThreadDumpAsString(boolean withMonitorsAndSynchronizers) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.dump(Charset.defaultCharset(), os, withMonitorsAndSynchronizers);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return os.toString();
    }

    @Override
    @ManagedOperation
    public String getSmartThreadDumpAsString(boolean withMonitorsAndSynchronizers) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Charset charset = Charset.defaultCharset();
        try {
            this.dumpSmart(charset, os, withMonitorsAndSynchronizers);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return os.toString();
    }

    public void dumpSmart(Charset charset, OutputStream out, boolean withMonitorsAndSynchronizers) throws IOException {
        this.dumpSkeleton(charset, out, withMonitorsAndSynchronizers, (writer, stream) -> stream.collect(Collectors.groupingBy(t -> {
            StringWriter localWriter = new StringWriter();
            try {
                this.appendThreadStack(localWriter, (ThreadInfo)t);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return ((Object)localWriter).toString();
        })).forEach((stack, tis) -> {
            try {
                this.printThreadGroup((PrintWriter)writer, (List<ThreadInfo>)tis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    protected void printThreadGroup(PrintWriter writer, List<ThreadInfo> tis) throws UnsupportedEncodingException, IOException {
        if (tis.size() == 1) {
            ThreadInfo t = tis.get(0);
            this.appendThreadHeader(writer, t);
            this.appendThreadStack(writer, t);
            this.appendThreadFooter(writer, t);
        } else {
            ThreadInfo t = tis.get(0);
            writer.write("One header amongst ");
            this.println(writer, Integer.toString(tis.size()));
            this.appendThreadHeader(writer, t);
            this.println(writer, "---------------------");
            this.appendThreadStack(writer, t);
            if (this.hasFooter(t)) {
                writer.write("One footer amongst ");
                this.println(writer, Integer.toString(tis.size()));
                this.appendThreadFooter(writer, t);
                this.println(writer, "---------------------");
                this.println(writer, "\r\n");
            }
        }
    }
}

