/*
 * Decompiled with CFR 0.152.
 */
package io.cormoran.buffer;

import blasd.apex.core.logging.ApexLogHelper;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import io.cormoran.buffer.CloseableIntBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ApexBufferHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexBufferHelper.class);
    @VisibleForTesting
    protected static boolean forceNoSpaceDisk = false;
    @VisibleForTesting
    protected static boolean forceNoHeap = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CloseableIntBuffer makeIntBuffer(int nbIntegers) throws IOException {
        if (nbIntegers < 0) {
            throw new IllegalArgumentException("Can not allocate a buffer with a negative size");
        }
        long targetNbBytes = 4L * (long)nbIntegers;
        Optional<File> tmpFile = ApexBufferHelper.prepareIntArrayInFile(".IntArray1NWriter", targetNbBytes);
        if (tmpFile.isPresent()) {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(tmpFile.get(), "rw");
                try {
                    CloseableIntBuffer closeableIntBuffer;
                    block19: {
                        FileChannel fc = randomAccessFile.getChannel();
                        try {
                            closeableIntBuffer = new CloseableIntBuffer(fc.map(FileChannel.MapMode.READ_WRITE, 0L, fc.size()));
                            return closeableIntBuffer;
                        }
                        finally {
                            if (fc == null) break block19;
                            fc.close();
                        }
                    }
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                    return closeableIntBuffer;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (randomAccessFile == null) throw throwable;
                    randomAccessFile.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        long availableHeap = ApexBufferHelper.getAvailableHeap();
        if (availableHeap < targetNbBytes) {
            throw new IllegalStateException("Not enough disk-space nor memory");
        }
        try {
            int[] array = new int[nbIntegers];
            LOGGER.warn("The disk seems full, allocating in heap");
            return new CloseableIntBuffer(IntBuffer.wrap(array));
        }
        catch (OutOfMemoryError oomError) {
            LOGGER.error("There is neither enough spaceDisk nor heap left for " + nbIntegers + " ints", (Throwable)oomError);
            throw oomError;
        }
    }

    private static long getAvailableHeap() {
        if (forceNoHeap) {
            return 0L;
        }
        long maxHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        long usedHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        return Math.max(0L, maxHeap - usedHeap);
    }

    private static Optional<File> prepareIntArrayInFile(String suffix, long targetNbBytes) throws IOException {
        File tmpFile = File.createTempFile("mat", suffix);
        tmpFile.deleteOnExit();
        long freeSpace = ApexBufferHelper.getFreeSpace(tmpFile);
        if (freeSpace < targetNbBytes) {
            LOGGER.debug("There is only {} disk left while requesting for {}", ApexLogHelper.getNiceMemory(freeSpace), ApexLogHelper.getNiceMemory(targetNbBytes));
            return Optional.empty();
        }
        Throwable throwable = null;
        Object var7_6 = null;
        try (RandomAccessFile out = new RandomAccessFile(tmpFile, "rw");){
            out.setLength(targetNbBytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return Optional.of(tmpFile);
    }

    private static long getFreeSpace(File tmpFile) {
        if (forceNoSpaceDisk) {
            return 0L;
        }
        return tmpFile.getFreeSpace();
    }
}

