/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ImmutableArrayList<T>
extends AbstractList<T> {
    private static final int HASHCODE_CONSTANT = 31;
    protected final T[] underlyingArray;
    protected final int[] indexes;
    protected final int hashCode;

    public ImmutableArrayList(T[] underlyingArray, int[] indexes) {
        this.underlyingArray = underlyingArray;
        this.indexes = indexes;
        this.hashCode = ImmutableArrayList.filteredHashCode(underlyingArray, indexes);
    }

    public ImmutableArrayList(T[] underlyingArray) {
        this.underlyingArray = underlyingArray;
        this.indexes = null;
        this.hashCode = Arrays.hashCode(underlyingArray);
    }

    private static int filteredHashCode(Object[] array, int[] indexes) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        for (int index : indexes) {
            result = 31 * result;
            if (array[index] == null) continue;
            result += array[index].hashCode();
        }
        return result;
    }

    @Override
    public T get(int index) {
        if (this.indexes == null) {
            return this.underlyingArray[index];
        }
        return this.underlyingArray[this.indexes[index]];
    }

    @Override
    public T set(int index, T value) {
        throw new UnsupportedOperationException("Do not mutate as we pre-computed the hashcode");
    }

    @Override
    public int size() {
        if (this.indexes == null) {
            return this.underlyingArray.length;
        }
        return this.indexes.length;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List oList = (List)o;
        if (oList.size() != this.size()) {
            return false;
        }
        if (this.indexes == null) {
            for (int i = 0; i < this.underlyingArray.length; ++i) {
                Object o2;
                T o1 = this.get(i);
                if (Objects.equals(o1, o2 = ((List)o).get(i))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.indexes.length; ++i) {
                Object o2;
                T o1 = this.get(i);
                if (Objects.equals(o1, o2 = ((List)o).get(i))) continue;
                return false;
            }
        }
        return true;
    }
}

