/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavigableMapComparator
implements Comparator<NavigableMap<String, String>>,
Serializable {
    private static final long serialVersionUID = 7928339315645573854L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(NavigableMapComparator.class);

    @Override
    public int compare(NavigableMap<String, String> o1, NavigableMap<String, String> o2) {
        Iterator itKey1 = o1.entrySet().iterator();
        Iterator itKey2 = o2.entrySet().iterator();
        while (itKey1.hasNext() && itKey2.hasNext()) {
            Map.Entry next1 = itKey1.next();
            Map.Entry next2 = itKey2.next();
            int keyCompare = ((String)next1.getKey()).compareTo((String)next2.getKey());
            if (keyCompare == 0) continue;
            return keyCompare;
        }
        if (itKey1.hasNext()) {
            return -1;
        }
        if (itKey2.hasNext()) {
            return 1;
        }
        Iterator itValue1 = o1.entrySet().iterator();
        Iterator itValue2 = o2.entrySet().iterator();
        while (itValue1.hasNext() && itValue2.hasNext()) {
            Map.Entry next1 = itValue1.next();
            Map.Entry next2 = itValue2.next();
            int valueCompare = ((String)next1.getValue()).compareTo((String)next2.getValue());
            if (valueCompare == 0) continue;
            return valueCompare;
        }
        assert (o1.equals(o2));
        return 0;
    }
}

