/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.regex.Pattern;

public class ApexHostDescriptor {
    protected final String host;
    protected final boolean hostIsIp;
    protected final boolean hostIsValid;
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,}$");
    private static final Pattern IP_PATTERN = Pattern.compile("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");

    protected ApexHostDescriptor(String host, boolean hostIsIp, boolean hostIsValid) {
        this.host = host;
        this.hostIsIp = hostIsIp;
        this.hostIsValid = hostIsValid;
    }

    public static Optional<ApexHostDescriptor> parseHost(String host) {
        if (Strings.isNullOrEmpty((String)host)) {
            return Optional.empty();
        }
        boolean hostIsValid = DOMAIN_PATTERN.matcher(host).matches();
        boolean hostIsIp = IP_PATTERN.matcher(host).matches();
        if (host.endsWith("#")) {
            host = host.substring(0, host.length() - 1);
        }
        String lowerCaseHost = host.toLowerCase();
        return Optional.of(new ApexHostDescriptor(lowerCaseHost, hostIsIp, hostIsValid));
    }

    public boolean getIsIP() {
        return this.hostIsIp;
    }

    public boolean getIsValid() {
        return this.hostIsValid;
    }

    public String getHost() {
        return this.host;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApexHostDescriptor other = (ApexHostDescriptor)obj;
        return !(this.host == null ? other.host != null : !this.host.equals(other.host));
    }

    public String toString() {
        return "ApexHostDescriptor [host=" + this.host + ", hostIsIp=" + this.hostIsIp + ", hostIsValid=" + this.hostIsValid + "]";
    }

    public Optional<String> getHostSpace() {
        if (!this.getIsValid() || this.getIsIP()) {
            return Optional.empty();
        }
        String domain = this.getHost();
        int lastDot = domain.lastIndexOf(46);
        if (lastDot < 0) {
            return Optional.of(domain);
        }
        int beforeLastDot = domain.lastIndexOf(46, lastDot - 1);
        if (beforeLastDot < 0) {
            return Optional.of(domain);
        }
        return Optional.of(domain.substring(beforeLastDot + 1));
    }
}

