/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.io;

import blasd.apex.core.memory.IApexMemoryConstants;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class GZipStringBuilder
implements Appendable {
    protected static final int DEFAULT_BUFFER_LENGTH = IApexMemoryConstants.KB_INT;
    protected char[] charBuffer;
    protected ByteArrayOutputStream baos = new ByteArrayOutputStream();
    protected DeflaterOutputStream os;
    protected long count = 0L;

    public GZipStringBuilder() {
        this.charBuffer = new char[DEFAULT_BUFFER_LENGTH];
        this.os = new DeflaterOutputStream((OutputStream)this.baos, true);
    }

    @Override
    public GZipStringBuilder append(CharSequence s) {
        if (s == null) {
            return this.append("null");
        }
        if (s instanceof String) {
            return this.appendChars(s.length(), ((String)s)::getChars);
        }
        if (s instanceof StringBuilder) {
            return this.appendChars(s.length(), (arg_0, arg_1, arg_2, arg_3) -> GZipStringBuilder.lambda$append$0((StringBuilder)s, arg_0, arg_1, arg_2, arg_3));
        }
        return this.append(s.toString());
    }

    private byte[] toBytes(char[] chars, int length, Charset charset) {
        CharBuffer charBuffer = CharBuffer.wrap(chars, 0, length);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        return bytes;
    }

    protected GZipStringBuilder appendChars(int length, CopyChars copyChars) {
        try {
            if (this.charBuffer.length < length) {
                this.charBuffer = new char[length];
            }
            copyChars.getChars(0, length, this.charBuffer, 0);
            byte[] byteBuffer = this.toBytes(this.charBuffer, length, Charsets.UTF_8);
            this.os.write(byteBuffer);
            this.count += (long)length;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected GZipStringBuilder appendStringBuilder(StringBuilder s) {
        try {
            int length = s.length();
            if (this.charBuffer.length < length) {
                this.charBuffer = new char[length];
            }
            s.getChars(0, length, this.charBuffer, 0);
            byte[] byteBuffer = this.toBytes(this.charBuffer, length, Charsets.UTF_8);
            this.os.write(byteBuffer);
            this.count += (long)length;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void writeTo(OutputStream out, Charset charset) {
        try {
            this.os.flush();
            this.baos.writeTo(new InflaterOutputStream(out));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream toInputStream() {
        try {
            this.os.flush();
            return new InflaterInputStream(new ByteArrayInputStream(this.baos.toByteArray()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] copyInflatedByteArray() {
        try {
            this.os.flush();
            return this.baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) {
        if (csq == null) {
            this.append("null");
        } else {
            this.append(csq.subSequence(start, end));
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.os.write(c);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        GZipStringBuilder gZipStringBuilder = this;
        synchronized (gZipStringBuilder) {
            this.charBuffer = new char[DEFAULT_BUFFER_LENGTH];
            this.count = 0L;
            try {
                this.os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.baos.reset();
        }
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(baos, Charsets.UTF_8);
        return new String(baos.toByteArray());
    }

    private static /* synthetic */ void lambda$append$0(StringBuilder rec$, int x$0, int x$1, char[] x$2, int x$3) {
        rec$.getChars(x$0, x$1, x$2, x$3);
    }

    private static interface CopyChars {
        public void getChars(int var1, int var2, char[] var3, int var4);
    }
}

