/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.jvm;

import blasd.apex.core.agent.VirtualMachineWithoutToolsJar;
import blasd.apex.core.jmx.ApexJMXHelper;
import blasd.apex.core.jvm.ApexForOracleJVM;
import blasd.apex.core.jvm.ApexGarbageCollectionNotificationInfo;
import blasd.apex.core.jvm.IApexGarbageCollectionNotificationInfo;
import blasd.apex.core.jvm.IGCInspector;
import blasd.apex.core.logging.ApexLogHelper;
import blasd.apex.core.memory.ApexMemoryHelper;
import blasd.apex.core.memory.histogram.HeapHistogram;
import blasd.apex.core.memory.histogram.IHeapHistogram;
import blasd.apex.core.thread.ApexThreadDump;
import blasd.apex.core.thread.IApexThreadDumper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicLongMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class GCInspector
implements NotificationListener,
InitializingBean,
DisposableBean,
IGCInspector {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GCInspector.class);
    protected final AtomicLong firstGcNotZero = new AtomicLong();
    protected static final long MAX_FIRST_PAUSE_MS = 5000L;
    @Deprecated
    public static final int NS_TO_MS = 1000000;
    public static final float BETWEEN_MINUS_ONE_AND_ZERO = -0.5f;
    public static final long DEFAULT_GCDURATION_MILLIS_INFO_LOG = 200L;
    protected long gcDurationMillisForInfoLog = 200L;
    public static final long DEFAULT_MARKSWEEP_MILLIS_THREADDUMP = 10000L;
    protected long marksweepDurationMillisForThreadDump = 10000L;
    public static final long DEFAULT_MARKSWEEP_MILLIS_HEAPHISTOGRAM = 10000L;
    protected long marksweepDurationMillisForHeapHistogram = 10000L;
    public static final long DEFAULT_MAX_HEAP_GB_HEAPHISTOGRAM = 20L;
    protected long maxHeapGbForHeapHistogram = 20L;
    protected static final MBeanServer MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
    protected static final OperatingSystemMXBean OS_MBEAN = ManagementFactory.getOperatingSystemMXBean();
    protected static final ThreadMXBean THREAD_MBEAN = ManagementFactory.getThreadMXBean();
    protected static final MemoryMXBean MEMORY_MBEAN = ManagementFactory.getMemoryMXBean();
    protected static final List<MemoryPoolMXBean> MEMORY_POOLS_MBEAN = ManagementFactory.getMemoryPoolMXBeans();
    protected AtomicReference<LocalDateTime> latestThreadDump = new AtomicReference();
    private final AtomicReference<Map<? extends String, ? extends Long>> allocatedHeapReference = new AtomicReference(Collections.emptyMap());
    private final AtomicReference<Map<? extends String, ? extends Long>> heapGCNotifReference = new AtomicReference(Collections.emptyMap());
    private static final double HEAP_ALERT_THRESHOLD = 0.9;
    private static final int HEAP_ALERT_PERIOD_IN_MINUTES = 15;
    private final AtomicReference<LocalDateTime> overHeapThresholdSince = new AtomicReference();
    protected final IApexThreadDumper apexThreadDumper;
    protected final AtomicLong targetMaxTotalMemory = new AtomicLong(Long.MAX_VALUE);
    public static final Set<String> FULL_GC_NAMES = ImmutableSet.of((Object)"PS MarkSweep", (Object)"G1 Old Generation");
    private static final int HEAP_HISTO_LIMIT_NB_ROWS = 20;

    public GCInspector(IApexThreadDumper apexThreadDumper) {
        this.apexThreadDumper = apexThreadDumper;
    }

    public GCInspector() {
        this(new ApexThreadDump(ManagementFactory.getThreadMXBean()));
    }

    @ManagedOperation
    public void setTargetMaxTotalMemory(String targetMax) {
        long asLong = ApexMemoryHelper.memoryAsLong(targetMax);
        this.targetMaxTotalMemory.set(asLong);
    }

    @ManagedAttribute
    public String getTargetMaxTotalMemory() {
        return ApexMemoryHelper.memoryAsString(this.targetMaxTotalMemory.get());
    }

    public void afterPropertiesSet() throws MalformedObjectNameException, InstanceNotFoundException {
        ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
        for (ObjectName name : MBEAN_SERVER.queryNames(gcName, null)) {
            MBEAN_SERVER.addNotificationListener(name, this, null, null);
        }
    }

    @Deprecated
    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.executeDuringShutdown(), this.getClass().getSimpleName() + "-ShutdownHook"));
    }

    protected void executeDuringShutdown() {
        if (GCInspector.inUnitTest()) {
            LOGGER.info("Skip GCInspector closing information as current run is a unit-test");
        } else {
            this.printSmartThreadDump();
            this.printHeapHistogram(20);
        }
    }

    public static boolean inUnitTest() {
        Optional<StackTraceElement> matching = Arrays.stream(Thread.currentThread().getStackTrace()).filter(ste -> Arrays.asList(".surefire.", ".failsafe.", ".junit.").stream().filter(name -> ste.getClassName().contains((CharSequence)name)).findAny().isPresent()).findAny();
        matching.ifPresent(ste -> LOGGER.info("We have detected a unit-test with: {}", ste));
        return matching.isPresent();
    }

    public void destroy() throws Exception {
        this.removeNotificationListener();
        this.executeDuringShutdown();
    }

    protected void removeNotificationListener() throws MalformedObjectNameException, ListenerNotFoundException {
        ObjectName gcName = new ObjectName("java.lang:type=GarbageCollector,*");
        for (ObjectName name : MBEAN_SERVER.queryNames(gcName, null)) {
            try {
                MBEAN_SERVER.removeNotificationListener(name, this);
            }
            catch (RuntimeException | InstanceNotFoundException e) {
                LOGGER.debug("Failure for " + name, (Throwable)e);
            }
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (type.equals("com.sun.management.gc.notification")) {
            CompositeData cd = (CompositeData)notification.getUserData();
            ApexGarbageCollectionNotificationInfo info = ApexGarbageCollectionNotificationInfo.from(cd);
            this.doLog(info);
        }
    }

    protected long computeDurationMs(IApexGarbageCollectionNotificationInfo info) {
        long rawDuration = info.getGcDuration();
        if (rawDuration == 0L) {
            return 0L;
        }
        if (this.firstGcNotZero.compareAndSet(0L, rawDuration)) {
            if (this.firstGcNotZero.get() > 5000L) {
                LOGGER.warn("We guess GC times are expressed in ns instead of ms since first pause lasted {}?s", (Object)this.firstGcNotZero.get());
            } else {
                LOGGER.info("We guess GC times are expressed in ms as first GC pause lasted {}?s", (Object)this.firstGcNotZero.get());
            }
        }
        if (this.firstGcNotZero.get() > 5000L) {
            return TimeUnit.NANOSECONDS.toMillis(rawDuration);
        }
        return rawDuration;
    }

    protected String makeGCMessage(IApexGarbageCollectionNotificationInfo info) {
        long duration = this.computeDurationMs(info);
        String gctype = info.getGcAction();
        if ("end of minor GC".equals(gctype)) {
            gctype = "Young Gen GC";
        } else if ("end of major GC".equals(gctype)) {
            gctype = "Old Gen GC";
        }
        StringBuilder sb = new StringBuilder();
        this.appendCPU(sb);
        this.appendCurrentGCDuration(sb, info, duration);
        long totalAfterMinusbefore = 0L;
        NavigableSet<String> keys = this.getSortedGCKeys(info);
        long totalHeapUsedBefore = 0L;
        long totalHeapUsedAfter = 0L;
        for (String key : keys) {
            MemoryUsage before = info.getMemoryUsageBeforeGc().get(key);
            MemoryUsage after = info.getMemoryUsageAfterGc().get(key);
            if (after == null) {
                LOGGER.debug("No .getMemoryUsageAfterGc for {}", (Object)key);
                continue;
            }
            long afterUsed = after.getUsed();
            long beforeUsed = before.getUsed();
            totalHeapUsedBefore += beforeUsed;
            totalHeapUsedAfter += afterUsed;
            if (afterUsed != beforeUsed) {
                long afterMinusBefore = afterUsed - beforeUsed;
                totalAfterMinusbefore += afterMinusBefore;
            }
            this.appendMovedMemory(sb, key, before, after);
            if (key.equals(keys.last())) continue;
            sb.append("; ");
        }
        this.appendHeap(sb, totalHeapUsedAfter);
        if (totalAfterMinusbefore != 0L) {
            this.appendDetailsAboutMove(sb, totalAfterMinusbefore, totalHeapUsedBefore);
        }
        this.appendDirectMemoryAndThreads(sb);
        return sb.toString();
    }

    protected void appendMovedMemory(StringBuilder sb, String key, MemoryUsage before, MemoryUsage after) {
        long beforeUsed = before.getUsed();
        long beforeCommited = before.getCommitted();
        long afterUsed = after.getUsed();
        long afterCommited = after.getCommitted();
        if (after.getUsed() == before.getUsed()) {
            sb.append(key).append(" ==");
            this.appendPercentage(sb, afterUsed, afterCommited);
            sb.append(" (");
            GCInspector.appendSize(sb, afterCommited);
            sb.append(")");
        } else {
            sb.append(key).append(" ");
            this.appendPercentage(sb, beforeUsed, beforeCommited);
            sb.append("->");
            this.appendPercentage(sb, afterUsed, afterCommited);
            sb.append(" (");
            GCInspector.appendSize(sb, beforeUsed);
            if (after.getUsed() > before.getUsed()) {
                sb.append('+');
            } else {
                LOGGER.trace("A negative number already provides a '-' sign");
            }
            long afterMinusBefore = afterUsed - beforeUsed;
            GCInspector.appendSize(sb, afterMinusBefore);
            sb.append("->");
            GCInspector.appendSize(sb, afterUsed);
            sb.append(")");
        }
    }

    protected NavigableSet<String> getSortedGCKeys(IApexGarbageCollectionNotificationInfo info) {
        return new TreeSet<String>(info.getMemoryUsageBeforeGc().keySet());
    }

    protected void appendCurrentGCDuration(StringBuilder sb, IApexGarbageCollectionNotificationInfo info, long duration) {
        sb.append(info.getGcName()).append(" lasted ").append(ApexLogHelper.getNiceTime(duration)).append(". ");
    }

    protected void appendHeap(StringBuilder sb, long totalHeapUsedAfter) {
        long maxHeap = MEMORY_MBEAN.getHeapMemoryUsage().getMax();
        sb.append(" - Heap: fromGC=");
        GCInspector.appendSize(sb, totalHeapUsedAfter);
        sb.append(" - ").append(ApexLogHelper.getNicePercentage(totalHeapUsedAfter, maxHeap));
        long heapAsTotal = MEMORY_MBEAN.getHeapMemoryUsage().getUsed();
        sb.append(" - fromMX=");
        GCInspector.appendSize(sb, heapAsTotal);
        sb.append(" - ").append(ApexLogHelper.getNicePercentage(heapAsTotal, maxHeap));
    }

    protected void appendNonHeap(StringBuilder sb, long nonHeapUsedAfter) {
        sb.append(" - Non-Heap:");
        GCInspector.appendSize(sb, nonHeapUsedAfter);
    }

    protected void appendDetailsAboutMove(StringBuilder sb, long totalAfterMinusbefore, long totalHeapUsedBefore) {
        sb.append("=");
        GCInspector.appendSize(sb, totalHeapUsedBefore);
        if (totalAfterMinusbefore < 0L) {
            GCInspector.appendSize(sb, totalAfterMinusbefore);
            sb.append(" garbage collected");
        }
        Map<? extends String, ? extends Long> immutableCurrentHeapByThread = this.getThreadNameToAllocatedHeap();
        Map<? extends String, ? extends Long> previousStatus = this.getAndSetByThreadRef(immutableCurrentHeapByThread);
        AtomicLongMap currentHeap = AtomicLongMap.create(immutableCurrentHeapByThread);
        this.adjustWithReference((AtomicLongMap<String>)currentHeap, previousStatus);
        if (!currentHeap.isEmpty()) {
            long sumPrevious = previousStatus.values().stream().mapToLong(Long::longValue).sum();
            long sumCurrent = immutableCurrentHeapByThread.values().stream().mapToLong(Long::longValue).sum();
            if (sumCurrent > sumPrevious) {
                long transientlyGenerated = sumCurrent - sumPrevious;
                sb.append(" after allocating ");
                GCInspector.appendSize(sb, transientlyGenerated);
                sb.append(" through all threads");
            }
            Map valueOrdered = ApexJMXHelper.convertToJMXValueOrderedMap(currentHeap.asMap(), true);
            assert (!valueOrdered.isEmpty());
            Map.Entry maxEntry = valueOrdered.entrySet().iterator().next();
            if ((Long)maxEntry.getValue() > 0L) {
                sb.append(" including ");
                GCInspector.appendSize(sb, (Long)maxEntry.getValue());
                sb.append(" from ");
                sb.append((String)maxEntry.getKey());
                AtomicLongMap<String> groupBy = this.groupThreadNames(currentHeap.asMap());
                Map groupByValueOrdered = ApexJMXHelper.convertToJMXValueOrderedMap(groupBy.asMap(), true);
                Map.Entry groupByMaxEntry = groupByValueOrdered.entrySet().iterator().next();
                if ((Long)groupByMaxEntry.getValue() > 0L && !((String)groupByMaxEntry.getKey()).equals(maxEntry.getKey())) {
                    sb.append(" and ");
                    GCInspector.appendSize(sb, (Long)groupByMaxEntry.getValue());
                    sb.append(" from ");
                    sb.append((String)groupByMaxEntry.getKey());
                }
            } else {
                LOGGER.debug("We have only decreasing in {}", valueOrdered);
            }
        }
    }

    protected Map<? extends String, ? extends Long> getAndSetByThreadRef(Map<? extends String, ? extends Long> immutableCurrentHeapByThread) {
        return this.heapGCNotifReference.getAndSet(immutableCurrentHeapByThread);
    }

    protected String getCurrentMemoryStatusMessage() {
        StringBuilder sb = new StringBuilder();
        this.appendCPU(sb);
        long totalHeapUsedAfter = 0L;
        long totalNonHeapUsedAfter = 0L;
        for (MemoryPoolMXBean key : MEMORY_POOLS_MBEAN) {
            MemoryUsage after = key.getUsage();
            if (after == null) continue;
            long afterUsed = after.getUsed();
            long afterCommited = after.getCommitted();
            if (key.getType() == MemoryType.HEAP) {
                totalHeapUsedAfter += afterUsed;
            } else {
                totalNonHeapUsedAfter += afterUsed;
            }
            sb.append(key.getName()).append(" ==");
            GCInspector.appendSize(sb, afterUsed);
            sb.append(" == ");
            this.appendPercentage(sb, afterUsed, afterCommited);
            sb.append("; ");
        }
        this.appendHeap(sb, totalHeapUsedAfter);
        this.appendNonHeap(sb, totalNonHeapUsedAfter);
        long directAndThreadBytes = this.appendDirectMemoryAndThreads(sb);
        long totalMemoryFootprint = totalHeapUsedAfter + directAndThreadBytes;
        sb.append(" - GrandTotal:");
        GCInspector.appendSize(sb, totalMemoryFootprint);
        return sb.toString();
    }

    protected void appendCPU(StringBuilder sb) {
        OptionalDouble optCpu = ApexForOracleJVM.getCpu(OS_MBEAN);
        optCpu.ifPresent(cpu -> {
            if (cpu >= -0.5) {
                sb.append("CPU=");
                this.appendPercentage(sb, (long)(cpu * 1000.0), 1000L);
                sb.append(" - ");
            }
        });
    }

    protected long appendDirectMemoryAndThreads(StringBuilder sb) {
        long additionalMemory = 0L;
        BufferPoolMXBean directMemoryBean = this.directMemoryStatus();
        if (directMemoryBean != null) {
            sb.append("; ");
            sb.append("DirectMemory").append(": ");
            long directMemoryUsed = directMemoryBean.getMemoryUsed();
            additionalMemory += directMemoryUsed;
            GCInspector.appendSize(sb, directMemoryUsed);
            sb.append(" over max=");
            long maxDirectMemory = ApexForOracleJVM.maxDirectMemory();
            GCInspector.appendSize(sb, maxDirectMemory);
            sb.append(" - ").append(ApexLogHelper.getNicePercentage(directMemoryUsed, maxDirectMemory));
            sb.append(" (allocationCount=").append(directMemoryBean.getCount()).append(')');
        }
        long nbLiveThreads = THREAD_MBEAN.getThreadCount();
        sb.append(" LiveThreadCount=");
        sb.append(nbLiveThreads);
        long threadMemory = nbLiveThreads * GCInspector.getMemoryPerThread();
        additionalMemory += threadMemory;
        sb.append(" (");
        GCInspector.appendSize(sb, threadMemory);
        sb.append(")");
        return additionalMemory;
    }

    protected void appendPercentage(StringBuilder sb, long numerator, long denominator) {
        sb.append(ApexLogHelper.getNicePercentage(numerator, denominator));
    }

    public static void appendSize(StringBuilder sb, long size) {
        sb.append(ApexLogHelper.getNiceMemory(size));
    }

    @Deprecated
    public static String getNiceBytes(long size) {
        return ApexLogHelper.getNiceMemory(size).toString();
    }

    protected void doLog(IApexGarbageCollectionNotificationInfo info) {
        long duration = this.computeDurationMs(info);
        String gcMessage = this.makeGCMessage(info);
        if (duration >= this.gcDurationMillisForInfoLog) {
            LOGGER.info(gcMessage);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(gcMessage);
        }
        if (this.isFullGC(info)) {
            this.onFullGC(info);
        }
        this.logIfMemoryOverCap();
    }

    protected void onFullGC(IApexGarbageCollectionNotificationInfo info) {
        long heapUsed;
        long duration = this.computeDurationMs(info);
        if (duration > this.marksweepDurationMillisForThreadDump) {
            this.printThreadDump();
        }
        if (duration > this.marksweepDurationMillisForHeapHistogram && (heapUsed = this.getUsedHeap()) < this.maxHeapGbForHeapHistogram * 0x40000000L) {
            this.printHeapHistogram(20);
        }
    }

    protected void logIfMemoryOverCap() {
        long heapMax;
        long heapUsed = this.getUsedHeap();
        if (this.isOverThreashold(heapUsed, heapMax = this.getMaxHeap())) {
            LocalDateTime now = new LocalDateTime();
            this.overHeapThresholdSince.compareAndSet(null, now);
            LocalDateTime overThresholdSince = this.overHeapThresholdSince.get();
            if (overThresholdSince != null && overThresholdSince.isBefore((ReadablePartial)now.minusMinutes(15))) {
                this.overHeapThresholdSince.set(null);
                this.onOverHeapAlertSinceTooLong(overThresholdSince);
            }
        } else {
            this.overHeapThresholdSince.getAndUpdate(current -> {
                if (current != null) {
                    this.onMemoryBackUnderThreshold(heapUsed, heapMax);
                }
                return null;
            });
        }
    }

    protected boolean isOverThreashold(long heapUsed, long heapMax) {
        return (double)heapUsed > (double)heapMax * 0.9;
    }

    protected long getUsedHeap() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
    }

    protected long getMaxHeap() {
        return ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
    }

    protected void onMemoryBackUnderThreshold(long heapUsed, long heapMax) {
        LOGGER.info("The heap got back under the threashold: {} out of {}", (Object)GCInspector.getNiceBytes(heapUsed), (Object)GCInspector.getNiceBytes(heapMax));
    }

    protected void onOverHeapAlertSinceTooLong(LocalDateTime overThresholdSince) {
        long heapUsed = this.getUsedHeap();
        long heapMax = this.getMaxHeap();
        LOGGER.warn("We have a heap of {} given a max of {} since {}", new Object[]{GCInspector.getNiceBytes(heapUsed), GCInspector.getNiceBytes(heapMax), overThresholdSince});
        this.printThreadDump();
    }

    protected boolean isFullGC(IApexGarbageCollectionNotificationInfo info) {
        return FULL_GC_NAMES.contains(info.getGcName());
    }

    protected void printThreadDump() {
        LocalDateTime beforeThreadDump = new LocalDateTime();
        String threadDumpAsString = this.getAllThreads(true);
        this.latestThreadDump.set(beforeThreadDump);
        LOGGER.warn("Thread Dump: {}", (Object)threadDumpAsString);
    }

    protected void printSmartThreadDump() {
        LocalDateTime beforeThreadDump = new LocalDateTime();
        String threadDumpAsString = this.apexThreadDumper.getSmartThreadDumpAsString(false);
        this.latestThreadDump.set(beforeThreadDump);
        LOGGER.info("Thread Dump: {}", (Object)threadDumpAsString);
    }

    protected void printHeapHistogram(int nbRows) {
        String threadDumpAsString = GCInspector.getHeapHistogramAsString(nbRows);
        LOGGER.info("HeapHistogram: {}{}", (Object)System.lineSeparator(), (Object)threadDumpAsString);
    }

    public static String getHeapHistogramAsString(int nbRows) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GCInspector.streamHeapHistogram(os, nbRows);
        return ((Object)os).toString();
    }

    public static void streamHeapHistogram(OutputStream os, int nbRows) {
        block23: {
            Optional optIS = VirtualMachineWithoutToolsJar.heapHisto().toJavaUtil();
            if (optIS.isPresent()) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)optIS.get(), IHeapHistogram.JMAP_CHARSET);
                     BufferedReader br = new BufferedReader(reader);
                     BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, IHeapHistogram.JMAP_CHARSET));){
                    String nextLine;
                    boolean firstRow = true;
                    AtomicReference<String> lastSkippedRow = new AtomicReference<String>();
                    int nbWritten = 0;
                    while ((nextLine = br.readLine()) != null) {
                        if (nextLine.isEmpty()) continue;
                        if (nbWritten < nbRows) {
                            if (firstRow) {
                                firstRow = !firstRow;
                            } else {
                                bw.newLine();
                            }
                            bw.write(nextLine);
                            ++nbWritten;
                            continue;
                        }
                        lastSkippedRow.set(nextLine);
                    }
                    if (lastSkippedRow.get() != null) {
                        bw.newLine();
                        bw.write((String)lastSkippedRow.get());
                    }
                    break block23;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            LOGGER.warn("VirtualMachine is not available for HeapHisto");
        }
    }

    @Deprecated
    protected static long getMaxDirectMemorySize() {
        return ApexForOracleJVM.maxDirectMemory();
    }

    protected static long getMemoryPerThread() {
        return 0x100000L;
    }

    protected BufferPoolMXBean directMemoryStatus() {
        return ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class).stream().filter(b -> b.getName().equals("direct")).findAny().orElseGet(() -> null);
    }

    @ManagedAttribute
    public Date getLatestThreadDump() {
        LocalDateTime latest = this.latestThreadDump.get();
        if (latest == null) {
            return null;
        }
        return latest.toDate();
    }

    @Override
    @ManagedAttribute
    public void setMarksweepDurationMillisForThreadDump(long marksweepDurationMillisForThreadDump) {
        this.marksweepDurationMillisForThreadDump = marksweepDurationMillisForThreadDump;
    }

    @Override
    @ManagedAttribute
    public long getMarksweepDurationMillisForThreadDump() {
        return this.marksweepDurationMillisForThreadDump;
    }

    @Override
    @ManagedAttribute
    public void setMarksweepDurationMillisForHeapHistogram(long marksweepDurationMillisForHeapHistogram) {
        this.marksweepDurationMillisForHeapHistogram = marksweepDurationMillisForHeapHistogram;
    }

    @Override
    @ManagedAttribute
    public long getMarksweepDurationMillisForHeapHistogram() {
        return this.marksweepDurationMillisForHeapHistogram;
    }

    @Override
    @ManagedAttribute
    public void setMaxHeapGbForHeapHistogram(long maxHeapGbForHeapHistogram) {
        this.maxHeapGbForHeapHistogram = maxHeapGbForHeapHistogram;
    }

    @Override
    @ManagedAttribute
    public long getMaxHeapGbForHeapHistogram() {
        return this.maxHeapGbForHeapHistogram;
    }

    @Override
    @ManagedOperation
    public void markNowAsAllocatedHeapReference() {
        this.allocatedHeapReference.set(this.getThreadNameToAllocatedHeap());
    }

    @Override
    @ManagedOperation
    public void clearAllocatedHeapReference() {
        this.allocatedHeapReference.set(Collections.emptyMap());
    }

    protected Map<? extends String, ? extends Long> getThreadNameToAllocatedHeap() {
        if (ApexForOracleJVM.isThreadAllocatedMemorySupported(THREAD_MBEAN)) {
            if (!ApexForOracleJVM.isThreadAllocatedMemoryEnabled(THREAD_MBEAN)) {
                ApexForOracleJVM.setThreadAllocatedMemoryEnabled(THREAD_MBEAN, true);
            }
            TreeMap<String, Long> threadNameToAllocatedMemory = new TreeMap<String, Long>();
            long[] liveThreadIds = THREAD_MBEAN.getAllThreadIds();
            ThreadInfo[] threadInfos = THREAD_MBEAN.getThreadInfo(liveThreadIds);
            for (int i = 0; i < liveThreadIds.length; ++i) {
                ThreadInfo threadInfo = threadInfos[i];
                if (threadInfo == null) {
                    LOGGER.debug("No more info about thread #{}", (Object)i);
                    continue;
                }
                long threadAllocatedBytes = ApexForOracleJVM.getThreadAllocatedBytes(THREAD_MBEAN, liveThreadIds[i]);
                if (threadAllocatedBytes <= 0L) continue;
                threadNameToAllocatedMemory.put(threadInfo.getThreadName(), threadAllocatedBytes);
            }
            return Collections.unmodifiableMap(threadNameToAllocatedMemory);
        }
        return Collections.emptyMap();
    }

    @Override
    @ManagedAttribute
    public Map<String, String> getThreadNameToAllocatedHeapNiceString() {
        AtomicLongMap threadNameToAllocatedHeap = AtomicLongMap.create(this.getThreadNameToAllocatedHeap());
        this.adjustWithReference((AtomicLongMap<String>)threadNameToAllocatedHeap, this.allocatedHeapReference.get());
        Map orderedByDecreasingSize = ApexJMXHelper.convertToJMXValueOrderedMap(threadNameToAllocatedHeap.asMap(), true);
        return ApexJMXHelper.convertToJMXMapString(GCInspector.convertByteValueToString(orderedByDecreasingSize));
    }

    protected void adjustWithReference(AtomicLongMap<String> currentHeapToAdjust, Map<? extends String, ? extends Long> reference) {
        for (String threadName : currentHeapToAdjust.asMap().keySet()) {
            Long threadReferenceHeap = reference.get(threadName);
            if (threadReferenceHeap == null) continue;
            currentHeapToAdjust.addAndGet((Object)threadName, -threadReferenceHeap.longValue());
        }
    }

    @Override
    @ManagedAttribute
    public Map<String, String> getThreadGroupsToAllocatedHeapNiceString() {
        AtomicLongMap threadNameToAllocatedHeap = AtomicLongMap.create(this.getThreadNameToAllocatedHeap());
        this.adjustWithReference((AtomicLongMap<String>)threadNameToAllocatedHeap, this.allocatedHeapReference.get());
        AtomicLongMap<String> threadGroupToAllocatedHeap = this.groupThreadNames(threadNameToAllocatedHeap.asMap());
        Map orderedByDecreasingSize = ApexJMXHelper.convertToJMXValueOrderedMap(threadGroupToAllocatedHeap.asMap(), true);
        return ApexJMXHelper.convertToJMXMapString(GCInspector.convertByteValueToString(orderedByDecreasingSize));
    }

    protected AtomicLongMap<String> groupThreadNames(Map<String, Long> threadNameToAllocatedHeap) {
        AtomicLongMap threadGroupToAllocatedHeap = AtomicLongMap.create();
        Pattern p = Pattern.compile("(.*?)\\d+");
        for (Map.Entry<String, Long> entry : threadNameToAllocatedHeap.entrySet()) {
            Matcher matcher = p.matcher(entry.getKey());
            if (matcher.matches()) {
                threadGroupToAllocatedHeap.addAndGet((Object)(matcher.group(1) + "X"), entry.getValue().longValue());
                continue;
            }
            threadGroupToAllocatedHeap.addAndGet((Object)entry.getKey(), entry.getValue().longValue());
        }
        return threadGroupToAllocatedHeap;
    }

    public static <T> Map<T, String> convertByteValueToString(Map<T, Long> threadNameToAllocatedHeap) {
        return Maps.transformValues(threadNameToAllocatedHeap, GCInspector::getNiceBytes);
    }

    @Override
    @ManagedOperation
    public String getAllThreads(boolean withoutMonitors) {
        return this.apexThreadDumper.getThreadDumpAsString(!withoutMonitors);
    }

    @Override
    @ManagedOperation
    public String getAllThreadsSmart(boolean withoutMonitors) {
        return this.apexThreadDumper.getSmartThreadDumpAsString(!withoutMonitors);
    }

    @Override
    @ManagedOperation
    public String getHeapHistogram() throws IOException {
        return HeapHistogram.createHeapHistogramAsString();
    }

    @Override
    public String saveHeapDump(Path path) throws IOException {
        return HeapHistogram.saveHeapDump(path.toFile());
    }

    @ManagedOperation
    public String saveHeapDump(String path) throws IOException {
        return this.saveHeapDump(ApexJMXHelper.convertToPath(path));
    }

    @Override
    @ManagedOperation
    public String getAndLogCurrentMemoryStatus() {
        String currentMemoryStatusMessage = this.getCurrentMemoryStatusMessage();
        LOGGER.info(currentMemoryStatusMessage);
        return currentMemoryStatusMessage;
    }
}

