/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.memory;

import blasd.apex.core.memory.IApexMemoryConstants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AtomicLongMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class ApexReferenceHelper {
    private static final long HUNDRED = 100L;
    private static final int NB_ALLOWED_RESET = 10;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexReferenceHelper.class);
    private static final Set<Class<?>> CLASS_TO_DICTIONARIZE = ImmutableSet.of(String.class, LocalDate.class, org.joda.time.LocalDate.class);
    private static final ConcurrentMap<Class<?>, List<Field>> CLASS_TO_ELECTED_FIELDS = new ConcurrentHashMap();
    @VisibleForTesting
    static final ConcurrentMap<Field, ConcurrentMap<Object, Object>> DICTIONARY_FIELDS = new ConcurrentHashMap<Field, ConcurrentMap<Object, Object>>();
    @VisibleForTesting
    static final ConcurrentMap<Class<?>, ConcurrentMap<Object, Object>> DICTIONARY_ARRAY = new ConcurrentHashMap();
    private static final AtomicLongMap<Field> FIELD_TO_CACHE_HIT = AtomicLongMap.create();
    private static final AtomicLongMap<Class<?>> CLASS_TO_CACHE_HIT = AtomicLongMap.create();
    private static final AtomicLongMap<Field> FIELD_TO_NB_RESET = AtomicLongMap.create();

    protected ApexReferenceHelper() {
    }

    public static void clear() {
        CLASS_TO_ELECTED_FIELDS.clear();
        DICTIONARY_FIELDS.clear();
        FIELD_TO_CACHE_HIT.clear();
        FIELD_TO_NB_RESET.clear();
        DICTIONARY_ARRAY.clear();
        CLASS_TO_CACHE_HIT.clear();
    }

    public static void internalizeFields(Object data) {
        if (data == null) {
            return;
        }
        if (data instanceof Object[]) {
            ApexReferenceHelper.internalizeArray((Object[])data);
        } else {
            Class<?> clazz = data.getClass();
            List<Field> fields = ApexReferenceHelper.computeDictionarizableFields(clazz);
            if (fields.isEmpty()) {
                return;
            }
            for (Field f : fields) {
                ApexReferenceHelper.internFieldsFieldValue(f, data);
            }
        }
    }

    protected static void internFieldsFieldValue(Field field, Object object) {
        if (field == null || object == null) {
            return;
        }
        ConcurrentMap fieldDictionary = DICTIONARY_FIELDS.computeIfAbsent(field, k -> new ConcurrentHashMap());
        try {
            Object currentRef = field.get(object);
            if (currentRef != null) {
                Object existingRef = fieldDictionary.putIfAbsent(currentRef, currentRef);
                if (existingRef != null && existingRef != currentRef) {
                    field.set(object, existingRef);
                } else if (existingRef == null) {
                    if (ApexReferenceHelper.shouldCheckDictionary(field, fieldDictionary)) {
                        if (FIELD_TO_NB_RESET.incrementAndGet((Object)field) < 10L) {
                            fieldDictionary.clear();
                        } else {
                            LOGGER.warn("Stop dictionarizing " + field + " as it seems to have very-high cardinality");
                            ApexReferenceHelper.stopDictionarizing(object.getClass(), field);
                        }
                    }
                } else {
                    FIELD_TO_CACHE_HIT.incrementAndGet((Object)field);
                }
            }
        }
        catch (IllegalArgumentException e) {
            ApexReferenceHelper.stopDictionarizing(object.getClass(), field);
        }
        catch (IllegalAccessException e) {
            ApexReferenceHelper.stopDictionarizing(object.getClass(), field);
        }
    }

    protected static boolean shouldCheckDictionary(Field field, Map<?, ?> fieldDictionary) {
        int dSize = fieldDictionary.size();
        return dSize > IApexMemoryConstants.KB_INT && FIELD_TO_CACHE_HIT.get((Object)field) * 100L < (long)dSize;
    }

    protected static boolean shouldCheckDictionary(Class<?> clazz, Map<?, ?> clazzDictionary) {
        int dSize = clazzDictionary.size();
        return dSize > IApexMemoryConstants.KB_INT && CLASS_TO_CACHE_HIT.get(clazz) * 100L < (long)dSize;
    }

    protected static void stopDictionarizing(Class<?> clazz, Field field) {
        if (clazz == null || field == null) {
            return;
        }
        List electedFields = (List)CLASS_TO_ELECTED_FIELDS.get(clazz);
        if (electedFields != null) {
            electedFields.remove(field);
        }
        DICTIONARY_FIELDS.remove(field);
    }

    protected static List<Field> computeDictionarizableFields(Class<?> clazz) {
        List fields = (List)CLASS_TO_ELECTED_FIELDS.get(clazz);
        if (fields != null) {
            return fields;
        }
        CopyOnWriteArrayList preparingFields = new CopyOnWriteArrayList();
        ReflectionUtils.doWithFields(clazz, field -> {
            ReflectionUtils.makeAccessible((Field)field);
            preparingFields.add(field);
        }, field -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            if (!CLASS_TO_DICTIONARIZE.contains(field.getType())) {
                LOGGER.debug("Do not ");
                return false;
            }
            return true;
        });
        CLASS_TO_ELECTED_FIELDS.putIfAbsent(clazz, preparingFields);
        return (List)CLASS_TO_ELECTED_FIELDS.get(clazz);
    }

    public static <T> void internalizeArray(T[] array) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            T newRef;
            T item = array[i];
            if (item == null || (newRef = ApexReferenceHelper.internalize(item)) == item) continue;
            array[i] = newRef;
        }
    }

    public static <T> T internalize(T item) {
        if (item == null) {
            return null;
        }
        if (item instanceof Object[]) {
            ApexReferenceHelper.internalizeArray((Object[])item);
            return item;
        }
        Class<?> clazz = item.getClass();
        if (CLASS_TO_DICTIONARIZE.contains(clazz)) {
            return ApexReferenceHelper.internalizeRef(item);
        }
        ApexReferenceHelper.internalizeFields(item);
        return item;
    }

    public static <T> T internalizeRef(T item) {
        if (item == null) {
            return null;
        }
        Class<?> clazz = item.getClass();
        ConcurrentMap d = DICTIONARY_ARRAY.computeIfAbsent(clazz, k -> new ConcurrentHashMap());
        T previous = d.putIfAbsent(item, item);
        if (previous == null) {
            if (ApexReferenceHelper.shouldCheckDictionary(clazz, d)) {
                d.clear();
            }
            return item;
        }
        CLASS_TO_CACHE_HIT.incrementAndGet(clazz);
        return previous;
    }

    public static void dictionarizeIterable(Iterable<?> iterable) {
        if (iterable == null) {
            return;
        }
        for (Object item : iterable) {
            ApexReferenceHelper.internalizeFields(item);
        }
    }
}

