/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.metrics;

import blasd.apex.core.io.ApexFileHelper;
import blasd.apex.core.logging.ApexLogHelper;
import blasd.apex.core.memory.IApexMemoryConstants;
import blasd.apex.core.metrics.EndMetricEvent;
import blasd.apex.core.metrics.IApexMetricsTowerControl;
import blasd.apex.core.metrics.StartMetricEvent;
import blasd.apex.core.thread.ApexExecutorsHelper;
import blasd.apex.core.thread.IApexThreadDumper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalNotification;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Date;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class ApexMetricsTowerControl
implements IApexMetricsTowerControl,
InitializingBean {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexMetricsTowerControl.class);
    public static final String PATH_JOINER = ".";
    public static final int CACHE_TIMEOUT_MINUTES = 60;
    public static final int CACHE_MAX_SIZE = 1000;
    public static final int DEFAULT_LONGRUNNINGCHECK_SECONDS = 60;
    protected int longRunningCheckSeconds = 60;
    private static final int FACTOR_FOR_OLD = 2;
    protected int factorForOld = 2;
    private static final int FACTOR_FOR_TOO_OLD = 5;
    protected int factorForTooOld = 5;
    private static final String LOG_MESSAGE = "Task active since {} ({}): {}";
    private static final String LOG_MESSAGE_PROGRESS = "Task active since {} ({} since {}): {}";
    protected final LoadingCache<StartMetricEvent, LocalDateTime> activeTasks;
    protected final LoadingCache<StartMetricEvent, StartMetricEvent> verySlowTasks;
    @VisibleForTesting
    protected final AtomicLong endEventNotReceivedExplicitely = new AtomicLong();
    protected final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();
    protected final ScheduledExecutorService logLongRunningES = ApexExecutorsHelper.newSingleThreadScheduledExecutor(this.getClass().getSimpleName());
    protected final IApexThreadDumper apexThreadDumper;

    public ApexMetricsTowerControl(IApexThreadDumper apexThreadDumper) {
        this.apexThreadDumper = apexThreadDumper;
        this.activeTasks = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(ApexExecutorsHelper.DEFAULT_ACTIVE_TASKS).removalListener(this::onActiveTaskRemoval).build(CacheLoader.from(key -> LocalDateTime.now()));
        this.verySlowTasks = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.MINUTES).maximumSize(1000L).concurrencyLevel(ApexExecutorsHelper.DEFAULT_ACTIVE_TASKS).build(CacheLoader.from(startEvent -> startEvent));
    }

    protected void onActiveTaskRemoval(RemovalNotification<StartMetricEvent, LocalDateTime> removal) {
        if (removal.getCause().equals((Object)RemovalCause.EXPIRED)) {
            this.logOnFarTooMuchLongTask((StartMetricEvent)removal.getKey());
        } else if (removal.getCause().equals((Object)RemovalCause.EXPLICIT)) {
            this.logOnEndEvent((StartMetricEvent)removal.getKey());
        }
    }

    protected void logOnFarTooMuchLongTask(StartMetricEvent startEvent) {
        String threadDump = this.apexThreadDumper.getSmartThreadDumpAsString(false);
        LOGGER.error("Task still active after {} {}. We stop monitoring it: {}. ThreadDump: {}", new Object[]{60, TimeUnit.MINUTES, startEvent, threadDump});
    }

    protected void logOnDetectingVeryLongTask(StartMetricEvent startEvent) {
        String threadDump = this.apexThreadDumper.getSmartThreadDumpAsString(false);
        LOGGER.error("Task is marked as very-long: {} ThreadDump: {}", (Object)startEvent, (Object)threadDump);
    }

    protected void logOnEndEvent(StartMetricEvent startEvent) {
        Optional<EndMetricEvent> endEvent = startEvent.getEndEvent();
        if (!endEvent.isPresent()) {
            LOGGER.info("We closed {} without an endEvent ?!", (Object)startEvent);
        } else {
            long timeInMs = endEvent.get().durationInMs();
            long longRunningInMillis = TimeUnit.SECONDS.toMillis(this.longRunningCheckSeconds);
            Object lazyToString = ApexLogHelper.lazyToString(() -> ((EndMetricEvent)endEvent.get()).startEvent.toStringNoStack());
            Object niceTime = ApexLogHelper.getNiceTime(timeInMs);
            if (timeInMs > (long)this.factorForTooOld * longRunningInMillis) {
                LOGGER.info("After {}, end of very-long {}", niceTime, lazyToString);
            } else if (timeInMs > longRunningInMillis) {
                LOGGER.info("After {}, end of long {} ended", niceTime, lazyToString);
            } else {
                LOGGER.trace("After {}, end of {} ended", niceTime, lazyToString);
            }
        }
    }

    @Override
    @ManagedAttribute
    public int getLongRunningCheckSeconds() {
        return this.longRunningCheckSeconds;
    }

    @Override
    @ManagedAttribute
    public void setLongRunningCheckSeconds(int longRunningCheckSeconds) {
        this.longRunningCheckSeconds = longRunningCheckSeconds;
        if (this.scheduledFuture.get() != null) {
            this.scheduleLogLongRunningTasks();
        }
    }

    @ManagedAttribute
    public int getFactorForOld() {
        return this.factorForOld;
    }

    @ManagedAttribute
    public void setFactorForOld(int factorForOld) {
        this.factorForOld = factorForOld;
    }

    @ManagedAttribute
    public int getFactorForTooOld() {
        return this.factorForTooOld;
    }

    @ManagedAttribute
    public void setFactorForTooOld(int factorForTooOld) {
        this.factorForTooOld = factorForTooOld;
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduleLogLongRunningTasks();
    }

    protected void scheduleLogLongRunningTasks() {
        ScheduledFuture<?> cancelMe = this.scheduledFuture.getAndSet(this.logLongRunningES.scheduleWithFixedDelay(() -> this.logLongRunningTasks(), 1L, this.longRunningCheckSeconds, TimeUnit.SECONDS));
        if (cancelMe != null) {
            cancelMe.cancel(true);
        }
    }

    protected void logLongRunningTasks() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime oldBarrier = now.minusSeconds(this.longRunningCheckSeconds);
        LocalDateTime tooOldBarrier = now.minusSeconds(this.factorForOld * this.longRunningCheckSeconds);
        LocalDateTime muchtooOldBarrier = now.minusSeconds(this.factorForTooOld * this.longRunningCheckSeconds);
        this.cleanAndGetActiveTasks().asMap().forEach((startEvent, activeSince) -> {
            int seconds = Seconds.secondsBetween((ReadablePartial)activeSince, (ReadablePartial)now).getSeconds();
            Object time = ApexLogHelper.getNiceTime(seconds, TimeUnit.SECONDS);
            Object cleanKey = this.noNewLine((StartMetricEvent)startEvent);
            if (startEvent.getProgress().isPresent()) {
                Object rate = ApexLogHelper.getNiceRate(startEvent.getProgress().getAsLong(), seconds, TimeUnit.SECONDS);
                if (activeSince.isAfter((ReadablePartial)oldBarrier)) {
                    LOGGER.trace(LOG_MESSAGE_PROGRESS, new Object[]{activeSince, rate, time, cleanKey});
                } else if (activeSince.isBefore((ReadablePartial)muchtooOldBarrier)) {
                    LOGGER.warn(LOG_MESSAGE_PROGRESS, new Object[]{time, rate, activeSince, cleanKey});
                    this.verySlowTasks.refresh(startEvent);
                } else if (activeSince.isBefore((ReadablePartial)tooOldBarrier)) {
                    LOGGER.info(LOG_MESSAGE_PROGRESS, new Object[]{activeSince, rate, time, cleanKey});
                } else {
                    LOGGER.debug(LOG_MESSAGE_PROGRESS, new Object[]{activeSince, rate, time, cleanKey});
                }
            } else if (activeSince.isAfter((ReadablePartial)oldBarrier)) {
                LOGGER.trace(LOG_MESSAGE, new Object[]{activeSince, time, cleanKey});
            } else if (activeSince.isBefore((ReadablePartial)muchtooOldBarrier)) {
                LOGGER.warn(LOG_MESSAGE, new Object[]{activeSince, time, cleanKey});
                this.verySlowTasks.refresh(startEvent);
            } else if (activeSince.isBefore((ReadablePartial)tooOldBarrier)) {
                LOGGER.info(LOG_MESSAGE, new Object[]{activeSince, time, cleanKey});
            } else {
                LOGGER.debug(LOG_MESSAGE, new Object[]{activeSince, time, cleanKey});
            }
        });
    }

    protected LoadingCache<StartMetricEvent, LocalDateTime> cleanAndGetActiveTasks() {
        this.checkForEndEvents();
        return this.activeTasks;
    }

    protected Object noNewLine(StartMetricEvent key) {
        return ApexLogHelper.lazyToString(() -> ApexFileHelper.cleanWhitespaces(ApexLogHelper.getFirstChars(key, IApexMemoryConstants.MB_INT).toString()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onStartEvent(StartMetricEvent startEvent) {
        if (startEvent.source == null) {
            LOGGER.debug("Discard StartEvent which is missing a Source: {}", (Object)startEvent);
        } else if (startEvent.endMetricEvent.get() != null) {
            LOGGER.debug("Discard StartEvent which has already ended: {} -> {}", (Object)startEvent, (Object)startEvent.endMetricEvent.get());
        } else {
            this.activeTasks.getUnchecked((Object)startEvent);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEndEvent(EndMetricEvent endEvent) {
        long timeInMs = endEvent.durationInMs();
        if (timeInMs < 0L) {
            LOGGER.debug("An EndEvent has been submitted without its StartEvent Context having been started: {}", (Object)endEvent);
        } else {
            this.invalidateStartEvent(endEvent.startEvent);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onThrowable(Throwable t) {
        LOGGER.warn("Not managed exception", (Throwable)new RuntimeException(t));
    }

    protected void invalidateStartEvent(StartMetricEvent startEvent) {
        if (this.activeTasks.getIfPresent((Object)startEvent) == null) {
            LOGGER.debug("An EndEvent has been submitted without its StartEvent having been registered, or after having been already invalidated: {}", (Object)startEvent);
        } else {
            this.invalidate(startEvent);
        }
    }

    @Override
    @ManagedAttribute
    public long getActiveTasksSize() {
        return this.cleanAndGetActiveTasks().size();
    }

    protected void checkForEndEvents() {
        this.activeTasks.asMap().keySet().forEach(sme -> sme.getEndEvent().ifPresent(endEvent -> {
            this.endEventNotReceivedExplicitely.incrementAndGet();
            this.onEndEvent((EndMetricEvent)endEvent);
        }));
    }

    @Override
    @ManagedAttribute
    public long getRootActiveTasksSize() {
        Set startMetricEvent = this.activeTasks.asMap().keySet();
        return startMetricEvent.stream().map(s -> {
            Object root = s.getDetail("RootSource");
            if (root == null) {
                return s.source;
            }
            return root;
        }).distinct().count();
    }

    @Override
    @ManagedAttribute
    public NavigableMap<Date, String> getActiveTasks() {
        return this.convertToMapDateString(this.activeTasks.asMap());
    }

    protected NavigableMap<Date, String> convertToMapDateString(ConcurrentMap<?, LocalDateTime> asMap) {
        TreeMap<Date, String> dateToName = new TreeMap<Date, String>();
        for (Map.Entry entry : asMap.entrySet()) {
            Date dateToInsert = ((LocalDateTime)entry.getValue()).toDate();
            while (dateToName.containsKey(dateToInsert)) {
                dateToInsert = new Date(dateToInsert.getTime() + 1L);
            }
            String fullName = String.valueOf(entry.getKey());
            dateToName.put(dateToInsert, fullName);
        }
        return dateToName;
    }

    @ManagedOperation
    public boolean invalidateActiveTasks(String nameOrStar) {
        for (StartMetricEvent startEvent : this.activeTasks.asMap().keySet()) {
            if (!"*".equals(nameOrStar) && !nameOrStar.equals(startEvent.toStringNoStack())) continue;
            this.invalidate(startEvent);
            return true;
        }
        return false;
    }

    protected void invalidate(StartMetricEvent startEvent) {
        this.activeTasks.invalidate((Object)startEvent);
        this.verySlowTasks.invalidate((Object)startEvent);
    }

    @ManagedOperation
    public void setDoRememberStack(boolean doRememberStack) {
        StartMetricEvent.setDoRememberStack(doRememberStack);
    }

    @ManagedOperation
    public String getAllThreads(boolean withoutMonitors) {
        return this.apexThreadDumper.getThreadDumpAsString(!withoutMonitors);
    }

    @ManagedAttribute
    public long getEndedBeforeReceivingEndEvent() {
        return this.endEventNotReceivedExplicitely.get();
    }
}

