/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.primitive;

public class ConcatCharSequence
implements CharSequence {
    protected final CharSequence left;
    protected final CharSequence right;

    public ConcatCharSequence(CharSequence left, CharSequence right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public int length() {
        return this.left.length() + this.right.length();
    }

    @Override
    public char charAt(int index) {
        if (index >= this.left.length()) {
            return this.right.charAt(index - this.left.length());
        }
        return this.left.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (end < this.left.length()) {
            return this.left.subSequence(start, end);
        }
        if (start >= this.left.length()) {
            return this.right.subSequence(start - this.left.length(), end - this.left.length());
        }
        return new ConcatCharSequence(this.left.subSequence(start, this.left.length()), this.right.subSequence(0, end - this.left.length()));
    }

    @Override
    public String toString() {
        return this.left.toString() + this.right.toString();
    }
}

