/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.primitive;

import java.util.Objects;

public class Jdk9CharSequenceParsers {
    public static int parseInt(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = beginIndex;
        int limit = -2147483647;
        if (i < endIndex) {
            char firstChar = s.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Integer.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
                if (++i == endIndex) {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
            }
            int multmin = limit / radix;
            int result = 0;
            while (i < endIndex) {
                int digit = Character.digit(s.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= radix) < limit + digit) {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= digit;
            }
            return negative ? result : -result;
        }
        throw Jdk9CharSequenceParsers.forInputString("");
    }

    public static long parseLong(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        s = Objects.requireNonNull(s);
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        boolean negative = false;
        int i = beginIndex;
        long limit = -9223372036854775807L;
        if (i < endIndex) {
            char firstChar = s.charAt(i);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
            }
            if (i >= endIndex) {
                throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
            }
            long multmin = limit / (long)radix;
            long result = 0L;
            while (i < endIndex) {
                int digit = Character.digit(s.charAt(i), radix);
                if (digit < 0 || result < multmin) {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw Jdk9CharSequenceParsers.forCharSequence(s, beginIndex, endIndex, i);
                }
                ++i;
                result -= (long)digit;
            }
            return negative ? result : -result;
        }
        throw new NumberFormatException("");
    }

    public static short parseShort(CharSequence s, int beginIndex, int endIndex, int radix) throws NumberFormatException {
        int i = Jdk9CharSequenceParsers.parseInt(s, beginIndex, endIndex, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException("Value out of range. Value:\"" + s.subSequence(beginIndex, endIndex) + "\" Radix:" + radix);
        }
        return (short)i;
    }

    static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    static NumberFormatException forCharSequence(CharSequence s, int beginIndex, int endIndex, int errorIndex) {
        return new NumberFormatException("Error at index " + (errorIndex - beginIndex) + " in: \"" + s.subSequence(beginIndex, endIndex) + "\"");
    }
}

