/*
 * Decompiled with CFR 0.152.
 */
package blasd.apex.core.util;

import blasd.apex.core.memory.ApexMemoryHelper;
import blasd.apex.core.util.SystemUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexProcessHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexProcessHelper.class);
    protected static final int OS_MARKER_LINUX = 0;
    protected static final int OS_MARKER_WINDOWS = 1;
    protected static final int OS_MARKER_MAC = 2;
    private static final String CLASS_PROCESS_UNIX = "java.lang.UNIXProcess";

    public static synchronized long getPidOfProcess(Process p) {
        long pid = -1L;
        try {
            if (ApexProcessHelper.isUnixProcess(p.getClass().getName())) {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                pid = f.getLong(p);
                f.setAccessible(false);
            }
        }
        catch (Exception e) {
            pid = -1L;
        }
        return pid;
    }

    private static boolean isUnixProcess(String className) {
        return className.equals(CLASS_PROCESS_UNIX);
    }

    public static OptionalLong getProcessResidentMemory(long pid) throws IOException {
        int osFlag;
        String pidAsString = Long.toString(pid);
        ProcessBuilder memoryBuilder = SystemUtils.IS_OS_MAC ? new ProcessBuilder("/usr/bin/vmmap", "-summary", pidAsString) : (SystemUtils.IS_OS_WINDOWS ? new ProcessBuilder("tasklist.exe", "/fi", "PID eq " + pidAsString, "/fo", "csv", "/nh") : new ProcessBuilder("pmap", "-x", pidAsString));
        memoryBuilder.redirectErrorStream(true);
        LOGGER.debug("About to execute {}", (Object)ApexProcessHelper.getCommandAsString(memoryBuilder.command()));
        Process memoryProcess = memoryBuilder.start();
        InputStream inputStream = memoryProcess.getInputStream();
        if (SystemUtils.IS_OS_LINUX) {
            osFlag = 0;
        } else if (SystemUtils.IS_OS_WINDOWS) {
            osFlag = 1;
        } else if (SystemUtils.IS_OS_MAC) {
            osFlag = 2;
        } else {
            LOGGER.trace("Unknown OS: {}", (Object)SystemUtils.OS_NAME);
            return OptionalLong.empty();
        }
        return ApexProcessHelper.extractMemory(osFlag, inputStream);
    }

    public static String getCommandAsString(List<String> command) {
        return command.stream().map(s -> {
            if (s.contains(" ")) {
                return "\"" + s + "\"";
            }
            return s;
        }).collect(Collectors.joining(" "));
    }

    @VisibleForTesting
    protected static OptionalLong extractMemory(final int osFlag, InputStream inputStream) throws IOException {
        LineProcessor<String> processor = new LineProcessor<String>(){
            AtomicReference<String> lastLine = new AtomicReference<String>("");

            public boolean processLine(String line) throws IOException {
                if (!line.isEmpty()) {
                    this.lastLine.set(line);
                }
                if (osFlag == 2) {
                    return !line.trim().startsWith("TOTAL");
                }
                return true;
            }

            public String getResult() {
                return this.lastLine.get();
            }
        };
        String lastLine = ((String)CharStreams.readLines((Readable)new InputStreamReader(inputStream), (LineProcessor)processor)).trim();
        if (lastLine.isEmpty()) {
            LOGGER.trace("Unexpected row: {}", (Object)lastLine);
            return OptionalLong.empty();
        }
        if (osFlag == 2) {
            if ((lastLine = lastLine.trim()).startsWith("TOTAL")) {
                int firstSpace = (lastLine = lastLine.substring("TOTAL".length()).trim()).indexOf(32);
                if (firstSpace < 0) {
                    return OptionalLong.empty();
                }
                lastLine = lastLine.substring(firstSpace + 1).trim();
                int secondSpace = lastLine.indexOf(32);
                lastLine = lastLine.substring(0, secondSpace + 1).trim();
                long memory = ApexMemoryHelper.memoryAsLong(lastLine);
                return OptionalLong.of(memory);
            }
            LOGGER.trace("Unexpected row: {}", (Object)lastLine);
            return OptionalLong.empty();
        }
        if (osFlag == 1) {
            String WINDOWS_MEMORY_PATTERN = "\",\"";
            try {
                int indexLastComa = lastLine.lastIndexOf(WINDOWS_MEMORY_PATTERN);
                if (indexLastComa < 0) {
                    return OptionalLong.empty();
                }
                String memoryString = lastLine.substring(indexLastComa + WINDOWS_MEMORY_PATTERN.length(), lastLine.length() - "\"".length());
                if (memoryString.length() >= 1 && memoryString.charAt(0) == '\"') {
                    memoryString = memoryString.substring(1, memoryString.length() - 1);
                }
                long memory = ApexMemoryHelper.memoryAsLong(memoryString);
                return OptionalLong.of(memory);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Issue when extracting memory from '" + lastLine + "'", e);
            }
        }
        if ((lastLine = lastLine.trim()).startsWith("total")) {
            long memory;
            int betweenTotalAndKbytes = (lastLine = lastLine.substring("total".length()).replaceAll("\\s+", " ").trim()).indexOf(32);
            if (betweenTotalAndKbytes < 0) {
                memory = ApexMemoryHelper.memoryAsLong(lastLine);
            } else {
                String unit = lastLine.substring(0, betweenTotalAndKbytes);
                int betweenKBytesAndRSS = lastLine.indexOf(32, betweenTotalAndKbytes + 1);
                int betweenRSSAndDirty = lastLine.indexOf(32, betweenKBytesAndRSS + 1);
                String rss = lastLine.substring(betweenKBytesAndRSS + 1, betweenRSSAndDirty);
                memory = ApexMemoryHelper.memoryAsLong(rss + unit);
            }
            return OptionalLong.of(memory);
        }
        LOGGER.trace("Unexpected row: {}", (Object)lastLine);
        return OptionalLong.empty();
    }
}

