/*
 * Decompiled with CFR 0.152.
 */
package io.cormoran.buffer;

import blasd.apex.core.logging.ApexLogHelper;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import io.cormoran.buffer.CloseableIntBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ApexBufferHelper {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ApexBufferHelper.class);
    @VisibleForTesting
    protected static boolean forceNoSpaceDisk = false;
    @VisibleForTesting
    protected static boolean forceNoHeap = false;

    /*
     * Exception decompiling
     */
    public static CloseableIntBuffer makeIntBuffer(int nbIntegers) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long getAvailableHeap() {
        if (forceNoHeap) {
            return 0L;
        }
        long maxHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        long usedHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
        return Math.max(0L, maxHeap - usedHeap);
    }

    private static Optional<File> prepareIntArrayInFile(String suffix, long targetNbBytes) throws IOException {
        File tmpFile = File.createTempFile("mat", suffix);
        tmpFile.deleteOnExit();
        long freeSpace = ApexBufferHelper.getFreeSpace(tmpFile);
        if (freeSpace < targetNbBytes) {
            LOGGER.debug("There is only {} disk left while requesting for {}", ApexLogHelper.getNiceMemory(freeSpace), ApexLogHelper.getNiceMemory(targetNbBytes));
            return Optional.empty();
        }
        try (RandomAccessFile out = new RandomAccessFile(tmpFile, "rw");){
            out.setLength(targetNbBytes);
        }
        return Optional.of(tmpFile);
    }

    private static long getFreeSpace(File tmpFile) {
        if (forceNoSpaceDisk) {
            return 0L;
        }
        return tmpFile.getFreeSpace();
    }
}

