/*
 * Decompiled with CFR 0.152.
 */
package com.github.bleeding182.sharedpreferences.annotations.processor;

import com.github.bleeding182.sharedpreferences.PreferenceType;
import com.github.bleeding182.sharedpreferences.annotations.DefaultValue;
import com.github.bleeding182.sharedpreferences.annotations.Type;
import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;

public class Preference {
    private static final Set<Modifier> setPublic = new HashSet<Modifier>();
    private static final String PARAM_DEFAULT_VALUE = "defaultValue";
    private static final String VALUE = "value";
    private final VariableElement mElement;
    private final PreferenceType mType;
    private final String mPreferenceName;
    private final String mPreferenceId;
    private final String mBooleanPrefix;
    private final boolean hasDefaultValue;
    private final boolean createDefaultGetter;
    private final String mDefaultValue;

    public static String camelCaseName(String name) {
        String[] split = name.toLowerCase().split("_");
        String ret = split[0];
        for (int i = 1; i < split.length; ++i) {
            ret = ret + Character.toUpperCase(split[i].charAt(0)) + split[i].substring(1);
        }
        return ret;
    }

    public Preference(String preferenceName, String preferenceId, VariableElement element, PreferenceType defaultType) {
        this.mPreferenceName = preferenceName;
        this.mPreferenceId = preferenceId;
        this.mElement = element;
        Type type = element.getAnnotation(Type.class);
        if (type == null) {
            this.mType = defaultType != null ? defaultType : PreferenceType.STRING;
            this.mBooleanPrefix = "is";
        } else {
            this.mType = type.value();
            this.mBooleanPrefix = type.booleanPrefix();
        }
        DefaultValue defValue = element.getAnnotation(DefaultValue.class);
        if (defValue != null) {
            this.hasDefaultValue = true;
            this.mDefaultValue = defValue.value();
            this.createDefaultGetter = defValue.createDefaultGetter();
        } else {
            this.hasDefaultValue = false;
            this.createDefaultGetter = true;
            this.mDefaultValue = null;
        }
    }

    public VariableElement getElement() {
        return this.mElement;
    }

    public void writeGetter(JavaWriter writer) throws IOException {
        String prefix;
        String string = prefix = this.mType == PreferenceType.BOOLEAN ? this.mBooleanPrefix : "get";
        if (this.hasDefaultValue) {
            writer.emitEmptyLine().emitJavadoc("gets '%s' from the preferences, <b>%s</b> by default if not yet set.", new Object[]{this.mPreferenceId, this.mDefaultValue}).beginMethod(this.mType.getReturnType(), prefix + this.getPreferenceNameUpperFirst(), setPublic, new String[0]).emitStatement("return get%1$s(\"%2$s\", %3$s)", new Object[]{this.mType.getFullName(), this.mPreferenceId, this.mDefaultValue}).endMethod();
        }
        if (!this.createDefaultGetter) {
            return;
        }
        writer.emitEmptyLine().emitJavadoc("gets '%s' from the preferences.\n@param %s the default value to use", new Object[]{this.mPreferenceId, PARAM_DEFAULT_VALUE}).beginMethod(this.mType.getReturnType(), prefix + this.getPreferenceNameUpperFirst(), setPublic, new String[]{this.mType.getReturnType(), PARAM_DEFAULT_VALUE}).emitStatement("return get%1$s(\"%2$s\", %3$s)", new Object[]{this.mType.getFullName(), this.mPreferenceId, PARAM_DEFAULT_VALUE}).endMethod();
    }

    public String getPreferenceNameUpperFirst() {
        return Character.toUpperCase(this.mPreferenceName.charAt(0)) + this.mPreferenceName.substring(1);
    }

    public void writeSetter(JavaWriter writer) throws IOException {
        writer.emitEmptyLine().emitJavadoc("sets '%1$s' in the preferences.\n@param %2$s the new value for '%1$s'", new Object[]{this.mPreferenceId, VALUE}).beginMethod("void", "set" + this.getPreferenceNameUpperFirst(), setPublic, new String[]{this.mType.getReturnType(), VALUE}).emitStatement("edit().put%1$s(\"%2$s\", %3$s).apply()", new Object[]{this.mType.getFullName(), this.mPreferenceName, VALUE}).endMethod();
    }

    public void writeChainSetter(JavaWriter writer, String editorType, String editor) throws IOException {
        writer.emitEmptyLine().emitJavadoc("sets '%1$s' in the preferences.\n@param %2$s the new value for '%1$s'", new Object[]{this.mPreferenceId, VALUE}).beginMethod(editorType, "set" + this.getPreferenceNameUpperFirst(), setPublic, new String[]{this.mType.getReturnType(), VALUE}).emitStatement("%1$s.put%2$s(\"%3$s\", %4$s)", new Object[]{editor, this.mType.getFullName(), this.mPreferenceName, VALUE}).emitStatement("return this", new Object[0]).endMethod();
    }

    static {
        setPublic.add(Modifier.PUBLIC);
    }
}

