/*
 * Decompiled with CFR 0.152.
 */
package com.github.bleeding182.sharedpreferences.annotations.processor;

import android.content.Context;
import android.content.SharedPreferences;
import com.github.bleeding182.sharedpreferences.PreferenceType;
import com.github.bleeding182.sharedpreferences.annotations.DefaultPreferenceName;
import com.github.bleeding182.sharedpreferences.annotations.DefaultPreferenceType;
import com.github.bleeding182.sharedpreferences.annotations.SharedPreference;
import com.github.bleeding182.sharedpreferences.annotations.processor.Modifier;
import com.github.bleeding182.sharedpreferences.annotations.processor.Preference;
import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class PreferenceHolder {
    private static final String PAR_CONTEXT = "ctx";
    private static final String PAR_NAME = "name";
    private static final String PAR_EDITOR = "editor";
    private static final String PREFERENCES = "mPreferences";
    private static final String EDITOR = "mEditor";
    private static final String DEFAULT_PREFERENCES_NAME = "default_preferences";
    private final TypeElement mElement;
    private final JavaWriter mWriter;
    private final String preferencesName;
    private final String className;
    private final String editorName;
    private final SortedMap<String, Preference> preferences = new TreeMap<String, Preference>();

    public PreferenceHolder(TypeElement element, Filer filer, Messager messager) throws IOException {
        this.mElement = element;
        SharedPreference sharedPreference = this.mElement.getAnnotation(SharedPreference.class);
        String name = sharedPreference.value().isEmpty() ? this.mElement.getSimpleName().toString() : sharedPreference.value();
        this.className = name + sharedPreference.preferencesSuffix();
        this.editorName = name + sharedPreference.editorSuffix();
        JavaFileObject jfo = filer.createSourceFile(this.getPackageName() + "." + this.className, new Element[0]);
        this.mWriter = new JavaWriter(jfo.openWriter());
        DefaultPreferenceName defName = element.getAnnotation(DefaultPreferenceName.class);
        this.preferencesName = defName != null ? defName.value() : DEFAULT_PREFERENCES_NAME;
        DefaultPreferenceType defType = element.getAnnotation(DefaultPreferenceType.class);
        PreferenceType defaultPreferenceType = defType != null ? defType.value() : null;
        LinkedHashSet<String> preferenceIds = new LinkedHashSet<String>();
        for (Element element2 : element.getEnclosedElements()) {
            if (!element2.getKind().isField()) {
                messager.printMessage(Diagnostic.Kind.WARNING, element2.getSimpleName() + " is not a field", element2);
                continue;
            }
            VariableElement var = (VariableElement)element2;
            if (!var.asType().toString().equals("java.lang.String")) {
                messager.printMessage(Diagnostic.Kind.WARNING, var.asType().toString() + " is not of type String", element2);
                continue;
            }
            if (var.getConstantValue() == null) {
                messager.printMessage(Diagnostic.Kind.ERROR, var.getSimpleName() + " is not final or no value is set", element2);
                continue;
            }
            String preferenceName = Preference.camelCaseName(var.getSimpleName().toString());
            Preference old = (Preference)this.preferences.get(preferenceName);
            if (old != null) {
                messager.printMessage(Diagnostic.Kind.WARNING, preferenceName + " used here is ignored", var);
                messager.printMessage(Diagnostic.Kind.WARNING, "because it was already defined here", old.getElement());
                continue;
            }
            String id = var.getConstantValue().toString();
            if (!preferenceIds.add(id)) {
                messager.printMessage(Diagnostic.Kind.WARNING, "preference id " + id + " is already in use");
            }
            this.preferences.put(preferenceName, new Preference(preferenceName, id, var, defaultPreferenceType));
        }
    }

    public void write() throws IOException {
        this.mWriter.setIndent("    ");
        this.mWriter.emitPackage(this.getPackageName()).emitSingleLineComment("generated code, do not modify", new Object[0]).emitSingleLineComment("for more information see https://github.com/bleeding182/sharedpreferences-annotations", new Object[0]).emitEmptyLine().emitImports(new Class[]{Context.class, SharedPreferences.class}).emitImports(new String[]{"android.content.SharedPreferences.Editor", "android.content.SharedPreferences.OnSharedPreferenceChangeListener"}).emitEmptyLine().emitImports(new Class[]{Set.class}).emitEmptyLine().beginType(this.className, "class", Modifier.PUBLIC, null, new String[]{this.mElement.getSimpleName().toString(), "SharedPreferences"}).emitEmptyLine();
        this.mWriter.emitField("String", "PREFERENCES_NAME", Modifier.PUBLIC_FINAL_STATIC, "\"" + this.preferencesName + "\"");
        this.mWriter.emitField("SharedPreferences", PREFERENCES, Modifier.PRIVATE_FINAL).emitEmptyLine();
        this.mWriter.emitJavadoc("constructor using '%1$s' for the preferences name.\n@param %2$s the context to use", new Object[]{this.preferencesName, PAR_CONTEXT}).beginConstructor(Modifier.PUBLIC, new String[]{"Context", PAR_CONTEXT}).emitStatement("this(%1$s, %2$s)", new Object[]{PAR_CONTEXT, "PREFERENCES_NAME"}).endConstructor().emitEmptyLine();
        this.mWriter.emitJavadoc("constructor using <i>%2$s</i> for the preferences name.<br/>\n<i>It is strongly advised against using it, unless you know what you're doing.</i>\n@param %3$s the context to use\n@param %2$s the name for the preferences", new Object[]{this.preferencesName, PAR_NAME, PAR_CONTEXT}).beginConstructor(Modifier.PUBLIC, new String[]{"Context", PAR_CONTEXT, "String", PAR_NAME}).emitStatement("this.%1s = %2$s.getSharedPreferences(%3$s, %2$s.MODE_PRIVATE)", new Object[]{PREFERENCES, PAR_CONTEXT, PAR_NAME}).endConstructor();
        this.mWriter.emitJavadoc("constructor using the supplied SharedPreferences\n@param %1$s the SharedPreferences to use\n", new Object[]{"preferences"}).beginConstructor(Modifier.PUBLIC, new String[]{"SharedPreferences", "preferences"}).emitStatement("this.%1s = preferences", new Object[]{PREFERENCES, "preferences"}).endConstructor();
        this.wrapSharedPreferencesInterface(Modifier.PUBLIC, this.editorName, PREFERENCES, SharedPreferences.class.getMethods());
        for (Map.Entry<String, Preference> entry : this.preferences.entrySet()) {
            entry.getValue().writeGetter(this.mWriter);
            entry.getValue().writeSetter(this.mWriter);
        }
        this.mWriter.emitEmptyLine().beginType(this.editorName, "class", Modifier.PUBLIC_STATIC, null, new String[]{SharedPreferences.Editor.class.getCanonicalName()});
        this.mWriter.emitEmptyLine().emitField(SharedPreferences.Editor.class.getCanonicalName(), EDITOR, Modifier.PRIVATE_FINAL).emitEmptyLine();
        this.mWriter.beginConstructor(Modifier.PUBLIC, new String[]{SharedPreferences.Editor.class.getCanonicalName(), PAR_EDITOR}).emitStatement("this.%1$s = %2$s", new Object[]{EDITOR, PAR_EDITOR}).endConstructor();
        this.wrapEditorInterface(Modifier.PUBLIC, this.editorName, EDITOR, SharedPreferences.Editor.class.getMethods());
        for (Map.Entry<String, Preference> entry : this.preferences.entrySet()) {
            entry.getValue().writeChainSetter(this.mWriter, this.editorName, EDITOR);
        }
        this.mWriter.endType();
        this.mWriter.endType();
        this.mWriter.close();
    }

    private void wrapSharedPreferencesInterface(Set<javax.lang.model.element.Modifier> modifiersPublic, String editor, String wrappedElement, Method[] methods) throws IOException {
        for (Method method : methods) {
            this.mWriter.emitEmptyLine().emitAnnotation(Override.class);
            boolean isCustomWrapperNeeded = method.getReturnType().equals(SharedPreferences.Editor.class);
            String params = this.beginMethod(modifiersPublic, editor, method, isCustomWrapperNeeded);
            if (method.getReturnType().equals(Void.TYPE)) {
                this.mWriter.emitStatement("%1$s.%2$s(%3$s)", new Object[]{wrappedElement, method.getName(), params});
            } else if (isCustomWrapperNeeded) {
                this.mWriter.emitStatement("return new %1$s(%2$s.%3$s(%4$s))", new Object[]{editor, wrappedElement, method.getName(), params});
            } else {
                this.mWriter.emitStatement("return %1$s.%2$s(%3$s)", new Object[]{wrappedElement, method.getName(), params});
            }
            this.mWriter.endMethod();
        }
    }

    private void wrapEditorInterface(Set<javax.lang.model.element.Modifier> modifiersPublic, String editor, String wrappedElement, Method[] methods) throws IOException {
        for (Method method : methods) {
            this.mWriter.emitEmptyLine().emitAnnotation(Override.class);
            boolean isCustomWrapperNeeded = method.getReturnType().equals(SharedPreferences.Editor.class);
            String params = this.beginMethod(modifiersPublic, editor, method, isCustomWrapperNeeded);
            if (method.getReturnType().equals(Boolean.TYPE)) {
                this.mWriter.emitStatement("return %1$s.%2$s(%3$s)", new Object[]{wrappedElement, method.getName(), params});
            } else {
                this.mWriter.emitStatement("%1$s.%2$s(%3$s)", new Object[]{wrappedElement, method.getName(), params});
                if (!method.getReturnType().equals(Void.TYPE)) {
                    this.mWriter.emitStatement("return this", new Object[0]);
                }
            }
            this.mWriter.endMethod();
        }
    }

    private String beginMethod(Set<javax.lang.model.element.Modifier> modifiersPublic, String editor, Method method, boolean isCustomWrapperNeeded) throws IOException {
        String retType;
        String params = "";
        String string = retType = isCustomWrapperNeeded ? editor : method.getGenericReturnType().getTypeName().replace('$', '.');
        if (method.getParameterCount() > 0) {
            String[] parameters = new String[method.getParameterCount() * 2];
            for (int i = 0; i < method.getParameterCount(); ++i) {
                parameters[2 * i] = method.getGenericParameterTypes()[i].getTypeName().replace('$', '.');
                parameters[2 * i + 1] = method.getParameters()[i].getName();
                if (i > 0) {
                    params = params + ", ";
                }
                params = params + parameters[2 * i + 1];
            }
            this.mWriter.beginMethod(retType, method.getName(), modifiersPublic, parameters);
        } else {
            this.mWriter.beginMethod(retType, method.getName(), modifiersPublic, new String[0]);
        }
        return params;
    }

    public String getPackageName() {
        Element enclosingElement = this.mElement.getEnclosingElement();
        if (enclosingElement != null && enclosingElement instanceof PackageElement) {
            return ((PackageElement)enclosingElement).getQualifiedName().toString();
        }
        return "";
    }
}

