/*
 * Decompiled with CFR 0.152.
 */
package com.github.bleeding182.sharedpreferences.annotations.processor;

import com.github.bleeding182.sharedpreferences.annotations.SharedPreference;
import com.github.bleeding182.sharedpreferences.annotations.processor.PreferenceHolder;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"com.github.bleeding182.sharedpreferences.annotations.SharedPreference"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class SharedPreferencesAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(SharedPreference.class)) {
            if (element.getKind().isField()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Just interfaces annotated by @SharedPreference are supported.", element);
                continue;
            }
            if (element.getKind().isClass()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Just interfaces annotated by @SharedPreference are supported.", element);
            }
            try {
                PreferenceHolder prefHolder = new PreferenceHolder((TypeElement)element, this.processingEnv.getFiler(), this.processingEnv.getMessager());
                prefHolder.write();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ex.getMessage(), element);
            }
        }
        return true;
    }
}

