/*
 * Decompiled with CFR 0.152.
 */
package com.github.brutils.javabrutils;

import com.github.brutils.javabrutils.NumeroUtil;
import com.github.brutils.javabrutils.StringUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataUtil {
    private static final Logger LOGGER = Logger.getLogger(DataUtil.class.getName());
    private static final String FORMATO_DATA_DD_MM_YY = "dd/MM/yy";
    private static final String FORMATO_DATA_DD_MM_YYYY = "dd/MM/yyyy";
    private static final String FORMATO_DATA_YYYY_MM_DD = "yyyy/MM/dd";
    private static final String FORMATO_DATA_YYYY_MM_DD_TRACO = "yyyy-MM-dd";
    private static final String FORMATO_DATA_YYYY = "yyyy";
    private static final String FORMATO_DATA_DD_MM_YYYY_AS_HH_MM = "dd/MM/yyyy \u00e0's' HH:mm";
    private static final String DATA_VALIDA_FINAL = "31/12/9999";
    private static final String DATA_VALIDA_INICIAL = "01/01/1753";

    private DataUtil() {
    }

    public static Date stringParaDate(String data) throws ParseException {
        Date resultado = null;
        if (data == null || "".equals(data)) {
            return null;
        }
        SimpleDateFormat dataEntrada = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
        try {
            resultado = dataEntrada.parse(data);
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a data. Informe uma data v\u00e1lida no formato dd/mm/yyyy. Data enviada " + data);
            throw parseException;
        }
        return resultado;
    }

    public static Date stringParaDate(String data, String formatoDeEntrada) throws ParseException {
        Date resultado = null;
        SimpleDateFormat dataEntrada = new SimpleDateFormat(formatoDeEntrada);
        SimpleDateFormat dataSaida = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
        try {
            resultado = dataSaida.parse(dataSaida.format(dataEntrada.parse(data)));
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a data. Informe uma data e formato v\u00e1lidos. Data enviada " + data + " , formato enviado " + formatoDeEntrada);
            throw parseException;
        }
        return resultado;
    }

    public static Date stringParaDate(String data, String formatoDeEntrada, String formatoDeSaida) throws ParseException {
        Date resultado = null;
        SimpleDateFormat dataEntrada = new SimpleDateFormat(formatoDeEntrada);
        SimpleDateFormat dataSaida = new SimpleDateFormat(formatoDeSaida);
        try {
            resultado = dataSaida.parse(dataSaida.format(dataEntrada.parse(data)));
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a data. Informe uma data e formato v\u00e1lidos. Data enviada " + data + " , formato de entrada enviado " + formatoDeEntrada + ", formato de sa\u00edda enviado " + formatoDeSaida);
            throw parseException;
        }
        return resultado;
    }

    public static String dateParaString(Date data) {
        String resultado = new String();
        SimpleDateFormat dataSaida = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
        if (data != null) {
            resultado = dataSaida.format(data);
        }
        return resultado;
    }

    public static String dateParaString(Date data, String formatoDeSaida) {
        String resultado = new String();
        if (data == null) {
            return resultado;
        }
        SimpleDateFormat dataSaida = new SimpleDateFormat(StringUtil.nuloParaVazio(formatoDeSaida));
        resultado = dataSaida.format(data);
        return resultado;
    }

    public static String dataHoraParaString(Date data) {
        StringBuilder resultado = new StringBuilder("");
        SimpleDateFormat formatoSaida = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY_AS_HH_MM);
        if (data != null) {
            resultado.append(formatoSaida.format(data));
        }
        return resultado.toString();
    }

    public static String formatarData(String data, String formatoDeEntrada) throws ParseException {
        String resultado = "";
        if (data == null) {
            return "";
        }
        SimpleDateFormat dataEntrada = new SimpleDateFormat(formatoDeEntrada);
        SimpleDateFormat dataSaida = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
        try {
            Date dataValida = dataEntrada.parse(data);
            resultado = dataSaida.format(dataValida);
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao formatar a data. Informe uma data e formato v\u00e1lidos. Data enviada " + data + " , formato de entrada enviado " + formatoDeEntrada);
            throw parseException;
        }
        return resultado;
    }

    public static String formatarData(String data) throws ParseException {
        String resultado = new String();
        SimpleDateFormat dataEntrada = new SimpleDateFormat(FORMATO_DATA_YYYY_MM_DD_TRACO);
        SimpleDateFormat dataSaida = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
        try {
            Date dataValida = dataEntrada.parse(data);
            resultado = dataSaida.format(dataValida);
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao formatar a data. Informe uma data v\u00e1lida. Data enviada " + data);
            throw parseException;
        }
        return resultado;
    }

    public static String formatarData(String data, String formatoDeEntrada, String formatoDeSaida) throws ParseException {
        String resultado = "";
        SimpleDateFormat dataEntrada = new SimpleDateFormat(formatoDeEntrada);
        SimpleDateFormat dataSaida = new SimpleDateFormat(formatoDeSaida);
        try {
            Date dataValida = dataEntrada.parse(data);
            resultado = dataSaida.format(dataValida);
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao formatar a data. Informe uma data v\u00e1lida. Data enviada " + data + ", formato de entrada " + formatoDeEntrada + ", formato de sa\u00edda " + formatoDeSaida);
            throw parseException;
        }
        return resultado;
    }

    public static String dataAtualFormatada(String formatoDeSaida) {
        String resultado = "";
        Date dataHoje = new Date();
        SimpleDateFormat dataSaida = new SimpleDateFormat(StringUtil.nuloParaVazio(formatoDeSaida));
        resultado = dataSaida.format(dataHoje);
        return resultado;
    }

    public static int ultimoDiaDoMes(Date data) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        int resultado = ((Calendar)calendar).getActualMaximum(5);
        calendar = null;
        return resultado;
    }

    public static int ultimoDiaDoMes(Integer ano, Integer mes) {
        int mesReal = mes - 1;
        GregorianCalendar calendar = new GregorianCalendar(ano, mesReal, 1);
        int resultado = ((Calendar)calendar).getActualMaximum(5);
        return resultado;
    }

    public static boolean isDataValida(String data) throws ParseException {
        try {
            DateFormat df = DateFormat.getDateInstance(3);
            df.setLenient(false);
            Date dt2 = df.parse(data);
            return !dt2.after(DataUtil.stringParaDate(DATA_VALIDA_FINAL)) && !dt2.before(DataUtil.stringParaDate(DATA_VALIDA_INICIAL));
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao verificar se \u00e9 uma data v\u00e1lida. ParseException. Data enviada " + data);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.log(Level.SEVERE, "Erro ao verificar se \u00e9 uma data v\u00e1lida. IllegalArgumentException. Data enviada " + data);
        }
        return false;
    }

    public static boolean isDataValida(Date data) {
        try {
            return !data.after(DataUtil.stringParaDate(DATA_VALIDA_FINAL)) && !data.before(DataUtil.stringParaDate(DATA_VALIDA_INICIAL));
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao verificar se \u00e9 uma data v\u00e1lida. ParseException. Data enviada " + data);
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOGGER.log(Level.SEVERE, "Erro ao verificar se \u00e9 uma data v\u00e1lida. IllegalArgumentException. Data enviada " + data);
            return false;
        }
    }

    public boolean isDataFormatoValido(String data) {
        boolean resultado = false;
        SimpleDateFormat dataEntrada = new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
        try {
            dataEntrada.parse(data);
            resultado = true;
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "Erro ao verificar se \u00e9 uma data no formato v\u00e1lido. ParseException. Data enviada " + data);
            resultado = false;
        }
        return resultado;
    }

    public static Date adicionarDias(Date data, int quantidadeDeDias) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        ((Calendar)calendar).add(5, quantidadeDeDias);
        return calendar.getTime();
    }

    public static Date removerDias(Date data, int quantidadeDeDias) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        calendar.add(5, quantidadeDeDias * -1);
        return calendar.getTime();
    }

    public static Date adicionarMeses(Date data, int quantidadeDeMeses) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        ((Calendar)calendar).add(2, quantidadeDeMeses);
        return calendar.getTime();
    }

    public static Date removerMeses(Date data, int quantidadeDeMeses) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        ((Calendar)calendar).add(2, quantidadeDeMeses * -1);
        return calendar.getTime();
    }

    public static Date adicionarAnos(Date data, int quantidadeDeAnos) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        ((Calendar)calendar).add(1, quantidadeDeAnos);
        return calendar.getTime();
    }

    public static Date removerAnos(Date data, int quantidadeDeAnos) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(data);
        ((Calendar)calendar).add(1, quantidadeDeAnos * -1);
        return calendar.getTime();
    }

    public static Date data(int dia, int mes, int ano) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(ano, mes, dia);
        return calendar.getTime();
    }

    public static String mesComDoisDigitos(Integer mes) {
        return StringUtil.adicionarChar('0', 2, String.valueOf(NumeroUtil.nuloParaZero(mes)), true);
    }

    public static List<String> horas() {
        ArrayList<String> resultado = new ArrayList<String>();
        int ultimaHora = 23;
        int intervaloMinutos = 30;
        Integer hora = 0;
        while (hora <= 23) {
            Integer minuto = 0;
            while (minuto <= 30) {
                resultado.add(StringUtil.adicionarZeroEsquerda(hora.toString(), 2) + ":" + StringUtil.adicionarZeroEsquerda(minuto.toString(), 2));
                minuto = minuto + 30;
            }
            Integer n = hora;
            Integer n2 = hora = Integer.valueOf(hora + 1);
        }
        return resultado;
    }

    public static List<String> anos(int quantidadeRetroativa, int quantidadePosterior) {
        int indice;
        ArrayList<String> resultado = new ArrayList<String>();
        int anoCorrente = Integer.parseInt(DataUtil.dateParaString(new Date(), FORMATO_DATA_YYYY));
        for (indice = quantidadeRetroativa; indice >= 1; --indice) {
            resultado.add(Integer.valueOf(anoCorrente - indice).toString());
        }
        resultado.add(String.valueOf(anoCorrente));
        for (indice = 1; indice <= quantidadePosterior; ++indice) {
            resultado.add(Integer.valueOf(anoCorrente + indice).toString());
        }
        return resultado;
    }

    public static List<Integer> anos(Integer anoInicial, int quantidadeRetroativa, int quantidadePosterior) {
        int i;
        Integer anoInicialTemporario = anoInicial;
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        if (anoInicialTemporario == null) {
            anoInicialTemporario = Integer.parseInt(DataUtil.dateParaString(new Date(), FORMATO_DATA_YYYY));
        }
        for (i = quantidadeRetroativa; i >= 1; --i) {
            resultado.add(anoInicialTemporario - i);
        }
        resultado.add(anoInicialTemporario);
        for (i = 1; i <= quantidadePosterior; ++i) {
            resultado.add(anoInicialTemporario + i);
        }
        return resultado;
    }

    public static List<String> meses() {
        ArrayList<String> resultado = new ArrayList<String>();
        boolean mesInicial = true;
        int mesFinal = 12;
        for (int i = 1; i <= 12; ++i) {
            resultado.add(DataUtil.mesPorExtenso(i));
        }
        return resultado;
    }

    public static List<String> dias() {
        ArrayList<String> resultado = new ArrayList<String>();
        boolean diaInicial = true;
        int diaFinal = 31;
        Integer i = 1;
        while (i <= 31) {
            resultado.add(StringUtil.adicionarChar('0', 2, i.toString(), true));
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return resultado;
    }

    public static String mesPorExtenso(Integer mes) {
        String resultado = new String();
        boolean numeroMesJaneiro = true;
        int numeroMesFevereiro = 2;
        int numeroMesMarco = 3;
        int numeroMesAbril = 4;
        int numeroMesMaio = 5;
        int numeroMesJunho = 6;
        int numeroMesJulho = 7;
        int numeroMesAgosto = 8;
        int numeroMesSetembro = 9;
        int numeroMesOutubro = 10;
        int numeroMesNovembro = 11;
        int numeroMesDezembro = 12;
        switch (mes) {
            case 1: {
                resultado = "Janeiro";
                break;
            }
            case 2: {
                resultado = "Fevereiro";
                break;
            }
            case 3: {
                resultado = "Mar\u00e7o";
                break;
            }
            case 4: {
                resultado = "Abril";
                break;
            }
            case 5: {
                resultado = "Maio";
                break;
            }
            case 6: {
                resultado = "Junho";
                break;
            }
            case 7: {
                resultado = "Julho";
                break;
            }
            case 8: {
                resultado = "Agosto";
                break;
            }
            case 9: {
                resultado = "Setembro";
                break;
            }
            case 10: {
                resultado = "Outubro";
                break;
            }
            case 11: {
                resultado = "Novembro";
                break;
            }
            case 12: {
                resultado = "Dezembro";
                break;
            }
            default: {
                resultado = "Dezembro";
            }
        }
        return resultado;
    }

    public static String numeroMes(String mesDescricao) {
        StringBuilder retorno = new StringBuilder();
        if ("Janeiro".equalsIgnoreCase(mesDescricao)) {
            retorno.append("01");
        } else if ("Fevereiro".equalsIgnoreCase(mesDescricao)) {
            retorno.append("02");
        } else if ("Mar\u00e7o".equalsIgnoreCase(mesDescricao)) {
            retorno.append("03");
        } else if ("Abril".equalsIgnoreCase(mesDescricao)) {
            retorno.append("04");
        } else if ("Maio".equalsIgnoreCase(mesDescricao)) {
            retorno.append("05");
        } else if ("Junho".equalsIgnoreCase(mesDescricao)) {
            retorno.append("06");
        } else if ("Julho".equalsIgnoreCase(mesDescricao)) {
            retorno.append("07");
        } else if ("Agosto".equalsIgnoreCase(mesDescricao)) {
            retorno.append("08");
        } else if ("Setembro".equalsIgnoreCase(mesDescricao)) {
            retorno.append("09");
        } else if ("Outubro".equalsIgnoreCase(mesDescricao)) {
            retorno.append("10");
        } else if ("Novembro".equalsIgnoreCase(mesDescricao)) {
            retorno.append("11");
        } else if ("Dezembro".equalsIgnoreCase(mesDescricao)) {
            retorno.append("12");
        }
        return retorno.toString();
    }

    public static Integer diasEntreDatas(Date dataInicial, Date dataFinal) {
        Long diferencaDias = new Long(0L);
        int horas = 24;
        int minutos = 60;
        int segundos = 60;
        int milisegundos = 1000;
        if (dataInicial != null && dataFinal != null) {
            long diferencaMilisegundos = dataFinal.getTime() - dataInicial.getTime();
            diferencaDias = diferencaMilisegundos / 86400000L;
        }
        if (diferencaDias < 0L) {
            diferencaDias = new Long(0L);
        }
        return diferencaDias.intValue();
    }

    public static Long diferencaEntreDatas(Date dataInicial, Date dataFinal) {
        Long diferenca = new Long(0L);
        if (dataInicial != null && dataFinal != null) {
            diferenca = dataFinal.getTime() - dataInicial.getTime();
        }
        return diferenca;
    }

    public static int idade(Date data, Date dataDeNascimento, String diaOuMes) {
        int idade = 0;
        if (dataDeNascimento != null) {
            idade = data.getYear() - dataDeNascimento.getYear();
            if (data.getMonth() < dataDeNascimento.getMonth()) {
                --idade;
            }
        }
        return idade;
    }

    public static int idade(Date dataAtual, Date dataDeNascimento) {
        int idade = 0;
        if (dataDeNascimento != null && dataAtual != null) {
            idade = dataAtual.getYear() - dataDeNascimento.getYear();
            if (dataAtual.getMonth() < dataDeNascimento.getMonth()) {
                --idade;
            }
        }
        return idade;
    }

    public static Date dataAtual() {
        Date resultado = null;
        try {
            resultado = DataUtil.stringParaDate(Calendar.getInstance().get(5) + "/" + (Calendar.getInstance().get(2) + 1) + "/" + Calendar.getInstance().get(1));
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao obter a data atual. " + parseException);
        }
        return resultado;
    }

    public static String converterDataParaAnoMesDia(String data) throws ParseException {
        String resultado = "";
        SimpleDateFormat dataEntrada = null;
        SimpleDateFormat dataSaida = null;
        int tamanhoData = 8;
        try {
            if (!StringUtil.isVazio(data)) {
                dataEntrada = data.length() == 8 ? new SimpleDateFormat(FORMATO_DATA_DD_MM_YY) : new SimpleDateFormat(FORMATO_DATA_DD_MM_YYYY);
                dataSaida = new SimpleDateFormat(FORMATO_DATA_YYYY_MM_DD);
                Date dataValida = dataEntrada.parse(data);
                resultado = dataSaida.format(dataValida);
            }
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a data do formato dd/MM/yyyy ou dd/MM/yy para o formato yyyy/MM/dd. Data informada " + data);
            throw parseException;
        }
        return resultado;
    }
}

