/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.decoder;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpe.caf.api.CodecException;
import com.hpe.caf.api.Decoder;
import com.hpe.caf.api.FileExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

@FileExtensions(value={"js"})
public class JavascriptDecoder
implements Decoder {
    private final ScriptEngineManager scriptManager = new ScriptEngineManager();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public <T> T deserialise(InputStream stream, Class<T> clazz) throws CodecException {
        try {
            return this.decode(stream, clazz);
        }
        catch (IOException | NoSuchMethodException | ScriptException ex) {
            throw new CodecException("Failed to decode JavaScript", (Throwable)ex);
        }
    }

    private <T> T decode(InputStream stream, Class<T> clazz) throws IOException, ScriptException, NoSuchMethodException {
        ScriptEngine jsEngine = this.scriptManager.getEngineByName("nashorn");
        Object fnObj = jsEngine.eval("getenv = com.hpe.caf.decoder.PropertyRetriever.getenv;({    toJson: JSON.stringify});");
        Object configObj = JavascriptDecoder.evaluateScript(jsEngine, stream);
        String configJson = JavascriptDecoder.invokeStringMethod(jsEngine, fnObj, "toJson", configObj);
        return (T)this.objectMapper.readValue(configJson, clazz);
    }

    private static Object evaluateScript(ScriptEngine scriptEngine, InputStream stream) throws IOException, ScriptException {
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            Object object = scriptEngine.eval(reader);
            return object;
        }
    }

    private static String invokeStringMethod(ScriptEngine jsEngine, Object thiz, String name, Object ... args) throws NoSuchMethodException, ScriptException {
        return (String)((Invocable)((Object)jsEngine)).invokeMethod(thiz, name, args);
    }
}

