/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql;

import com.github.chengyuxing.common.DataRow;
import com.github.chengyuxing.common.utils.CollectionUtil;
import com.github.chengyuxing.common.utils.StringUtil;
import com.github.chengyuxing.sql.Baki;
import com.github.chengyuxing.sql.PagedResource;
import com.github.chengyuxing.sql.XQLFileManager;
import com.github.chengyuxing.sql.datasource.DataSourceUtil;
import com.github.chengyuxing.sql.exceptions.ConnectionStatusException;
import com.github.chengyuxing.sql.exceptions.IllegalSqlException;
import com.github.chengyuxing.sql.exceptions.UncheckedSqlException;
import com.github.chengyuxing.sql.page.IPageable;
import com.github.chengyuxing.sql.page.PageHelper;
import com.github.chengyuxing.sql.page.PageHelperProvider;
import com.github.chengyuxing.sql.page.impl.Db2PageHelper;
import com.github.chengyuxing.sql.page.impl.MysqlPageHelper;
import com.github.chengyuxing.sql.page.impl.OraclePageHelper;
import com.github.chengyuxing.sql.page.impl.PGPageHelper;
import com.github.chengyuxing.sql.support.JdbcSupport;
import com.github.chengyuxing.sql.support.SqlInterceptor;
import com.github.chengyuxing.sql.support.executor.DeleteExecutor;
import com.github.chengyuxing.sql.support.executor.Executor;
import com.github.chengyuxing.sql.support.executor.InsertExecutor;
import com.github.chengyuxing.sql.support.executor.QueryExecutor;
import com.github.chengyuxing.sql.support.executor.UpdateExecutor;
import com.github.chengyuxing.sql.types.Param;
import com.github.chengyuxing.sql.utils.JdbcUtil;
import com.github.chengyuxing.sql.utils.SqlTranslator;
import com.github.chengyuxing.sql.utils.SqlUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BakiDao
extends JdbcSupport
implements Baki {
    private static final Logger log = LoggerFactory.getLogger(BakiDao.class);
    private final DataSource dataSource;
    private DatabaseMetaData currentMetaData;
    private SqlTranslator sqlTranslator = new SqlTranslator(':');
    private PageHelperProvider globalPageHelperProvider;
    private SqlInterceptor sqlInterceptor;
    private XQLFileManager xqlFileManager;
    private char namedParamPrefix = (char)58;
    private boolean strictDynamicSqlArg = true;
    private boolean checkParameterType = true;
    private boolean debugFullSql = false;
    private boolean highlightSql = false;

    public BakiDao(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static BakiDao of(DataSource dataSource) {
        return new BakiDao(dataSource);
    }

    public void setXqlFileManager(XQLFileManager xqlFileManager) {
        this.xqlFileManager = xqlFileManager;
        this.xqlFileManager.setNamedParamPrefix(Character.valueOf(this.namedParamPrefix));
        this.xqlFileManager.setHighlightSql(this.highlightSql);
        if (!xqlFileManager.isInitialized()) {
            xqlFileManager.init();
        }
    }

    public XQLFileManager getXqlFileManager() {
        return this.xqlFileManager;
    }

    public char getNamedParamPrefix() {
        return this.namedParamPrefix;
    }

    public void setNamedParamPrefix(char namedParamPrefix) {
        this.namedParamPrefix = namedParamPrefix;
        this.sqlTranslator = new SqlTranslator(namedParamPrefix);
        if (this.xqlFileManager != null) {
            this.xqlFileManager.setNamedParamPrefix(Character.valueOf(namedParamPrefix));
        }
    }

    protected int insert(String tableName, Collection<? extends Map<String, ?>> data, boolean uncheck) {
        if (data.isEmpty()) {
            return 0;
        }
        ArrayList<String> tableFields = uncheck ? new ArrayList() : this.getTableFields(tableName);
        String sql = this.sqlTranslator.generateNamedParamInsert(tableName, data.iterator().next(), tableFields);
        return this.executeNonQuery(sql, data);
    }

    protected int fastInsert(String tableName, Collection<? extends Map<String, ?>> data, boolean uncheck) {
        if (data.size() > 0) {
            ArrayList<String> tableFields;
            Iterator<Map<String, ?>> iterator = data.iterator();
            ArrayList<String> sqls = new ArrayList<String>(data.size());
            List<Object> list = tableFields = uncheck ? new ArrayList() : this.getTableFields(tableName);
            while (iterator.hasNext()) {
                String insertSql = this.sqlTranslator.generateInsert(tableName, iterator.next(), tableFields);
                sqls.add(insertSql);
            }
            log.debug("preview sql: {}\nmore...", (Object)SqlUtil.buildPrintSql((String)sqls.get(0), this.highlightSql));
            int count = super.executeBatch(sqls).length;
            log.debug("{} rows inserted!", (Object)count);
            return count;
        }
        return 0;
    }

    protected int update(String tableName, Collection<? extends Map<String, ?>> data, List<String> sets, boolean uncheck, String where) {
        if (data.isEmpty()) {
            return 0;
        }
        String whereSql = this.getSql(where, Collections.emptyMap());
        Map<String, ?> updateSets = this.getUpdateSets(whereSql, data.iterator().next(), sets);
        ArrayList<String> tableFields = uncheck ? new ArrayList() : this.getTableFields(tableName);
        String update = this.sqlTranslator.generateNamedParamUpdate(tableName, updateSets, tableFields);
        String sql = update + "\nwhere " + whereSql;
        return this.executeNonQuery(sql, data);
    }

    protected int fastUpdate(String tableName, Collection<? extends Map<String, ?>> data, List<String> sets, boolean uncheck, String where) {
        if (data.isEmpty()) {
            return 0;
        }
        String whereSql = this.getSql(where, Collections.emptyMap());
        ArrayList<String> sqls = new ArrayList<String>(data.size());
        Map<String, ?> updateSets = this.getUpdateSets(whereSql, data.iterator().next(), sets);
        ArrayList<String> tableFields = uncheck ? new ArrayList() : this.getTableFields(tableName);
        String update = this.sqlTranslator.generateNamedParamUpdate(tableName, updateSets, tableFields);
        String fullUpdatePrepared = update + "\nwhere " + whereSql;
        for (Map<String, ?> item : data) {
            String updateNonPrepared = (String)this.sqlTranslator.generateSql(fullUpdatePrepared, item, false).getItem1();
            sqls.add(updateNonPrepared);
        }
        log.debug("preview sql: {}\nmore...", (Object)SqlUtil.buildPrintSql((String)sqls.get(0), this.highlightSql));
        int count = Arrays.stream(super.executeBatch(sqls)).sum();
        log.debug("{} rows updated!", (Object)count);
        return count;
    }

    protected Map<String, ?> getUpdateSets(String where, Map<String, ?> args, List<String> setFields) {
        if (args == null || args.isEmpty()) {
            return new HashMap();
        }
        HashMap sets = new HashMap();
        if (setFields != null && !setFields.isEmpty()) {
            for (String key : setFields) {
                if (!args.containsKey(key)) continue;
                sets.put(key, args.get(key));
            }
            return sets;
        }
        List whereFields = (List)this.sqlTranslator.getPreparedSql(where, args).getItem2();
        for (Map.Entry<String, ?> e : args.entrySet()) {
            if (CollectionUtil.containsIgnoreCase((Collection)whereFields, (String)e.getKey())) continue;
            sets.put(e.getKey(), e.getValue());
        }
        return sets;
    }

    @Override
    public Executor of(String sql, String ... more) {
        return new Executor(sql, more){

            private List<String> allSql() {
                ArrayList<String> all = new ArrayList<String>();
                all.add(this.sql);
                if (this.more.length > 0) {
                    all.addAll(Arrays.asList(this.more));
                }
                return all;
            }

            @Override
            public int[] executeBatch() {
                return BakiDao.super.executeBatch(this.allSql());
            }

            @Override
            public int executeBatch(Collection<Map<String, ?>> argsForBatch) {
                return BakiDao.this.executeNonQuery(this.sql, argsForBatch);
            }

            @Override
            public DataRow execute() {
                return BakiDao.super.execute(this.sql, this.args);
            }
        };
    }

    @Override
    public QueryExecutor query(String sql) {
        return new QueryExecutor(sql){

            @Override
            public Stream<DataRow> stream() {
                return BakiDao.this.executeQueryStream(this.sql, this.args);
            }

            @Override
            public List<Map<String, Object>> maps() {
                try (Stream<DataRow> s = this.stream();){
                    List<Map<String, Object>> list = s.collect(Collectors.toList());
                    return list;
                }
            }

            @Override
            public List<DataRow> rows() {
                try (Stream<DataRow> s = this.stream();){
                    List<DataRow> list = s.collect(Collectors.toList());
                    return list;
                }
            }

            @Override
            public <T> List<T> entities(Class<T> entityClass) {
                try (Stream<DataRow> s = this.stream();){
                    List list = s.map(d -> d.toEntity(entityClass, new Object[0])).collect(Collectors.toList());
                    return list;
                }
            }

            @Override
            public IPageable pageable(int page, int size) {
                SimplePageable iPageable = new SimplePageable(this.sql, page, size);
                return iPageable.args(this.args);
            }

            @Override
            public DataRow findFirstRow() {
                return this.findFirst().orElseGet(DataRow::new);
            }

            @Override
            public <T> T findFirstEntity(Class<T> entityClass) {
                return this.findFirst().map(d -> d.toEntity(entityClass, new Object[0])).orElse(null);
            }

            @Override
            public Optional<DataRow> findFirst() {
                PageHelper pageHelper = BakiDao.this.defaultPager();
                pageHelper.init(1, 1, 1);
                Map<String, Integer> pagedArgs = pageHelper.pagedArgs();
                if (pagedArgs != null) {
                    this.args.putAll(pagedArgs);
                }
                String query = BakiDao.this.getSql(this.sql, this.args);
                try (Stream<DataRow> s = BakiDao.this.executeQueryStream(pageHelper.pagedSql(query), this.args);){
                    Optional<DataRow> optional = s.peek(d -> d.remove((Object)"rn_4_rabbit")).findFirst();
                    return optional;
                }
            }

            @Override
            public boolean exists() {
                return this.findFirst().isPresent();
            }
        };
    }

    @Override
    public UpdateExecutor update(String tableName, String where) {
        return new UpdateExecutor(tableName, where){

            @Override
            public int save(Map<String, ?> data) {
                return this.save(Collections.singletonList(data));
            }

            @Override
            public int save(Collection<? extends Map<String, ?>> data) {
                if (this.fast) {
                    return BakiDao.this.fastUpdate(this.tableName, data, this.sets, !this.safe, this.where);
                }
                return BakiDao.this.update(this.tableName, data, this.sets, !this.safe, this.where);
            }
        };
    }

    @Override
    public InsertExecutor insert(String tableName) {
        return new InsertExecutor(tableName){

            @Override
            public int save(Map<String, ?> data) {
                return this.save(Collections.singletonList(data));
            }

            @Override
            public int save(Collection<? extends Map<String, ?>> data) {
                if (this.fast) {
                    return BakiDao.this.fastInsert(this.tableName, data, !this.safe);
                }
                return BakiDao.this.insert(this.tableName, data, !this.safe);
            }
        };
    }

    @Override
    public DeleteExecutor delete(String tableName) {
        return new DeleteExecutor(tableName){

            @Override
            public int execute(String where) {
                String whereSql = BakiDao.this.getSql(where, Collections.emptyMap());
                String w = StringUtil.startsWithIgnoreCase((String)whereSql.trim(), (String)"where") ? whereSql : "\nwhere " + whereSql;
                return BakiDao.this.executeNonQuery("delete from " + this.tableName + w, Collections.singletonList(this.args));
            }
        };
    }

    public void setGlobalPageHelperProvider(PageHelperProvider globalPageHelperProvider) {
        this.globalPageHelperProvider = globalPageHelperProvider;
    }

    public void setSqlInterceptor(SqlInterceptor sqlInterceptor) {
        this.sqlInterceptor = sqlInterceptor;
    }

    @Override
    public DataRow call(String name, Map<String, Param> args) {
        return this.executeCallStatement(name, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T using(Function<Connection, T> func) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            T t = func.apply(connection);
            return t;
        }
        finally {
            this.releaseConnection(connection, this.getDataSource());
        }
    }

    @Override
    public DatabaseMetaData metaData() {
        if (this.currentMetaData != null) {
            return this.currentMetaData;
        }
        return this.using(c -> {
            try {
                this.currentMetaData = c.getMetaData();
                return this.currentMetaData;
            }
            catch (SQLException e) {
                throw new UncheckedSqlException("get metadata error: ", e);
            }
        });
    }

    protected PageHelper defaultPager() {
        try {
            PageHelper pageHelper;
            String dbName = this.metaData().getDatabaseProductName().toLowerCase();
            if (this.globalPageHelperProvider != null && (pageHelper = this.globalPageHelperProvider.customPageHelper(this.metaData(), dbName, this.namedParamPrefix)) != null) {
                return pageHelper;
            }
            switch (dbName) {
                case "oracle": {
                    return new OraclePageHelper();
                }
                case "postgresql": 
                case "sqlite": {
                    return new PGPageHelper();
                }
                case "mysql": 
                case "mariadb": {
                    return new MysqlPageHelper();
                }
                case "z/os": 
                case "sqlds": 
                case "iseries": 
                case "db2 for unix/windows": 
                case "cloudscape": 
                case "informix": {
                    return new Db2PageHelper();
                }
            }
            throw new UnsupportedOperationException("pager of \"" + dbName + "\" default not implement currently, see method 'setPageHelperProvider'.");
        }
        catch (SQLException e) {
            throw new UncheckedSqlException("get database metadata error: ", e);
        }
    }

    protected List<String> getTableFields(String tableName) {
        String sql = this.getSql("select * from " + tableName + " where 1 = 2", Collections.emptyMap());
        return this.execute(sql, (PreparedStatement sc) -> {
            ResultSet fieldsResultSet = sc.executeQuery();
            List<String> fields = Arrays.asList(JdbcUtil.createNames(fieldsResultSet, ""));
            JdbcUtil.closeResultSet(fieldsResultSet);
            log.debug("all fields of table: {} {}", (Object)tableName, fields);
            return fields;
        });
    }

    @Override
    protected String getSql(String sql, Map<String, ?> args) {
        String trimEndedSql = SqlUtil.trimEnd(sql);
        if (sql.startsWith("&")) {
            if (this.xqlFileManager != null) {
                trimEndedSql = this.xqlFileManager.get(sql.substring(1), args, this.strictDynamicSqlArg);
            } else {
                throw new NullPointerException("can not find property 'xqlFileManager' or XQLFileManager object init failed!");
            }
        }
        if (trimEndedSql.contains("${")) {
            trimEndedSql = this.sqlTranslator.formatSql(trimEndedSql, args);
        }
        if (trimEndedSql.contains("${") && this.xqlFileManager != null) {
            Map<String, String> constants = this.xqlFileManager.getConstants();
            for (String constantName : constants.keySet()) {
                trimEndedSql = StringUtil.format((String)trimEndedSql, (String)constantName, (Object)constants.get(constantName));
            }
        }
        if (this.sqlInterceptor != null) {
            boolean request;
            String error = "reject to execute invalid sql.\nSQL: " + trimEndedSql + "\nArgs: " + args;
            try {
                request = this.sqlInterceptor.prevHandle(trimEndedSql, args, this.metaData());
            }
            catch (Throwable e) {
                throw new IllegalSqlException(error, e);
            }
            if (!request) {
                throw new IllegalSqlException(error);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("SQL: {}", (Object)SqlUtil.buildPrintSql(trimEndedSql, this.highlightSql));
            log.debug("Args: {}", args);
            if (this.debugFullSql) {
                String fullSql = (String)this.sqlTranslator().generateSql(trimEndedSql, args, false).getItem1();
                log.debug("Full SQL: {}", (Object)SqlUtil.buildPrintSql(fullSql, this.highlightSql));
            }
        }
        return trimEndedSql;
    }

    @Override
    protected SqlTranslator sqlTranslator() {
        return this.sqlTranslator;
    }

    @Override
    protected boolean checkParameterType() {
        return this.checkParameterType;
    }

    @Override
    protected DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    protected Connection getConnection() {
        try {
            return DataSourceUtil.getConnection(this.dataSource);
        }
        catch (SQLException e) {
            throw new ConnectionStatusException("fetch connection failed:", e);
        }
    }

    @Override
    protected void releaseConnection(Connection connection, DataSource dataSource) {
        DataSourceUtil.releaseConnection(connection, dataSource);
    }

    public void setStrictDynamicSqlArg(boolean strictDynamicSqlArg) {
        this.strictDynamicSqlArg = strictDynamicSqlArg;
    }

    public boolean isStrictDynamicSqlArg() {
        return this.strictDynamicSqlArg;
    }

    public boolean isCheckParameterType() {
        return this.checkParameterType;
    }

    public void setCheckParameterType(boolean checkParameterType) {
        this.checkParameterType = checkParameterType;
    }

    public void setDebugFullSql(boolean debugFullSql) {
        this.debugFullSql = debugFullSql;
    }

    public boolean isHighlightSql() {
        return this.highlightSql;
    }

    public void setHighlightSql(boolean highlightSql) {
        this.highlightSql = highlightSql;
        if (this.xqlFileManager != null) {
            this.xqlFileManager.setHighlightSql(highlightSql);
        }
    }

    class SimplePageable
    extends IPageable {
        public SimplePageable(String recordQuery, int page, int size) {
            super(recordQuery, page, size);
        }

        @Override
        public <T> PagedResource<T> collect(Function<DataRow, T> mapper) {
            String dbName;
            String query = BakiDao.this.getSql(this.recordQuery, this.args);
            if (this.count == null) {
                DataRow cnRow;
                Object cn;
                String cq = this.countQuery;
                if (cq == null) {
                    cq = BakiDao.this.sqlTranslator.generateCountQuery(query);
                }
                this.count = (cn = (cnRow = (DataRow)BakiDao.this.execute(cq, this.args).getFirstAs()).getFirst()) instanceof Integer ? (Integer)cn : Integer.valueOf(Integer.parseInt(cn.toString()));
            }
            try {
                dbName = BakiDao.this.metaData().getDatabaseProductName().toLowerCase();
            }
            catch (SQLException e) {
                throw new UncheckedSqlException("get database metadata error: ", e);
            }
            PageHelper pageHelper = null;
            if (this.pageHelperProvider != null) {
                pageHelper = this.pageHelperProvider.customPageHelper(BakiDao.this.metaData(), dbName, BakiDao.this.namedParamPrefix);
            }
            if (pageHelper == null) {
                pageHelper = BakiDao.this.defaultPager();
            }
            pageHelper.init(this.page, this.size, this.count);
            Map pagedArgs = pageHelper.pagedArgs();
            if (pagedArgs == null) {
                pagedArgs = new HashMap<String, Integer>();
            }
            this.args.putAll(this.rewriteArgsFunc == null ? pagedArgs : (Map)this.rewriteArgsFunc.apply(pagedArgs));
            String executeQuery = this.disablePageSql ? query : pageHelper.pagedSql(query);
            try (Stream<DataRow> s = BakiDao.this.executeQueryStream(executeQuery, this.args);){
                List list = s.peek(d -> d.remove((Object)"rn_4_rabbit")).map(mapper).collect(Collectors.toList());
                PagedResource pagedResource = PagedResource.of(pageHelper, list);
                return pagedResource;
            }
        }
    }
}

