/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql;

import com.github.chengyuxing.sql.page.PageHelper;
import java.util.Collections;
import java.util.List;

public final class PagedResource<T> {
    private PageHelper pager;
    private List<T> data;

    public PagedResource(PageHelper pager, List<T> data) {
        this.pager = pager;
        this.data = data;
    }

    public static <T> PagedResource<T> of(PageHelper pager, List<T> data) {
        return new PagedResource<T>(pager, data);
    }

    public static <T> PagedResource<T> empty() {
        return new PagedResource(null, Collections.emptyList());
    }

    void setData(List<T> data) {
        this.data = data;
    }

    void setPager(PageHelper pager) {
        this.pager = pager;
    }

    public List<T> getData() {
        return this.data;
    }

    public PageHelper getPager() {
        return this.pager;
    }

    public String toString() {
        return "Pageable{pager=" + this.pager + ", data=" + this.data + '}';
    }
}

