/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql;

import com.github.chengyuxing.common.WatchDog;
import com.github.chengyuxing.common.console.Color;
import com.github.chengyuxing.common.console.Printer;
import com.github.chengyuxing.common.io.FileResource;
import com.github.chengyuxing.common.script.IExpression;
import com.github.chengyuxing.common.script.IPipe;
import com.github.chengyuxing.common.script.SimpleScriptParser;
import com.github.chengyuxing.common.script.exception.ScriptSyntaxException;
import com.github.chengyuxing.common.script.impl.FastExpression;
import com.github.chengyuxing.common.utils.ReflectUtil;
import com.github.chengyuxing.common.utils.StringUtil;
import com.github.chengyuxing.sql.XQLFileManagerConfig;
import com.github.chengyuxing.sql.exceptions.DuplicateException;
import com.github.chengyuxing.sql.utils.SqlUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XQLFileManager
extends XQLFileManagerConfig
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(XQLFileManager.class);
    public static final Pattern NAME_PATTERN = Pattern.compile("/\\*\\s*\\[\\s*(?<name>\\S+)\\s*]\\s*\\*/");
    public static final Pattern PART_PATTERN = Pattern.compile("/\\*\\s*\\{\\s*(?<part>\\S+)\\s*}\\s*\\*/");
    public static final String PROPERTIES = "xql-file-manager.properties";
    public static final String YML = "xql-file-manager.yml";
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<String, Resource> resources = new HashMap<String, Resource>();
    private final DynamicSqlParser dynamicSqlParser = new DynamicSqlParser();
    private WatchDog watchDog = null;
    private volatile boolean initialized;

    public XQLFileManager() {
        FileResource resource = new FileResource(YML);
        if (resource.exists()) {
            this.loadYaml(resource);
            return;
        }
        resource = new FileResource(PROPERTIES);
        if (resource.exists()) {
            this.loadProperties(resource);
        }
    }

    public XQLFileManager(String configLocation) {
        super(configLocation);
    }

    public XQLFileManager(XQLFileManagerConfig config) {
        config.copyStateTo(this);
    }

    public XQLFileManager(Map<String, String> files) {
        if (files == null) {
            return;
        }
        this.files = new HashMap<String, String>(files);
    }

    public void add(String alias, String fileName) {
        this.files.put(alias, fileName);
    }

    public String add(String fileName) {
        String alias = StringUtil.getFileName((String)fileName, (boolean)false);
        this.add(alias, fileName);
        return alias;
    }

    public void remove(String alias) {
        this.lock.lock();
        try {
            this.resources.remove(alias);
            this.files.remove(alias);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeByFilename(String filename) {
        this.lock.lock();
        try {
            this.files.entrySet().removeIf(next -> ((String)next.getValue()).equals(filename));
            this.resources.entrySet().removeIf(e -> ((Resource)e.getValue()).getFilename().equals(filename));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearFiles() {
        this.files.clear();
    }

    protected void putResource(String alias, String filename, FileResource fileResource) throws IOException, URISyntaxException {
        this.resources.put(alias, this.parse(alias, filename, fileResource));
    }

    public Resource parse(String alias, String filename, FileResource fileResource) throws IOException, URISyntaxException {
        Resource resource = new Resource(alias, filename);
        LinkedHashMap<String, String> entry = new LinkedHashMap<String, String>();
        try (BufferedReader reader = fileResource.getBufferedReader(Charset.forName(this.charset));){
            String line;
            String blockName = "";
            ArrayList<String> sqlBodyBuffer = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                String trimLine = line.trim();
                if (trimLine.isEmpty()) continue;
                Matcher m_name = NAME_PATTERN.matcher(trimLine);
                if (m_name.matches()) {
                    blockName = m_name.group("name");
                    if (!entry.containsKey(blockName)) continue;
                    throw new DuplicateException("same sql fragment name: '" + blockName + "' in " + filename);
                }
                Matcher m_part = PART_PATTERN.matcher(trimLine);
                if (m_part.matches()) {
                    blockName = "${" + m_part.group("part") + "}";
                    if (!entry.containsKey(blockName)) continue;
                    throw new DuplicateException("same sql template name: '" + blockName + "' in " + filename);
                }
                if (trimLine.startsWith("--") && !StringUtil.startsWithsIgnoreCase((String)this.dynamicSqlParser.trimExpression(trimLine), (String[])SimpleScriptParser.TAGS) || blockName.equals("")) continue;
                sqlBodyBuffer.add(line);
                if (!trimLine.endsWith(this.delimiter)) continue;
                String naSql = SqlUtil.removeAnnotationBlock(String.join((CharSequence)"\n", sqlBodyBuffer));
                entry.put(blockName, naSql.substring(0, naSql.lastIndexOf(this.delimiter)).trim());
                log.debug("scan {} to get sql({}) [{}.{}]\uff1a{}", new Object[]{filename, this.delimiter, alias, blockName, SqlUtil.buildPrintSql((String)entry.get(blockName), this.highlightSql)});
                blockName = "";
                sqlBodyBuffer.clear();
            }
            if (!blockName.equals("")) {
                String lastSql = String.join((CharSequence)"\n", sqlBodyBuffer);
                entry.put(blockName, SqlUtil.removeAnnotationBlock(lastSql));
                log.debug("scan {} to get sql({}) [{}.{}]\uff1a{}", new Object[]{filename, this.delimiter, alias, blockName, SqlUtil.buildPrintSql(lastSql, this.highlightSql)});
            }
        }
        if (!entry.isEmpty()) {
            this.mergeSqlTemplate(entry);
        }
        resource.setEntry(Collections.unmodifiableMap(entry));
        resource.setLastModified(fileResource.getLastModified());
        return resource;
    }

    protected void mergeSqlTemplate(Map<String, String> sqlResource) {
        for (String string : sqlResource.keySet()) {
            if (!string.startsWith("${")) continue;
            for (Map.Entry<String, String> e : sqlResource.entrySet()) {
                String sql = e.getValue();
                String sqlPart = sqlResource.get(string);
                String holder = string.substring(2, string.length() - 1);
                sql = StringUtil.format((String)sql, (String)holder, (Object)sqlPart);
                e.setValue(sql);
            }
        }
        if (this.constants != null && !this.constants.isEmpty()) {
            for (Map.Entry entry : sqlResource.entrySet()) {
                String sql = (String)entry.getValue();
                for (Map.Entry constE : this.constants.entrySet()) {
                    sql = StringUtil.format((String)sql, (String)((String)constE.getKey()), constE.getValue());
                }
                entry.setValue(sql);
            }
        }
    }

    protected void loadResource() {
        try {
            this.resources.entrySet().removeIf(e -> !this.files.containsKey(e.getKey()));
            for (Map.Entry fileE : this.files.entrySet()) {
                String alias = (String)fileE.getKey();
                String filename = (String)fileE.getValue();
                FileResource cr = new FileResource(filename);
                if (cr.exists()) {
                    String suffix = cr.getFilenameExtension();
                    if (suffix == null || !suffix.equals("sql") && !suffix.equals("xql")) continue;
                    if (this.resources.containsKey(alias)) {
                        Resource resource = this.resources.get(alias);
                        long oldLastModified = resource.getLastModified();
                        long lastModified = cr.getLastModified();
                        if (oldLastModified == -1L || oldLastModified == 0L || oldLastModified == lastModified) continue;
                        this.putResource(alias, filename, cr);
                        log.debug("reload modified sql file: " + filename);
                        continue;
                    }
                    this.putResource(alias, filename, cr);
                    continue;
                }
                throw new FileNotFoundException("sql file '" + filename + "' of name '" + alias + "' not found!");
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException("load sql file error: ", e2);
        }
        catch (URISyntaxException e3) {
            throw new RuntimeException("sql file uri syntax error: ", e3);
        }
    }

    protected void loadPipes() {
        if (!this.pipes.isEmpty()) {
            try {
                for (Map.Entry entry : this.pipes.entrySet()) {
                    this.pipeInstances.put(entry.getKey(), (IPipe)ReflectUtil.getInstance(Class.forName((String)entry.getValue()), (Object[])new Object[0]));
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("init pipe error: ", e);
            }
        }
        if (log.isDebugEnabled() && !this.pipeInstances.isEmpty()) {
            log.debug("loaded pipes {}", (Object)this.pipeInstances);
        }
    }

    public void init() {
        this.lock.lock();
        try {
            this.loading = true;
            this.loadResource();
            this.loadPipes();
            if (this.checkModified.booleanValue()) {
                if (this.watchDog == null) {
                    this.watchDog = new WatchDog(1);
                    this.watchDog.addListener("sqlFileUpdateListener", this::loadResource, this.checkPeriod.intValue(), TimeUnit.SECONDS);
                }
            } else if (this.watchDog != null) {
                this.watchDog.removeListener("sqlFileUpdateListener");
                this.watchDog.shutdown();
            }
        }
        finally {
            this.loading = false;
            this.initialized = true;
            this.lock.unlock();
        }
    }

    public void look() {
        this.foreach((k, v) -> v.getEntry().forEach((n, o) -> {
            Color color = Color.PURPLE;
            if (n.startsWith("${")) {
                color = Color.GREEN;
            }
            String prefix = k + "." + n;
            if (this.highlightSql.booleanValue()) {
                prefix = Printer.colorful((String)prefix, (Color)color);
            }
            System.out.println(prefix + " -> " + SqlUtil.buildPrintSql(o, this.highlightSql));
        }));
    }

    public void foreach(BiConsumer<String, Resource> krFunc) {
        this.resources.forEach(krFunc);
    }

    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        this.foreach((k, r) -> r.getEntry().keySet().forEach(n -> names.add(k + "." + n)));
        return names;
    }

    public int size() {
        int i = 0;
        for (Resource resource : this.resources.values()) {
            i += resource.getEntry().size();
        }
        return i;
    }

    public boolean contains(String name) {
        String alias = name.substring(0, name.indexOf("."));
        if (!this.resources.containsKey(alias)) {
            return false;
        }
        String sqlName = name.substring(name.indexOf(".") + 1);
        return this.getResource(alias).getEntry().containsKey(sqlName);
    }

    public Resource getResource(String alias) {
        return this.resources.get(alias);
    }

    public Map<String, Resource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public boolean containsResource(String alias) {
        return this.resources.containsKey(alias);
    }

    public void clearResources() {
        this.resources.clear();
    }

    public String get(String name) {
        String sqlName;
        Map<String, String> singleResource;
        String alias = name.substring(0, name.indexOf("."));
        if (this.resources.containsKey(alias) && (singleResource = this.getResource(alias).getEntry()).containsKey(sqlName = name.substring(name.indexOf(".") + 1))) {
            return SqlUtil.trimEnd(singleResource.get(sqlName));
        }
        throw new NoSuchElementException(String.format("no SQL named [%s] was found.", name));
    }

    public String get(String name, Map<String, ?> args, boolean checkArgsKey) {
        String sql = this.get(name);
        if (!StringUtil.containsAnyIgnoreCase((String)sql, (String[])SimpleScriptParser.TAGS)) {
            return sql;
        }
        try {
            sql = this.dynamicSqlParser.parse(sql, args, checkArgsKey);
            return SqlUtil.repairSyntaxError(sql);
        }
        catch (Exception e) {
            throw new ScriptSyntaxException("an error occurred when getting dynamic sql of name: " + name, (Throwable)e);
        }
    }

    public String get(String name, Map<String, ?> args) {
        return this.get(name, args, true);
    }

    public String getConstant(String key) {
        return (String)this.constants.get(key);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public DynamicSqlParser dynamicSqlParser() {
        return this.dynamicSqlParser;
    }

    @Override
    public void close() {
        this.clearFiles();
        this.clearResources();
        this.pipes.clear();
        this.pipeInstances.clear();
        this.constants.clear();
        if (this.watchDog != null) {
            this.watchDog.shutdown();
        }
    }

    public class Resource {
        private final String alias;
        private final String filename;
        private long lastModified = -1L;
        private Map<String, String> entry;

        public Resource(String alias, String filename) {
            this.alias = alias;
            this.filename = filename;
            this.entry = Collections.emptyMap();
        }

        public boolean refresh() {
            if (XQLFileManager.this.isLoading()) {
                return false;
            }
            try {
                FileResource fileResource = new FileResource(this.filename);
                if (fileResource.getLastModified() == this.lastModified) {
                    return false;
                }
                Resource resource = XQLFileManager.this.parse(this.alias, this.filename, fileResource);
                this.setEntry(resource.getEntry());
                this.setLastModified(resource.getLastModified());
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException("load sql file error: ", e);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("sql file uri syntax error: ", e);
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }

        public Map<String, String> getEntry() {
            return this.entry;
        }

        void setEntry(Map<String, String> entry) {
            if (entry == null) {
                return;
            }
            this.entry = entry;
        }
    }

    public class DynamicSqlParser
    extends SimpleScriptParser {
        protected IExpression expression(String expression) {
            FastExpression fastExpression = new FastExpression(expression);
            fastExpression.setPipes(XQLFileManager.this.getPipeInstances());
            return fastExpression;
        }

        protected String forLoopBodyFormatter(String body, Map<String, Object> args) {
            return XQLFileManager.this.getSqlTranslator().formatSql(body, args);
        }

        protected String trimExpression(String line) {
            String expAnon;
            String trimS = line.trim();
            if (trimS.startsWith("--") && (expAnon = trimS.substring(2).trim()).startsWith("#")) {
                return expAnon;
            }
            return trimS;
        }
    }
}

