/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql;

import com.github.chengyuxing.common.io.FileResource;
import com.github.chengyuxing.common.io.TypedProperties;
import com.github.chengyuxing.common.script.IPipe;
import com.github.chengyuxing.sql.exceptions.YamlDeserializeException;
import com.github.chengyuxing.sql.utils.SqlTranslator;
import com.github.chengyuxing.sql.yaml.JoinConstructor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class XQLFileManagerConfig {
    private static final Logger log = LoggerFactory.getLogger(XQLFileManagerConfig.class);
    private SqlTranslator sqlTranslator;
    protected volatile boolean loading;
    protected Map<String, String> files = new HashMap<String, String>();
    @Deprecated
    protected Set<String> filenames = new HashSet<String>();
    protected Map<String, String> constants = new HashMap<String, String>();
    protected Map<String, IPipe<?>> pipeInstances = new HashMap();
    protected Map<String, String> pipes = new HashMap<String, String>();
    protected Integer checkPeriod = 30;
    protected volatile Boolean checkModified = false;
    protected String charset = "UTF-8";
    protected String delimiter = ";";
    protected Character namedParamPrefix = Character.valueOf(':');
    protected Boolean highlightSql = false;

    public XQLFileManagerConfig() {
        this.sqlTranslator = new SqlTranslator(this.namedParamPrefix.charValue());
    }

    public XQLFileManagerConfig(String configLocation) {
        this();
        FileResource resource = new FileResource(configLocation);
        if (configLocation.endsWith(".yml")) {
            this.loadYaml(resource);
            return;
        }
        if (configLocation.endsWith(".properties")) {
            this.loadProperties(resource);
            return;
        }
        throw new IllegalArgumentException("Not support file type: " + configLocation);
    }

    public void loadYaml(FileResource yamlLocation) {
        Yaml yaml = new Yaml((BaseConstructor)new JoinConstructor());
        try {
            XQLFileManagerConfig config = (XQLFileManagerConfig)yaml.loadAs(yamlLocation.getInputStream(), XQLFileManagerConfig.class);
            if (config == null) {
                log.warn("yaml loaded nothing, resource length is " + yamlLocation.getInputStream().available());
                return;
            }
            config.copyStateTo(this);
        }
        catch (Exception e) {
            throw new YamlDeserializeException("load yaml config error: ", e);
        }
    }

    public void loadProperties(FileResource propertiesLocation) {
        TypedProperties properties = new TypedProperties();
        try {
            properties.load(propertiesLocation.getInputStream());
            HashMap<String, String> localFiles = new HashMap<String, String>();
            HashMap<String, String> localConstants = new HashMap<String, String>();
            HashMap<String, String> localPipes = new HashMap<String, String>();
            properties.forEach((k, s) -> {
                String p = k.toString().trim();
                String v = s.toString().trim();
                if (!p.equals("") && !v.equals("")) {
                    if (p.startsWith("files.")) {
                        localFiles.put(p.substring(6), v);
                    } else if (p.startsWith("constants.")) {
                        localConstants.put(p.substring(10), v);
                    } else if (p.startsWith("pipes.")) {
                        localPipes.put(p.substring(6), v);
                    }
                }
            });
            this.setFiles(localFiles);
            this.setConstants(localConstants);
            this.setPipes(localPipes);
            this.setDelimiter(properties.getProperty("delimiter"));
            this.setCharset(properties.getProperty("charset"));
            this.setNamedParamPrefix(Character.valueOf(properties.getProperty("namedParamPrefix", ":").charAt(0)));
            this.setHighlightSql(properties.getBool("highlightSql"));
            this.setCheckPeriod(properties.getInt("checkPeriod"));
            this.setCheckModified(properties.getBool("checkModified"));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void copyStateTo(XQLFileManagerConfig other) {
        Field[] fields;
        for (Field field : fields = XQLFileManagerConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                Object v = field.get(this);
                if (v == null) continue;
                field.set(other, v);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to copy XQLFileManagerConfig state: " + e.getMessage(), e);
            }
        }
    }

    protected void checkLoading() {
        if (this.loading) {
            throw new ConcurrentModificationException("Cannot set property while loading.");
        }
    }

    public SqlTranslator getSqlTranslator() {
        return this.sqlTranslator;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public Map<String, String> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, String> files) {
        if (files == null) {
            return;
        }
        this.files = new HashMap<String, String>(files);
    }

    public Map<String, String> getConstants() {
        return this.constants;
    }

    public void setConstants(Map<String, String> constants) {
        if (constants == null) {
            return;
        }
        this.checkLoading();
        this.constants = new HashMap<String, String>(constants);
    }

    public Map<String, IPipe<?>> getPipeInstances() {
        return this.pipeInstances;
    }

    public void setPipeInstances(Map<String, IPipe<?>> pipeInstances) {
        if (pipeInstances == null) {
            return;
        }
        this.pipeInstances = new HashMap(pipeInstances);
    }

    public Map<String, String> getPipes() {
        return this.pipes;
    }

    public void setPipes(Map<String, String> pipes) {
        if (pipes == null) {
            return;
        }
        this.pipes = new HashMap<String, String>(pipes);
    }

    public Integer getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(Integer checkPeriod) {
        if (checkPeriod == null) {
            return;
        }
        if (checkPeriod < 5) {
            this.checkPeriod = 5;
            log.warn("period cannot less than 5 seconds, auto set 5 seconds.");
        } else {
            this.checkPeriod = checkPeriod;
        }
    }

    public Boolean isCheckModified() {
        return this.checkModified;
    }

    public void setCheckModified(Boolean checkModified) {
        if (checkModified == null) {
            return;
        }
        this.checkModified = checkModified;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        if (charset == null) {
            return;
        }
        this.checkLoading();
        this.charset = charset;
    }

    public void setCharset(Charset charset) {
        if (charset == null) {
            return;
        }
        this.checkLoading();
        this.charset = charset.name();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter == null || delimiter.trim().equals("")) {
            return;
        }
        this.checkLoading();
        this.delimiter = delimiter;
    }

    public Character getNamedParamPrefix() {
        return this.namedParamPrefix;
    }

    public void setNamedParamPrefix(Character namedParamPrefix) {
        if (namedParamPrefix == null || namedParamPrefix.charValue() == ' ') {
            return;
        }
        this.namedParamPrefix = namedParamPrefix;
        this.sqlTranslator = new SqlTranslator(this.namedParamPrefix.charValue());
    }

    public Boolean isHighlightSql() {
        return this.highlightSql;
    }

    public void setHighlightSql(Boolean highlightSql) {
        if (highlightSql == null) {
            return;
        }
        this.highlightSql = highlightSql;
    }

    @Deprecated
    public Set<String> getFilenames() {
        return this.filenames;
    }

    @Deprecated
    public void setFilenames(Set<String> filenames) {
        this.filenames = filenames;
    }
}

