/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.datasource;

import com.github.chengyuxing.sql.datasource.AbstractTransactionSyncManager;
import com.github.chengyuxing.sql.datasource.ConnectionHolder;
import com.github.chengyuxing.sql.exceptions.ConnectionStatusException;
import com.github.chengyuxing.sql.exceptions.UncheckedSqlException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public abstract class DataSourceUtil {
    public static Connection getConnection(DataSource dataSource) throws SQLException {
        return DataSourceUtil.doGetConnection(dataSource);
    }

    private static Connection doGetConnection(DataSource dataSource) throws SQLException {
        ConnectionHolder connectionHolder = AbstractTransactionSyncManager.getResource(dataSource);
        if (connectionHolder != null && (connectionHolder.hasConnection() || connectionHolder.isSyncWithTransaction())) {
            connectionHolder.requested();
            if (!connectionHolder.hasConnection()) {
                connectionHolder.setConnection(DataSourceUtil.fetchConnection(dataSource));
            }
            return connectionHolder.getConnection();
        }
        Connection connection = DataSourceUtil.fetchConnection(dataSource);
        if (AbstractTransactionSyncManager.isTransactionActive()) {
            ConnectionHolder holderToUse = connectionHolder;
            if (holderToUse == null) {
                holderToUse = new ConnectionHolder(connection);
            } else {
                holderToUse.setConnection(connection);
            }
            holderToUse.requested();
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(AbstractTransactionSyncManager.getCurrentTransactionIsolationLevel());
            connection.setReadOnly(AbstractTransactionSyncManager.isCurrentTransactionReadOnly());
            AbstractTransactionSyncManager.registerSynchronization(new TransactionSynchronization(holderToUse, dataSource));
            holderToUse.setSyncWithTransaction(true);
            if (holderToUse != connectionHolder) {
                AbstractTransactionSyncManager.bindResource(dataSource, holderToUse);
            }
        }
        return connection;
    }

    private static void doCloseConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public static void releaseConnection(Connection connection, DataSource dataSource) {
        try {
            DataSourceUtil.doReleaseConnection(connection, dataSource);
        }
        catch (SQLException e) {
            throw new UncheckedSqlException("Couldn't close JDBC connection:{}", e);
        }
    }

    private static void doReleaseConnection(Connection connection, DataSource dataSource) throws SQLException {
        ConnectionHolder holder;
        if (connection == null) {
            return;
        }
        if (dataSource != null && (holder = AbstractTransactionSyncManager.getResource(dataSource)) != null && DataSourceUtil.connectionEquals(holder, connection)) {
            holder.released();
            return;
        }
        DataSourceUtil.doCloseConnection(connection);
    }

    public static boolean isConnectionTransactional(Connection con, DataSource dataSource) {
        if (dataSource == null) {
            return false;
        }
        ConnectionHolder conHolder = AbstractTransactionSyncManager.getResource(dataSource);
        return conHolder != null && DataSourceUtil.connectionEquals(conHolder, con);
    }

    private static boolean connectionEquals(ConnectionHolder holder, Connection passedInConn) {
        if (!holder.hasConnection()) {
            return false;
        }
        Connection heldConn = holder.getConnection();
        return heldConn == passedInConn || heldConn.equals(passedInConn);
    }

    private static Connection fetchConnection(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        if (connection == null) {
            throw new ConnectionStatusException("DataSource returned null from DataSource:" + dataSource);
        }
        return connection;
    }

    public static class TransactionSynchronization {
        private final ConnectionHolder connectionHolder;
        private final DataSource dataSource;

        public TransactionSynchronization(ConnectionHolder connectionHolder, DataSource dataSource) {
            this.connectionHolder = connectionHolder;
            this.dataSource = dataSource;
        }

        public ConnectionHolder getConnectionHolder() {
            return this.connectionHolder;
        }

        public void afterCompletion() {
            AbstractTransactionSyncManager.unbindResource(this.dataSource);
            if (this.connectionHolder.hasConnection()) {
                DataSourceUtil.releaseConnection(this.connectionHolder.getConnection(), null);
                this.connectionHolder.setConnection(null);
            }
            this.connectionHolder.clear();
        }
    }
}

