/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.page;

import com.github.chengyuxing.common.DataRow;
import com.github.chengyuxing.sql.PagedResource;
import com.github.chengyuxing.sql.page.PageHelperProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class IPageable {
    protected Map<String, Object> args = new HashMap<String, Object>();
    protected final String recordQuery;
    protected String countQuery;
    protected final int page;
    protected final int size;
    protected Integer count;
    protected boolean disablePageSql;
    protected Function<Map<String, Integer>, Map<String, Integer>> rewriteArgsFunc;
    protected PageHelperProvider pageHelperProvider;

    public IPageable(String recordQuery, int page, int size) {
        this.recordQuery = recordQuery;
        this.page = page;
        this.size = size;
    }

    public IPageable args(Map<String, Object> args) {
        if (args != null) {
            this.args = args;
        }
        return this;
    }

    public IPageable count(String countQuery) {
        this.countQuery = countQuery;
        return this;
    }

    public IPageable count(Integer count) {
        this.count = count;
        return this;
    }

    public IPageable disableDefaultPageSql(String countQuery) {
        this.disablePageSql = true;
        this.countQuery = countQuery;
        return this;
    }

    public IPageable rewriteDefaultPageArgs(Function<Map<String, Integer>, Map<String, Integer>> func) {
        this.rewriteArgsFunc = func;
        return this;
    }

    public IPageable pageHelper(PageHelperProvider pageHelperProvider) {
        this.pageHelperProvider = pageHelperProvider;
        return this;
    }

    public abstract <T> PagedResource<T> collect(Function<DataRow, T> var1);

    public PagedResource<DataRow> collect() {
        return this.collect(Function.identity());
    }
}

