/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.support;

import com.github.chengyuxing.common.DataRow;
import com.github.chengyuxing.common.UncheckedCloseable;
import com.github.chengyuxing.common.tuple.Pair;
import com.github.chengyuxing.common.utils.CollectionUtil;
import com.github.chengyuxing.common.utils.StringUtil;
import com.github.chengyuxing.sql.exceptions.UncheckedSqlException;
import com.github.chengyuxing.sql.support.SqlParser;
import com.github.chengyuxing.sql.support.StatementCallback;
import com.github.chengyuxing.sql.types.Param;
import com.github.chengyuxing.sql.types.ParamMode;
import com.github.chengyuxing.sql.utils.JdbcUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcSupport
extends SqlParser {
    private static final Logger log = LoggerFactory.getLogger(JdbcSupport.class);

    protected abstract DataSource getDataSource();

    protected abstract Connection getConnection();

    protected abstract void releaseConnection(Connection var1, DataSource var2);

    protected abstract boolean checkParameterType();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T execute(String sql, StatementCallback<T> callback) {
        T t;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement(sql);
            t = callback.doInStatement(statement);
        }
        catch (SQLException e) {
            try {
                try {
                    JdbcUtil.closeStatement(statement);
                }
                catch (SQLException ex) {
                    e.addSuppressed(ex);
                }
                statement = null;
                this.releaseConnection(connection, this.getDataSource());
                throw new UncheckedSqlException("execute sql:\n[" + sql + "]", e);
            }
            catch (Throwable throwable) {
                try {
                    JdbcUtil.closeStatement(statement);
                }
                catch (SQLException e2) {
                    log.error("close statement error:", (Throwable)e2);
                }
                this.releaseConnection(connection, this.getDataSource());
                throw throwable;
            }
        }
        try {
            JdbcUtil.closeStatement(statement);
        }
        catch (SQLException e) {
            log.error("close statement error:", (Throwable)e);
        }
        this.releaseConnection(connection, this.getDataSource());
        return t;
    }

    public DataRow execute(String sql, Map<String, ?> args) {
        Pair<String, List<String>> p = this.parse(sql, args);
        List argNames = (List)p.getItem2();
        String preparedSql = (String)p.getItem1();
        try {
            return this.execute(preparedSql, (PreparedStatement sc) -> {
                DataRow result;
                JdbcUtil.setSqlTypedArgs(sc, this.checkParameterType(), args, argNames);
                boolean isQuery = sc.execute();
                this.printSqlConsole(sc);
                if (isQuery) {
                    ResultSet resultSet = sc.getResultSet();
                    List<DataRow> rows = JdbcUtil.createDataRows(resultSet, preparedSql, -1L);
                    JdbcUtil.closeResultSet(resultSet);
                    result = rows.size() == 1 ? DataRow.fromPair((Object[])new Object[]{"result", rows.get(0), "type", "QUERY"}) : DataRow.of((String[])new String[]{"result", "type"}, (Object[])new Object[]{rows, "QUERY"});
                } else {
                    int count = sc.getUpdateCount();
                    result = DataRow.fromPair((Object[])new Object[]{"result", count, "type", "DD(M)L"});
                }
                return result;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("prepare sql error:\n[" + sql + "]\n" + args, e);
        }
    }

    public Stream<DataRow> executeQueryStream(String sql, Map<String, ?> args) {
        Pair<String, List<String>> preparedSqlAndArgNames = this.parse(sql, args);
        List argNames = (List)preparedSqlAndArgNames.getItem2();
        final String preparedSql = (String)preparedSqlAndArgNames.getItem1();
        UncheckedCloseable close = null;
        try {
            Connection connection = this.getConnection();
            close = UncheckedCloseable.wrap(() -> this.releaseConnection(connection, this.getDataSource()));
            PreparedStatement statement = connection.prepareStatement(preparedSql);
            close = close.nest((AutoCloseable)statement);
            JdbcUtil.setSqlTypedArgs(statement, this.checkParameterType(), args, argNames);
            final ResultSet resultSet = statement.executeQuery();
            close = close.nest((AutoCloseable)resultSet);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<DataRow>(Long.MAX_VALUE, 16){
                String[] names;
                {
                    super(x0, x1);
                    this.names = null;
                }

                @Override
                public boolean tryAdvance(Consumer<? super DataRow> action) {
                    try {
                        if (!resultSet.next()) {
                            return false;
                        }
                        if (this.names == null) {
                            this.names = JdbcUtil.createNames(resultSet, preparedSql);
                        }
                        action.accept((DataRow)JdbcUtil.createDataRow(this.names, resultSet));
                        return true;
                    }
                    catch (SQLException ex) {
                        throw new UncheckedSqlException("reading result set of query: [" + preparedSql + "]\nerror: ", ex);
                    }
                }
            }, false).onClose((Runnable)close);
        }
        catch (Exception ex) {
            if (close != null) {
                try {
                    close.close();
                }
                catch (Exception e) {
                    ex.addSuppressed(e);
                }
            }
            throw new RuntimeException("\nstreaming query error: \n[" + sql + "]\n[" + preparedSql + "]\n" + args, ex);
        }
    }

    public int[] executeBatch(List<String> sqls) {
        if (sqls.size() > 0) {
            Statement statement = null;
            Connection connection = this.getConnection();
            if (JdbcUtil.supportsBatchUpdates(connection)) {
                try {
                    statement = connection.createStatement();
                    Map empty = Collections.emptyMap();
                    for (String sql : sqls) {
                        if (StringUtil.isEmpty((String)sql)) continue;
                        statement.addBatch(this.getSql(sql, empty));
                    }
                    Object object = statement.executeBatch();
                    return object;
                }
                catch (SQLException e) {
                    try {
                        JdbcUtil.closeStatement(statement);
                    }
                    catch (SQLException ex) {
                        e.addSuppressed(ex);
                    }
                    statement = null;
                    this.releaseConnection(connection, this.getDataSource());
                    throw new UncheckedSqlException("execute batch error: ", e);
                }
                finally {
                    try {
                        JdbcUtil.closeStatement(statement);
                    }
                    catch (SQLException e) {
                        log.error("close statement error: ", (Throwable)e);
                    }
                    this.releaseConnection(connection, this.getDataSource());
                }
            }
            throw new UnsupportedOperationException("your database or jdbc driver not support batch execute currently!");
        }
        throw new IllegalArgumentException("must not be less than one SQL.");
    }

    public int executeNonQuery(String sql, Collection<? extends Map<String, ?>> args) {
        Map<String, ?> first = args.iterator().next();
        Pair<String, List<String>> preparedSqlAndArgNames = this.parse(sql, first);
        List argNames = (List)preparedSqlAndArgNames.getItem2();
        String preparedSql = (String)preparedSqlAndArgNames.getItem1();
        try {
            return this.execute(preparedSql, (PreparedStatement sc) -> {
                if (args.isEmpty()) {
                    return sc.executeUpdate();
                }
                Iterator iterator = args.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    JdbcUtil.setSqlTypedArgs(sc, this.checkParameterType(), (Map)iterator.next(), argNames);
                    i += sc.executeUpdate();
                }
                return i;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("prepare sql error:\n[" + sql + "]\n" + args, e);
        }
    }

    public DataRow executeCallStatement(String procedure, Map<String, Param> args) {
        Pair<String, List<String>> preparedSqlAndArgNames = this.parse(procedure, args);
        String executeSql = (String)preparedSqlAndArgNames.getItem1();
        List argNames = (List)preparedSqlAndArgNames.getItem2();
        CallableStatement statement = null;
        Connection connection = this.getConnection();
        try {
            DataRow values;
            statement = connection.prepareCall(executeSql);
            ArrayList<String> outNames = new ArrayList<String>();
            if (!args.isEmpty()) {
                JdbcUtil.setStoreArgs(statement, args, argNames);
                for (String name : argNames) {
                    ParamMode mode;
                    if (!args.containsKey(name) && !CollectionUtil.containsKeyIgnoreCase(args, (String)name)) continue;
                    ParamMode paramMode = mode = args.containsKey(name) ? args.get(name).getParamMode() : ((Param)CollectionUtil.getValueIgnoreCase(args, (String)name)).getParamMode();
                    if (mode != ParamMode.OUT && mode != ParamMode.IN_OUT) continue;
                    outNames.add(name);
                }
            }
            statement.execute();
            this.printSqlConsole(statement);
            if (outNames.size() > 0) {
                values = new Object[outNames.size()];
                int resultIndex = 0;
                for (int i = 0; i < argNames.size(); ++i) {
                    String name = (String)argNames.get(i);
                    if (!outNames.contains(name)) continue;
                    Object result = statement.getObject(i + 1);
                    if (null == result) {
                        values[resultIndex] = null;
                    } else if (result instanceof ResultSet) {
                        List<DataRow> rows = JdbcUtil.createDataRows((ResultSet)result, executeSql, -1L);
                        JdbcUtil.closeResultSet((ResultSet)result);
                        values[resultIndex] = rows;
                        log.debug("boxing a result with type: cursor, convert to ArrayList<DataRow>, get result by name:{}!", outNames.get(resultIndex));
                    } else {
                        values[resultIndex] = result;
                        log.debug("boxing a result, get result by name:{}!", outNames.get(resultIndex));
                    }
                    ++resultIndex;
                }
                DataRow dataRow = DataRow.of((String[])outNames.toArray(new String[0]), (Object[])values);
                return dataRow;
            }
            values = new DataRow(0);
            return values;
        }
        catch (SQLException e) {
            try {
                JdbcUtil.closeStatement(statement);
            }
            catch (SQLException ex) {
                e.addSuppressed(ex);
            }
            statement = null;
            this.releaseConnection(connection, this.getDataSource());
            throw new UncheckedSqlException("execute procedure error: \n[" + procedure + "]\n" + args, e);
        }
        finally {
            try {
                JdbcUtil.closeStatement(statement);
            }
            catch (SQLException e) {
                log.error("close statement error: ", (Throwable)e);
            }
            this.releaseConnection(connection, this.getDataSource());
        }
    }

    private void printSqlConsole(Statement sc) {
        if (log.isWarnEnabled()) {
            try {
                SQLWarning warning = sc.getWarnings();
                if (warning != null) {
                    String state = warning.getSQLState();
                    sc.getWarnings().forEach(r -> log.warn("[{}] [{}] {}", new Object[]{LocalDateTime.now(), state, r.getMessage()}));
                }
            }
            catch (SQLException e) {
                log.error("get sql warning error: ", (Throwable)e);
            }
        }
    }
}

