/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.support;

import com.github.chengyuxing.common.utils.StringUtil;
import java.sql.DatabaseMetaData;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@FunctionalInterface
public interface SqlInterceptor {
    public boolean prevHandle(String var1, Map<String, ?> var2, DatabaseMetaData var3) throws Throwable;

    public static class DefaultSqlInterceptor
    implements SqlInterceptor {
        private final Pattern CRITERIA = Pattern.compile("(?<a>[\\w._]+)\\s*=\\s*(?<b>[\\w._]+)");

        @Override
        public boolean prevHandle(String sql, Map<String, ?> args, DatabaseMetaData metaData) throws Throwable {
            if (StringUtil.isEmpty((String)sql)) {
                return false;
            }
            String mySql = sql.trim();
            if (StringUtil.startsWithsIgnoreCase((String)mySql, (String[])new String[]{"drop", "create", "alter"})) {
                return false;
            }
            if (StringUtil.startsWithIgnoreCase((String)mySql, (String)"delete")) {
                if (!StringUtil.containsIgnoreCase((String)mySql, (String)"where")) {
                    return false;
                }
                Matcher m = this.CRITERIA.matcher(mySql);
                if (m.find()) {
                    return !m.group("a").equals(m.group("b"));
                }
            }
            return true;
        }
    }
}

