/*
 * Decompiled with CFR 0.152.
 */
package com.github.chengyuxing.sql.support;

import com.github.chengyuxing.common.tuple.Pair;
import com.github.chengyuxing.sql.utils.SqlTranslator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlParser {
    private static final Logger log = LoggerFactory.getLogger(SqlParser.class);

    protected abstract String getSql(String var1, Map<String, ?> var2);

    protected abstract SqlTranslator sqlTranslator();

    protected Pair<String, List<String>> parse(String sql, Map<String, ?> args) {
        if (args == null) {
            args = Collections.emptyMap();
        }
        String fullSql = this.getSql(sql, args);
        Pair<String, List<String>> p = this.sqlTranslator().getPreparedSql(fullSql, args);
        log.debug("Prepared SQL: {}", p.getItem1());
        return p;
    }
}

